/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.inputgui;

import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.workbench.ParamsReceiver;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.inputgui.AbstractParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.Common;
import es.uvigo.ei.aibench.workbench.utilities.FileDrop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FileParamProvider
extends AbstractParamProvider {
    private static final Logger LOG = Logger.getLogger(FileParamProvider.class);
    private final JTextField field = new JTextField();
    private final JButton findButton = new JButton(Common.ICON_FILE_OPEN);
    private FileChooserConfiguration fcConfiguration = new FileChooserConfiguration();
    public static final String FILTERS_EXTRAS_PROPERTY = "filters";
    public static final String FILTERS_EXTRAS_ALLOWALL_FILTER = "allowAll";
    public static final String FILTERS_EXTRAS_SELECTION_MODE = "selectionMode";
    private JComponent component = null;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.findButton) {
            this.showFileChooser();
        }
        super.actionPerformed(e);
    }

    private void showFileChooser() {
        File selected;
        this.fcConfiguration.configureFileChooser(Common.SINGLE_FILE_CHOOSER);
        int option = Common.SINGLE_FILE_CHOOSER.showDialog(Workbench.getInstance().getMainFrame(), "Select");
        if (option == 0 && (selected = Common.SINGLE_FILE_CHOOSER.getSelectedFile()) != null) {
            this.field.setText(selected.getPath());
        }
        this.fcConfiguration.clearFileChooser(Common.SINGLE_FILE_CHOOSER);
    }

    public FileParamProvider(ParamsReceiver receiver, Port p, Class<?> clazz, Object operationObject) {
        super(receiver, p, clazz, operationObject);
        this.field.setEditable(false);
        if (p.defaultValue().length() > 0) {
            this.field.setText(p.defaultValue());
        }
        this.createFilters(p);
    }

    public static void configureFileChooser(Port p, JFileChooser fc) {
        FileChooserConfiguration configuration = new FileChooserConfiguration(p.extras());
        configuration.configureFileChooser(fc);
    }

    private void createFilters(Port p) {
        this.fcConfiguration.reset();
        this.fcConfiguration.configure(p.extras());
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new JPanel();
            this.component.setLayout(new BorderLayout());
            this.field.setPreferredSize(new Dimension(150, this.field.getPreferredSize().height));
            this.findButton.setToolTipText("Browse the local filesystem to select a file");
            this.component.add((Component)this.field, "Center");
            this.component.add((Component)this.findButton, "East");
            new FileDrop(this.field, new FileDrop.Listener(){

                @Override
                public void filesDropped(File[] files) {
                    if (files.length > 0) {
                        FileParamProvider.this.field.setText(files[0].getPath());
                        FileParamProvider.this.setChanged();
                        FileParamProvider.this.notifyObservers();
                    }
                }
            });
            this.field.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FileParamProvider.this.showFileChooser();
                    FileParamProvider.this.setChanged();
                    FileParamProvider.this.notifyObservers();
                }
            });
            this.findButton.addActionListener(this);
        }
        return this.component;
    }

    @Override
    public ParamSpec getParamSpec() {
        if (this.field.getText().equals("")) {
            return new ParamSpec(this.port.name(), this.clazz, null, ParamSource.CLIPBOARD);
        }
        return new ParamSpec(this.port.name(), this.clazz, (Object)this.field.getText(), ParamSource.STRING_CONSTRUCTOR);
    }

    public JTextField getField() {
        return this.field;
    }

    @Override
    public boolean isValidValue() {
        if (!this.port.allowNull()) {
            return this.field.getText().trim().length() > 0;
        }
        return true;
    }

    static class FileChooserConfiguration {
        private final List<ExtensionFileFilter> filters = new ArrayList<ExtensionFileFilter>();
        private int selectionMode;
        private boolean allowAll;

        public FileChooserConfiguration() {
            this("");
        }

        public FileChooserConfiguration(String configuration) {
            this.reset();
            this.configure(configuration);
        }

        public void configure(String configurationString) {
            String[] props;
            if (configurationString == null || configurationString.trim().isEmpty()) {
                return;
            }
            for (String prop : props = configurationString.split(",")) {
                String[] propValue = prop.split("=");
                if (propValue.length == 2) {
                    propValue[0] = propValue[0].trim();
                    propValue[1] = propValue[1].trim();
                    if (propValue[0].equalsIgnoreCase(FileParamProvider.FILTERS_EXTRAS_PROPERTY)) {
                        String[] filters;
                        this.setAllowAll(false);
                        for (String filter : filters = propValue[1].split(";")) {
                            String[] nameExpAndDesc = filter.split(":");
                            if (nameExpAndDesc.length == 2) {
                                nameExpAndDesc[0] = nameExpAndDesc[0].trim();
                                nameExpAndDesc[1] = nameExpAndDesc[1].trim();
                                this.getFilters().add(new ExtensionFileFilter(nameExpAndDesc[0], nameExpAndDesc[1]));
                                continue;
                            }
                            if (nameExpAndDesc.length != 1) continue;
                            nameExpAndDesc[0] = nameExpAndDesc[0].trim();
                            if (nameExpAndDesc[0].equalsIgnoreCase(FileParamProvider.FILTERS_EXTRAS_ALLOWALL_FILTER)) {
                                this.setAllowAll(true);
                                continue;
                            }
                            LOG.warn((Object)("unable to parse a filter in extras: " + filter));
                        }
                        continue;
                    }
                    if (propValue[0].equalsIgnoreCase(FileParamProvider.FILTERS_EXTRAS_SELECTION_MODE)) {
                        if (propValue[1].equalsIgnoreCase("files")) {
                            this.setSelectionMode(0);
                            continue;
                        }
                        if (propValue[1].equalsIgnoreCase("directories")) {
                            this.setSelectionMode(1);
                            continue;
                        }
                        if (propValue[2].equalsIgnoreCase("filesAndDirectories")) {
                            this.setSelectionMode(2);
                            continue;
                        }
                        LOG.warn((Object)("unknown value for allowAll filter: " + propValue[1]));
                        this.setSelectionMode(2);
                        continue;
                    }
                    LOG.warn((Object)("unknown filter: " + propValue[0]));
                    continue;
                }
                LOG.warn((Object)("unable to parse a property in extras: " + prop));
            }
        }

        public void reset() {
            this.filters.clear();
            this.selectionMode = 2;
            this.allowAll = true;
        }

        public List<ExtensionFileFilter> getFilters() {
            return this.filters;
        }

        public int getSelectionMode() {
            return this.selectionMode;
        }

        public void setSelectionMode(int selectionMode) {
            this.selectionMode = selectionMode;
        }

        public boolean isAllowAll() {
            return this.allowAll;
        }

        public void setAllowAll(boolean allowAll) {
            this.allowAll = allowAll;
        }

        public void configureFileChooser(JFileChooser fc) {
            fc.setAcceptAllFileFilterUsed(this.isAllowAll());
            fc.setFileSelectionMode(this.getSelectionMode());
            for (ExtensionFileFilter filter : this.getFilters()) {
                fc.addChoosableFileFilter(filter);
            }
        }

        public void clearFileChooser(JFileChooser fc) {
            fc.setFileSelectionMode(2);
            fc.setAcceptAllFileFilterUsed(true);
            for (ExtensionFileFilter filter : this.getFilters()) {
                fc.removeChoosableFileFilter(filter);
            }
        }
    }

    static class ExtensionFileFilter
    extends FileFilter {
        String nameregexp;
        String description;

        public ExtensionFileFilter(String nameregexp, String desc) {
            this.nameregexp = nameregexp;
            this.description = desc;
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().matches(this.nameregexp);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

