/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.inputgui;

import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.workbench.ParamsReceiver;
import es.uvigo.ei.aibench.workbench.inputgui.AbstractParamProvider;
import java.awt.FlowLayout;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class EnumParamProvider
extends AbstractParamProvider {
    private ButtonGroup group = new ButtonGroup();
    private JPanel buttonPanel = new JPanel();
    private Object[] enumConstants;

    public EnumParamProvider(ParamsReceiver receiver, Port p, Class<?> clazz, Object operationObject) {
        super(receiver, p, clazz, operationObject);
        this.buttonPanel.setLayout(new FlowLayout());
        this.enumConstants = clazz.getEnumConstants();
        for (Object o : this.enumConstants) {
            JRadioButton button = new JRadioButton(o.toString());
            button.addActionListener(this);
            this.group.add(button);
            this.buttonPanel.add(button);
            if (!p.defaultValue().equals(o.toString())) continue;
            button.setSelected(true);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.buttonPanel;
    }

    @Override
    public ParamSpec getParamSpec() {
        int i = 0;
        Enumeration<AbstractButton> buttons = this.group.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (button.isSelected()) {
                return new ParamSpec(this.port.name(), this.clazz, this.enumConstants[i], ParamSource.ENUM);
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isValidValue() {
        return true;
    }
}

