/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.aibench.workbench.inputgui;

import es.uvigo.ei.aibench.core.Core;
import es.uvigo.ei.aibench.core.ParamSource;
import es.uvigo.ei.aibench.core.ParamSpec;
import es.uvigo.ei.aibench.core.clipboard.ClipboardItem;
import es.uvigo.ei.aibench.core.clipboard.ClipboardListener;
import es.uvigo.ei.aibench.core.operation.annotation.Port;
import es.uvigo.ei.aibench.workbench.ParamsReceiver;
import es.uvigo.ei.aibench.workbench.Workbench;
import es.uvigo.ei.aibench.workbench.inputgui.AbstractParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.ClipboardParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.Common;
import es.uvigo.ei.aibench.workbench.inputgui.FileParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.ParamProvider;
import es.uvigo.ei.aibench.workbench.inputgui.ParamProviderFactory;
import es.uvigo.ei.aibench.workbench.utilities.FileDrop;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class ArrayParamProvider
extends AbstractParamProvider
implements Observer {
    private static final int PREFERRED_FIELD_WIDTH = 200;
    static final ImageIcon ICON_ADD = new ImageIcon(ArrayParamProvider.class.getResource("images/add.png"));
    static final ImageIcon ICON_REMOVE = new ImageIcon(ArrayParamProvider.class.getResource("images/remove.png"));
    static final ImageIcon ICON_ADD_ONE = new ImageIcon(ArrayParamProvider.class.getResource("images/addOne.png"));
    static final ImageIcon ICON_ADD_ALL = new ImageIcon(ArrayParamProvider.class.getResource("images/addAll.png"));
    static final ImageIcon ICON_REMOVE_ONE = new ImageIcon(ArrayParamProvider.class.getResource("images/removeOne.png"));
    static final ImageIcon ICON_REMOVE_ALL = new ImageIcon(ArrayParamProvider.class.getResource("images/removeAll.png"));
    private static final String CARD_CLIPBOARD = "clipboard";
    private static final String CARD_NEW = "new";
    private DefaultListModel<Object> model = new DefaultListModel();
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JPanel newArrayPanel = new JPanel(new BorderLayout());
    private final JPanel arraySelector = new JPanel();
    private final JPanel cardPanel = new JPanel();
    private final CardLayout cardLayout = new CardLayout();
    private ArrayParamListener listener = null;
    private boolean componentInitialized = false;
    private boolean showingAll = false;
    boolean createNew = false;
    private String currentView = "clipboard";
    private final ClipboardParamProvider selectArray;
    int selectHeight;
    int newHeight;
    int preferredWidth;
    private ParamProvider newArrayParamProvider;
    private final JRadioButton radioCreate = new JRadioButton("create array");
    private final JRadioButton radioFromClipboard = new JRadioButton("select from clipboard");

    public ArrayParamProvider(ParamsReceiver receiver, Port p, Class<?> clazz, Object operationObject) {
        super(receiver, p, clazz, operationObject);
        this.selectArray = new ClipboardParamProvider(receiver, p, clazz, operationObject);
        this.cardPanel.setLayout(this.cardLayout);
        this.selectArray.addObserver(this);
    }

    private void initNewArrayComponent() {
        this.newArrayPanel.removeAll();
        final JList<Object> itemsList = new JList<Object>(this.model);
        JPanel upper = new JPanel(new BorderLayout());
        final Class<?> arrayType = this.clazz.getComponentType();
        assert (arrayType != null);
        JButton removeButton = new JButton(ICON_REMOVE_ONE);
        removeButton.setToolTipText("Remove selected items from list");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Object value : itemsList.getSelectedValuesList()) {
                    ArrayParamProvider.this.model.removeElement(value);
                }
                ArrayParamProvider.this.actionPerformed(e);
            }
        });
        JButton removeAllButton = new JButton(ICON_REMOVE_ALL);
        removeAllButton.setToolTipText("Clear list");
        removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayParamProvider.this.model.removeAllElements();
                ArrayParamProvider.this.actionPerformed(e);
            }
        });
        if (arrayType.equals(File.class)) {
            JButton selectMultipleFiles = new JButton("select files...", Common.ICON_FILE_OPEN);
            selectMultipleFiles.setToolTipText("Browse the local filesystem to select multiple files");
            selectMultipleFiles.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileParamProvider.configureFileChooser(ArrayParamProvider.this.port, Common.MULTIPLE_FILE_CHOOSER);
                    int option = Common.MULTIPLE_FILE_CHOOSER.showDialog(Workbench.getInstance().getMainFrame(), "Select Files");
                    if (option == 0) {
                        File[] selected;
                        for (File file : selected = Common.MULTIPLE_FILE_CHOOSER.getSelectedFiles()) {
                            ArrayParamProvider.this.model.addElement(new ParamSpecWrapper(new ParamSpec(ArrayParamProvider.this.port.name(), arrayType, (Object)file.getAbsolutePath(), ParamSource.STRING_CONSTRUCTOR)));
                        }
                    }
                    ArrayParamProvider.this.actionPerformed(e);
                }
            });
            JPanel buttons = new JPanel(new GridLayout(1, 2, 0, 0));
            buttons.add(removeButton);
            buttons.add(removeAllButton);
            upper.add((Component)selectMultipleFiles, "North");
            upper.add((Component)buttons, "South");
        } else {
            this.newArrayParamProvider = ParamProviderFactory.createParamProvider(this.getReceiver(), this.port, arrayType, this.operationObject);
            final boolean clipboardItems = this.newArrayParamProvider instanceof ClipboardParamProvider;
            JPanel buttons = new JPanel(new GridLayout(1, clipboardItems ? 4 : 3, 0, 0));
            JButton addButton = new JButton(ICON_ADD_ONE);
            ActionListener addActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ArrayParamProvider.this.newArrayParamProvider.isValidValue()) {
                        if (clipboardItems) {
                            ParamSpec param = ArrayParamProvider.this.newArrayParamProvider.getParamSpec();
                            ArrayParamProvider.this.model.addElement(new ParamSpecWrapper(param, param.getValue() == null ? "<NULL>" : param.getValue().toString()));
                        } else {
                            ArrayParamProvider.this.model.addElement(new ParamSpecWrapper(ArrayParamProvider.this.newArrayParamProvider.getParamSpec()));
                        }
                    } else {
                        JOptionPane.showMessageDialog(ArrayParamProvider.this.getComponent(), "Invalid value", "Error", 0);
                    }
                    ArrayParamProvider.this.actionPerformed(e);
                }
            };
            addButton.setToolTipText("Add item to the list");
            addButton.addActionListener(addActionListener);
            buttons.add(addButton);
            if (clipboardItems) {
                JButton addAllButton = new JButton(ICON_ADD_ALL);
                addAllButton.setToolTipText("Add available items to the list");
                addAllButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (ParamSpec spec : ((ClipboardParamProvider)ArrayParamProvider.this.newArrayParamProvider).listParamSpecs()) {
                            ArrayParamProvider.this.model.addElement(new ParamSpecWrapper(spec, spec.getValue().toString()));
                        }
                        ArrayParamProvider.this.actionPerformed(e);
                    }
                });
                buttons.add(addAllButton);
            }
            buttons.add(removeButton);
            buttons.add(removeAllButton);
            upper.add((Component)this.newArrayParamProvider.getComponent(), "North");
            upper.add((Component)buttons, "South");
        }
        this.newArrayPanel.add((Component)upper, "North");
        if (arrayType.equals(File.class)) {
            new FileDrop(itemsList, new FileDrop.Listener(){

                @Override
                public void filesDropped(File[] files) {
                    if (files.length > 0) {
                        for (File file : files) {
                            ArrayParamProvider.this.model.addElement(new ParamSpecWrapper(new ParamSpec(ArrayParamProvider.this.port.name(), arrayType, (Object)file.getAbsolutePath(), ParamSource.STRING_CONSTRUCTOR)));
                        }
                        ArrayParamProvider.this.setChanged();
                        ArrayParamProvider.this.notifyObservers();
                    }
                }
            });
        }
        this.newArrayPanel.add((Component)new JScrollPane(itemsList), "Center");
    }

    private void initArraySelector() {
        ButtonGroup group = new ButtonGroup();
        this.arraySelector.removeAll();
        this.radioCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArrayParamProvider.this.radioCreate.isSelected()) {
                    ArrayParamProvider.this.createNew = true;
                    ArrayParamProvider.this.changeCurrentView(ArrayParamProvider.CARD_NEW, false);
                    ArrayParamProvider.this.actionPerformed(e);
                }
            }
        });
        this.radioFromClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArrayParamProvider.this.radioFromClipboard.isSelected()) {
                    ArrayParamProvider.this.createNew = false;
                    ArrayParamProvider.this.changeCurrentView(ArrayParamProvider.CARD_CLIPBOARD, false);
                    ArrayParamProvider.this.actionPerformed(e);
                }
            }
        });
        group.add(this.radioFromClipboard);
        this.radioFromClipboard.setSelected(true);
        group.add(this.radioCreate);
        this.arraySelector.add(this.radioFromClipboard);
        this.arraySelector.add(this.radioCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent getComponent() {
        if (!this.componentInitialized) {
            JPanel jPanel = this.panel;
            synchronized (jPanel) {
                if (!this.componentInitialized) {
                    this.initComponent();
                    this.componentInitialized = true;
                }
            }
        }
        return this.panel;
    }

    protected boolean classHasClipboardItems() {
        return this.selectArray.countClipboardItems() > 0;
    }

    protected boolean classHasOperations() {
        return this.selectArray.classHasOperations(this.clazz);
    }

    private synchronized void reloadComponent() {
        boolean classHasClipboardItems = this.classHasClipboardItems();
        boolean classHasOperations = this.classHasOperations();
        if (this.showingAll) {
            if (!classHasClipboardItems && !classHasOperations) {
                this.arraySelector.setVisible(false);
                this.changeCurrentView(CARD_NEW, true);
                this.showingAll = false;
                this.createNew = true;
                this.panel.repaint();
            }
        } else if (classHasClipboardItems || classHasOperations) {
            this.arraySelector.setVisible(true);
            this.showingAll = true;
            this.panel.repaint();
        }
    }

    private void changeCurrentView(String constraint, boolean updateCheckboxes) {
        if ((constraint.equals(CARD_NEW) || constraint.equals(CARD_CLIPBOARD)) && !this.currentView.equals(constraint)) {
            this.currentView = constraint;
            this.cardLayout.show(this.cardPanel, this.currentView);
            if (constraint.equals(CARD_NEW)) {
                this.cardPanel.setPreferredSize(new Dimension(this.preferredWidth, this.newHeight));
                this.createNew = true;
                if (updateCheckboxes) {
                    this.radioCreate.setSelected(true);
                }
            } else if (constraint.equals(CARD_CLIPBOARD)) {
                this.cardPanel.setPreferredSize(new Dimension(this.preferredWidth, this.selectHeight));
                this.createNew = false;
                if (updateCheckboxes) {
                    this.radioFromClipboard.setSelected(true);
                }
            }
        }
    }

    private void initComponent() {
        this.panel.removeAll();
        this.initNewArrayComponent();
        this.initArraySelector();
        JPanel selectArrayPanel = new JPanel();
        selectArrayPanel.setLayout(new BorderLayout());
        selectArrayPanel.add((Component)this.selectArray.getComponent(), "North");
        this.cardPanel.add(CARD_CLIPBOARD, selectArrayPanel);
        this.newHeight = (int)this.newArrayPanel.getPreferredSize().getHeight();
        this.cardPanel.add(CARD_NEW, this.newArrayPanel);
        this.panel.add((Component)this.arraySelector, "North");
        this.panel.add((Component)this.cardPanel, "Center");
        this.selectHeight = (int)selectArrayPanel.getPreferredSize().getHeight();
        this.preferredWidth = (int)selectArrayPanel.getPreferredSize().getWidth();
        if (this.preferredWidth < 200) {
            this.preferredWidth = 200;
        }
        this.cardPanel.setMinimumSize(new Dimension(200, this.selectArray.getCurrentComponent().getMinimumSize().height));
        if (this.listener == null) {
            this.listener = new ArrayParamListener();
            Core.getInstance().getClipboard().addClipboardListener((ClipboardListener)this.listener);
        }
        this.showingAll = true;
        if (this.classHasClipboardItems()) {
            this.changeCurrentView(CARD_CLIPBOARD, true);
            this.cardPanel.setPreferredSize(new Dimension(this.preferredWidth, this.selectHeight));
        } else {
            this.changeCurrentView(CARD_NEW, true);
        }
        this.reloadComponent();
    }

    @Override
    public synchronized ParamSpec getParamSpec() {
        if (this.createNew) {
            ArrayList<ParamSpec> specs = new ArrayList<ParamSpec>();
            Enumeration<Object> e = this.model.elements();
            while (e.hasMoreElements()) {
                specs.add(((ParamSpecWrapper)e.nextElement()).getParamSpec());
            }
            return new ParamSpec(this.port.name(), this.clazz, specs.toArray(new ParamSpec[specs.size()]));
        }
        return this.selectArray.getParamSpec();
    }

    @Override
    public void finish() {
        if (this.selectArray != null) {
            this.selectArray.finish();
        }
        if (this.newArrayParamProvider != null) {
            this.newArrayParamProvider.finish();
        }
        if (this.listener != null) {
            Core.getInstance().getClipboard().removeClipboardListener((ClipboardListener)this.listener);
        }
    }

    @Override
    public boolean isValidValue() {
        if (!this.port.allowNull() && this.currentView == CARD_CLIPBOARD) {
            return this.selectArray.isValidValue();
        }
        if (!this.port.allowNull() && this.currentView == CARD_NEW) {
            return !this.model.isEmpty();
        }
        return true;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers();
    }

    private final class ArrayParamListener
    implements ClipboardListener {
        private ArrayParamListener() {
        }

        public void elementAdded(ClipboardItem item) {
            ArrayParamProvider.this.reloadComponent();
        }

        public void elementRemoved(ClipboardItem item) {
            ArrayParamProvider.this.reloadComponent();
        }
    }

    private class ParamSpecWrapper {
        private final String name;
        private final ParamSpec paramSpec;

        public ParamSpecWrapper(ParamSpec paramSpec) {
            this.paramSpec = paramSpec;
            this.name = paramSpec.getValue() == null ? "null" : paramSpec.getValue().toString();
        }

        public ParamSpecWrapper(ParamSpec paramProvider, String name) {
            this.paramSpec = paramProvider;
            this.name = name;
        }

        public ParamSpec getParamSpec() {
            return this.paramSpec;
        }

        public String toString() {
            return this.name;
        }
    }
}

