/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.views.components;

import es.uvigo.ei.sing.laimages.gui.jzy3d.CoordinatesUtils;
import es.uvigo.ei.sing.laimages.gui.util.DecimalFormatter;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jzy3d.maths.Coord3d;

public class ViewPointInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Coord3d currentViewPoint = new Coord3d(0.0f, 0.0f, 0.0f);
    private JLabel info = new JLabel();
    private boolean is3DEnabled = false;

    public ViewPointInformationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new FlowLayout());
        this.add(Box.createHorizontalGlue());
        this.add(this.getInfoLabel());
        this.add(Box.createHorizontalGlue());
    }

    private JLabel getInfoLabel() {
        this.updateLabel(this.currentViewPoint);
        return this.info;
    }

    public boolean is3DEnabled() {
        return this.is3DEnabled;
    }

    public void viewPointChanged(Coord3d viewPoint) {
        this.updateCurrentViewPoint(viewPoint);
    }

    private void updateCurrentViewPoint(Coord3d viewPoint) {
        this.currentViewPoint = CoordinatesUtils.getDisplayAngle(viewPoint, this.is3DEnabled());
        this.updateLabel(this.currentViewPoint);
    }

    private void updateLabel(Coord3d viewPoint) {
        this.info.setToolTipText(this.is3DEnabled() ? "Format: (X, Y)" : "Format: (X)");
        this.info.setText(this.generateLabel(viewPoint));
    }

    private String generateLabel(Coord3d viewPoint) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(DecimalFormatter.format(Math.toDegrees(viewPoint.x), 2)).append("\u00b0");
        if (this.is3DEnabled()) {
            sb.append(", ").append(DecimalFormatter.format(Math.toDegrees(viewPoint.y), 2)).append("\u00b0");
        }
        sb.append(")");
        return sb.toString();
    }

    public void set3DEnabled(boolean is3DEnabled) {
        this.is3DEnabled = is3DEnabled;
        this.updateLabel(this.currentViewPoint);
    }
}

