/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.views.components;

import es.uvigo.ei.sing.laimages.gui.jzy3d.CoordinatesUtils;
import es.uvigo.ei.sing.laimages.gui.util.DecimalFormatter;
import es.uvigo.ei.sing.laimages.gui.util.FloatTextField;
import es.uvigo.ei.sing.laimages.gui.views.ElementDataViewConfiguration;
import java.awt.FlowLayout;
import java.awt.event.FocusListener;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jzy3d.maths.Coord2d;

public class ViewPointEditorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel xLbl = new JLabel("X: ");
    private JFormattedTextField xTextField;
    private JLabel yLbl = new JLabel("Y: ");
    private JFormattedTextField yTextField;
    private Coord2d displayViewPoint;
    private boolean is3DEnabled;
    private boolean editable = false;

    public ViewPointEditorPanel(Coord2d viewPoint, boolean is3DEnabled) {
        this.is3DEnabled = is3DEnabled;
        this.displayViewPoint = CoordinatesUtils.getDisplayAngle(viewPoint, is3DEnabled).getXY();
        this.init();
    }

    private void init() {
        this.setLayout(new FlowLayout());
        this.add(this.xLbl);
        this.add(this.getXTextField());
        this.add(this.yLbl);
        this.add(this.getYTextField());
    }

    private JFormattedTextField getXTextField() {
        if (this.xTextField == null) {
            this.xTextField = new FloatTextField(0.0f);
            this.xTextField.setText(this.getValue(this.displayViewPoint.x));
            this.xTextField.setColumns(10);
        }
        return this.xTextField;
    }

    private String getValue(float value) {
        return DecimalFormatter.format(Math.toDegrees(value), 2);
    }

    private JFormattedTextField getYTextField() {
        if (this.yTextField == null) {
            this.yTextField = new FloatTextField(0.0f);
            this.yTextField.setText(this.getValue(this.displayViewPoint.y));
            this.yTextField.setEnabled(this.is3DEnabled);
            this.yTextField.setColumns(10);
        }
        return this.yTextField;
    }

    private void updateFields() {
        this.getXTextField().setText(this.getValue(this.displayViewPoint.x));
        this.getYTextField().setText(this.getValue(this.displayViewPoint.y));
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.xTextField.addFocusListener(l);
        this.yTextField.addFocusListener(l);
    }

    public void set3DEnabled(boolean is3dEnabled) {
        this.is3DEnabled = is3dEnabled;
        this.updateFieldsEditability();
    }

    private void updateFieldsEditability() {
        this.xTextField.setEnabled(this.editable);
        this.yTextField.setEnabled(this.is3DEnabled && this.editable);
    }

    public void setViewPoint(Coord2d viewPoint) {
        this.displayViewPoint = CoordinatesUtils.getDisplayAngle(viewPoint, this.is3DEnabled).getXY();
        this.updateFields();
    }

    public Coord2d getViewPoint() {
        return CoordinatesUtils.getRealAngle(new Coord2d(this.getXCoordRadians(), this.getYCoordRadians()), this.is3DEnabled).getXY();
    }

    private double getXCoordRadians() {
        return Math.toRadians(((Float)this.getXTextField().getValue()).floatValue());
    }

    private double getYCoordRadians() {
        return this.is3DEnabled ? Math.toRadians(((Float)this.getYTextField().getValue()).floatValue()) : (double)CoordinatesUtils.getDisplayAngle((Coord2d)ElementDataViewConfiguration.getDefault2DAngle(), (boolean)false).y;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.updateFieldsEditability();
    }
}

