/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.views.components;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public class ScaleSpinner
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_SCALE = 1;
    public static final int DEFAULT_SCALE_MIN = 1;
    public static final int DEFAULT_SCALE_MAX = 100;
    public static final int DEFAULT_SCALE_STEP = 1;
    private ChangeListener scaleChangedListener;
    private JSpinner spinnerScale;
    private Number initialScaleValue = 1;

    public ScaleSpinner() {
        this.init();
    }

    public ScaleSpinner(Number value, ChangeListener scaleChangedListener) {
        this.initialScaleValue = value.intValue();
        this.scaleChangedListener = scaleChangedListener;
        this.init();
    }

    private void init() {
        this.setLayout(new GridLayout(1, 2));
        SpinnerNumberModel model = new SpinnerNumberModel(this.initialScaleValue, Integer.valueOf(1), Integer.valueOf(100), (Number)1);
        this.spinnerScale = new JSpinner(model);
        this.add(new JLabel("Scale:"));
        this.add(this.spinnerScale);
        if (this.scaleChangedListener != null) {
            this.spinnerScale.addChangeListener(this.scaleChangedListener);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.spinnerScale.setEnabled(enabled);
    }

    public Number getScale() {
        return (Number)this.spinnerScale.getModel().getValue();
    }

    public void setScale(Number value) {
        this.spinnerScale.setValue(value);
    }

    public JSpinner getSpinner() {
        return this.spinnerScale;
    }
}

