/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.views.components;

import es.uvigo.ei.sing.laimages.gui.jzy3d.CoordinatesUtils;
import es.uvigo.ei.sing.laimages.gui.views.components.event.RotationEvent;
import es.uvigo.ei.sing.laimages.gui.views.components.event.RotationListener;
import java.awt.event.ActionEvent;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;

public class RotationButtonsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double ROTATE_STEP = Math.toRadians(22.5);
    private static final Coord2d ROTATION_DOWN_ANGLE = new Coord2d(0.0, ROTATE_STEP);
    private static final Coord2d ROTATION_UP_ANGLE = new Coord2d(0.0, -ROTATE_STEP);
    private static final Coord2d ROTATION_RIGHT_ANGLE = new Coord2d(-ROTATE_STEP, 0.0);
    private static final Coord2d ROTATION_LEFT_ANGLE = new Coord2d(ROTATE_STEP, 0.0);
    private static final Coord2d RESET_ANGLE = new Coord2d(0.0f, 0.0f);
    public static final ImageIcon ICON_UP = new ImageIcon(RotationButtonsPanel.class.getResource("icons/up.png"));
    public static final ImageIcon ICON_DOWN = new ImageIcon(RotationButtonsPanel.class.getResource("icons/down.png"));
    public static final ImageIcon ICON_LEFT = new ImageIcon(RotationButtonsPanel.class.getResource("icons/left.png"));
    public static final ImageIcon ICON_RIGHT = new ImageIcon(RotationButtonsPanel.class.getResource("icons/right.png"));
    public static final ImageIcon ICON_RESET = new ImageIcon(RotationButtonsPanel.class.getResource("icons/reset.png"));
    private RotateButton rotateLeftBtn;
    private RotateButton rotateRightBtn;
    private RotateButton rotateUpBtn;
    private RotateButton rotateDownBtn;
    private RotateButton resetViewBtn;
    private boolean is3dEnabled = false;

    public RotationButtonsPanel() {
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createEmptyBorder(1, 5, 5, 1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.rotateLeftBtn = new RotateButton(ICON_LEFT, this::rotateLeft, "Rotate left (X axis)");
        this.rotateRightBtn = new RotateButton(ICON_RIGHT, this::rotateRight, "Rotate right (X axis)");
        this.rotateUpBtn = new RotateButton(ICON_UP, this::rotateUp, "Rotate up (Y axis)");
        this.rotateDownBtn = new RotateButton(ICON_DOWN, this::rotateDown, "Rotate down (Y axis)");
        this.resetViewBtn = new RotateButton(ICON_RESET, this::reset, "Reset view");
        JPanel gap1 = new JPanel();
        JPanel gap2 = new JPanel();
        JPanel gap3 = new JPanel();
        JPanel gap4 = new JPanel();
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(gap1).addComponent(this.rotateRightBtn).addComponent(gap2)).addGroup(layout.createParallelGroup().addComponent(this.rotateDownBtn).addComponent(this.resetViewBtn).addComponent(this.rotateUpBtn)).addGroup(layout.createParallelGroup().addComponent(gap3).addComponent(this.rotateLeftBtn).addComponent(gap4)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(gap1).addComponent(this.rotateUpBtn).addComponent(gap3)).addGroup(layout.createParallelGroup().addComponent(this.rotateRightBtn).addComponent(this.resetViewBtn).addComponent(this.rotateLeftBtn)).addGroup(layout.createParallelGroup().addComponent(gap2).addComponent(this.rotateDownBtn).addComponent(gap4)));
    }

    private void rotateLeft() {
        this.fireRotationEvent(new RotationEvent(ROTATION_LEFT_ANGLE));
    }

    private void rotateRight() {
        this.fireRotationEvent(new RotationEvent(ROTATION_RIGHT_ANGLE));
    }

    private void rotateUp() {
        this.fireRotationEvent(new RotationEvent(ROTATION_UP_ANGLE));
    }

    private void rotateDown() {
        this.fireRotationEvent(new RotationEvent(ROTATION_DOWN_ANGLE));
    }

    private void reset() {
        this.fireRotationEvent(new RotationEvent(RESET_ANGLE));
    }

    public void set3DEnabled(boolean is3dEnabled) {
        this.is3dEnabled = is3dEnabled;
        this.rotateUpBtn.setEnabled(is3dEnabled);
        this.rotateDownBtn.setEnabled(is3dEnabled);
    }

    private void fireRotationEvent(RotationEvent e) {
        Stream.of(this.getRotationListeners()).forEach(r -> r.onRotationEvent(e));
    }

    public void viewPointChanged(Coord3d viewPoint) {
        viewPoint = CoordinatesUtils.getDisplayAngle(viewPoint, this.is3dEnabled());
        this.rotateDownBtn.setEnabled(this.is3dEnabled() && !CoordinatesUtils.equalsTo(viewPoint.y, Math.toRadians(90.0)));
        this.rotateUpBtn.setEnabled(this.is3dEnabled() && !CoordinatesUtils.equalsTo(viewPoint.y, Math.toRadians(-90.0)));
    }

    private boolean is3dEnabled() {
        return this.is3dEnabled;
    }

    public void addRotationListener(RotationListener l) {
        this.listenerList.add(RotationListener.class, l);
    }

    public void removeRotationListener(RotationListener l) {
        this.listenerList.remove(RotationListener.class, l);
    }

    public RotationListener[] getRotationListeners() {
        return (RotationListener[])this.listenerList.getListeners(RotationListener.class);
    }

    private class RotateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private Runnable actionPerformed;

        public RotateAction(ImageIcon icon, Runnable actionPerformed) {
            super("", icon);
            this.actionPerformed = actionPerformed;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.actionPerformed.run();
        }
    }

    private class RotateButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public RotateButton(ImageIcon icon, Runnable actionPerformed, String tooltip) {
            super(new RotateAction(icon, actionPerformed));
            this.setToolTipText(tooltip);
        }
    }
}

