/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.views;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementDataset;
import es.uvigo.ei.sing.laimages.core.io.csv.CSVFormat;
import es.uvigo.ei.sing.laimages.core.util.CommonFileChooser;
import es.uvigo.ei.sing.laimages.gui.analysis.LaImagesAnalysis;
import es.uvigo.ei.sing.laimages.gui.analysis.io.SerializationLaImagesAnalysisWriter;
import es.uvigo.ei.sing.laimages.gui.dialogs.ExportAllAsCsvDialog;
import es.uvigo.ei.sing.laimages.gui.dialogs.ExportAllAsPngDialog;
import es.uvigo.ei.sing.laimages.gui.dialogs.ExportAsPngDialog;
import es.uvigo.ei.sing.laimages.gui.dialogs.ExportCsvDialog;
import es.uvigo.ei.sing.laimages.gui.dialogs.RangeInputDialog;
import es.uvigo.ei.sing.laimages.gui.dialogs.TaskProgressDialog;
import es.uvigo.ei.sing.laimages.gui.export.DefaultElementDatasetToPngExporter;
import es.uvigo.ei.sing.laimages.gui.export.ElementDatasetToPngExporter;
import es.uvigo.ei.sing.laimages.gui.jzy3d.ElementDataImageConfiguration;
import es.uvigo.ei.sing.laimages.gui.jzy3d.Range;
import es.uvigo.ei.sing.laimages.gui.views.ElementDataView;
import es.uvigo.ei.sing.laimages.gui.views.ElementDataViewConfiguration;
import es.uvigo.ei.sing.laimages.gui.views.components.RotationButtonsPanel;
import es.uvigo.ei.sing.laimages.gui.views.components.ScaleSpinner;
import es.uvigo.ei.sing.laimages.gui.views.components.ViewPointInformationPanel;
import es.uvigo.ei.sing.laimages.gui.views.components.event.RotationEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jzy3d.events.IViewPointChangedListener;
import org.jzy3d.events.ViewPointChangedEvent;
import org.jzy3d.maths.Coord2d;

public class LaImagesAnalysisViewer
extends JPanel {
    public static final long serialVersionUID = 1L;
    protected static final FocusListener FOCUS_LISTENER = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getComponent() instanceof JTextField) {
                SwingUtilities.invokeLater(() -> ((JTextField)e.getComponent()).selectAll());
            }
        }
    };
    private static final ElementDatasetToPngExporter DATASET_EXPORTER = new DefaultElementDatasetToPngExporter();
    public static final ImageIcon ICON_AXES = LaImagesAnalysisViewer.getResource("icons/axes.png");
    public static final ImageIcon ICON_TICKS = LaImagesAnalysisViewer.getResource("icons/ticks.png");
    public static final ImageIcon ICON_SAVE = LaImagesAnalysisViewer.getResource("icons/save.png");
    private static final ImageIcon ICON_EXPORT_PNG = LaImagesAnalysisViewer.getResource("icons/export-png.png");
    private static final ImageIcon ICON_EXPORT_CSV = LaImagesAnalysisViewer.getResource("icons/export-csv.png");
    private static final ImageIcon ICON_RESET = LaImagesAnalysisViewer.getResource("icons/reset.png");
    private static final ImageIcon ICON_INTERPOLATE = LaImagesAnalysisViewer.getResource("icons/interpolate.png");
    private static final ImageIcon ICON_COLORMAP = LaImagesAnalysisViewer.getResource("icons/colormap.png");
    private static final ImageIcon ICON_COLORMAP_SHOW = LaImagesAnalysisViewer.getResource("icons/colormap_show.png");
    private static final ImageIcon ICON_COLORMAP_RANGE = LaImagesAnalysisViewer.getResource("icons/colormap_range.png");
    private static final String ELEMENT_NAME = "ELEMENT_NAME";
    private static final Dimension PREFERRED_MENU_ITEM_SIZE = new Dimension(200, 25);
    private ElementDataset dataset;
    private List<String> elementNames;
    private JMenuBar menuBar;
    private JMenu exportMenu;
    private JPanel eastPanel;
    private ElementDataView elementDataPanel;
    private JComboBox<Object> elementCombo;
    private JCheckBox viewerModeCB;
    private JCheckBoxMenuItem showColorBarLegendCB;
    private JCheckBoxMenuItem showAxesCB;
    private JCheckBoxMenuItem showTickLinesCB;
    private RotationButtonsPanel rotationButtonsPanel;
    private ViewPointInformationPanel viewPointInformationPanel;
    private ScaleSpinner scaleSpinner;
    private boolean mustUpdateElementDataPanel = true;
    private IViewPointChangedListener viewPointChangedListener = this::viewPointChanged;
    private ButtonGroup interpolationButtons;
    private ButtonGroup colorMapButtons;
    private ButtonGroup rangeModeButtons;
    private Map<String, Float> minRangeValues = new HashMap<String, Float>();
    private Map<String, Float> maxRangeValues = new HashMap<String, Float>();
    private ElementDataViewConfiguration configuration = new ElementDataViewConfiguration();

    public LaImagesAnalysisViewer(LaImagesAnalysis analysis) {
        Objects.requireNonNull(analysis);
        this.dataset = Objects.requireNonNull(analysis.getDataset());
        this.configuration = Objects.requireNonNull(analysis.getConfiguration());
        this.elementNames = this.dataset.getElementNames();
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add(this.getEastComponent(), "East");
        this.add(this.getCenterComponent(), "Center");
        this.add((Component)this.getMenuBar(), "North");
    }

    private JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.menuBar.add(this.getFileMenu());
            this.menuBar.add(this.getGraphicSettingsMenu());
            this.menuBar.add(this.getExportMenu());
        }
        return this.menuBar;
    }

    private JMenu getFileMenu() {
        JMenu file = new JMenu("File");
        file.add(new JMenuItem(this.getSaveAction()));
        this.fixMenuComponentsSize(file);
        return file;
    }

    private void fixMenuComponentsSize(JMenu menu) {
        Arrays.asList(menu.getMenuComponents()).forEach(c -> c.setPreferredSize(PREFERRED_MENU_ITEM_SIZE));
    }

    private JMenu getGraphicSettingsMenu() {
        JMenu gS = new JMenu("Graphic settings");
        gS.add(this.getInterpolationLevelMenu());
        gS.add(this.getColorMapMenu());
        gS.add(this.getRangeModeMenu());
        gS.add(this.getShowColorBarLegendComponent());
        gS.add(this.getShowAxesLegendComponent());
        gS.add(this.getShowTickLinesComponent());
        gS.add(this.getResetMenuItem());
        return gS;
    }

    private JMenuItem getResetMenuItem() {
        JCheckBoxMenuItem resetMenuItem = new JCheckBoxMenuItem(this.getDefaultSettingsAction());
        resetMenuItem.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
        resetMenuItem.setSelected(false);
        resetMenuItem.addActionListener(l -> resetMenuItem.setSelected(false));
        return resetMenuItem;
    }

    private JMenu getInterpolationLevelMenu() {
        JMenu interpolationLevel = new JMenu("Interpolation level");
        interpolationLevel.setIcon(ICON_INTERPOLATE);
        interpolationLevel.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
        this.interpolationButtons = new ButtonGroup();
        Stream.of(ElementDataViewConfiguration.InterpolationLevel.values()).forEach(i -> {
            InterpolationLevelRadioButtonMenuItem item = new InterpolationLevelRadioButtonMenuItem((ElementDataViewConfiguration.InterpolationLevel)((Object)i));
            this.interpolationButtons.add(item);
            interpolationLevel.add(item);
        });
        return interpolationLevel;
    }

    private JMenu getColorMapMenu() {
        JMenu colorMap = new JMenu("Color Map");
        colorMap.setIcon(ICON_COLORMAP);
        colorMap.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
        this.colorMapButtons = new ButtonGroup();
        Stream.of(ElementDataViewConfiguration.ColorMap.values()).forEach(cm -> {
            ColorMapRadioButtonMenuItem item = new ColorMapRadioButtonMenuItem((ElementDataViewConfiguration.ColorMap)((Object)cm));
            this.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
            this.colorMapButtons.add(item);
            colorMap.add(item);
        });
        return colorMap;
    }

    private JMenu getRangeModeMenu() {
        JMenu rangeMode = new JMenu("Range Mode");
        rangeMode.setIcon(ICON_COLORMAP_RANGE);
        rangeMode.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
        this.rangeModeButtons = new ButtonGroup();
        Stream.of(ElementDataViewConfiguration.ColorMapRangeMode.values()).forEach(cm -> {
            ColorMapRangeRadioButtonMenuItem item = new ColorMapRangeRadioButtonMenuItem((ElementDataViewConfiguration.ColorMapRangeMode)((Object)cm));
            this.rangeModeButtons.add(item);
            rangeMode.add(item);
        });
        return rangeMode;
    }

    private JCheckBoxMenuItem getShowColorBarLegendComponent() {
        this.showColorBarLegendCB = new JCheckBoxMenuItem("Show color bar legend", ICON_COLORMAP_SHOW, this.configuration.isShowColorBarLegend());
        this.showColorBarLegendCB.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
        this.showColorBarLegendCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LaImagesAnalysisViewer.this.showColorBarLegendChanged();
            }
        });
        return this.showColorBarLegendCB;
    }

    private JCheckBoxMenuItem getShowAxesLegendComponent() {
        this.showAxesCB = new JCheckBoxMenuItem("Show axes", ICON_AXES, this.configuration.isShowAxes());
        this.showAxesCB.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
        this.showAxesCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LaImagesAnalysisViewer.this.showAxesChanged();
            }
        });
        return this.showAxesCB;
    }

    private JCheckBoxMenuItem getShowTickLinesComponent() {
        this.showTickLinesCB = new JCheckBoxMenuItem("Show tick lines", ICON_TICKS, this.configuration.isShowTickLines());
        this.showTickLinesCB.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
        this.showTickLinesCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LaImagesAnalysisViewer.this.showTickLinesChanged();
            }
        });
        return this.showTickLinesCB;
    }

    private JMenu getExportMenu() {
        if (this.exportMenu == null) {
            this.exportMenu = new JMenu("Export...");
            this.exportMenu.add(new JMenuItem(this.getExportAsImageAction()));
            this.exportMenu.add(new JMenuItem(this.getExportAllAsImageAction()));
            this.exportMenu.add(new JMenuItem(this.getExportAsCsvAction()));
            this.exportMenu.add(new JMenuItem(this.getExportAllAsCsvAction()));
            this.fixMenuComponentsSize(this.exportMenu);
        }
        return this.exportMenu;
    }

    private Component getCenterComponent() {
        if (this.elementDataPanel == null) {
            this.elementDataPanel = this.createElementDataView((ElementData)this.dataset.getElements().get(this.configuration.getElementIndex()));
        }
        return this.elementDataPanel;
    }

    private Component getEastComponent() {
        if (this.eastPanel == null) {
            this.eastPanel = new JPanel(new BorderLayout());
            JPanel northPanel = new JPanel(new BorderLayout());
            JPanel optionsPanel = new JPanel();
            optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
            optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel elementPanel = new JPanel();
            elementPanel.setLayout(new GridLayout(2, 1));
            elementPanel.add(new JLabel("Element:"));
            this.elementCombo = new JComboBox<Object>(this.elementNames.toArray());
            this.elementCombo.setSelectedIndex(this.configuration.getElementIndex());
            this.elementCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LaImagesAnalysisViewer.this.selectedElementChanged();
                    }
                }
            });
            elementPanel.add(this.elementCombo);
            JPanel viewerModePanel = new JPanel(new BorderLayout());
            viewerModePanel.setBorder(BorderFactory.createTitledBorder("3D viewer"));
            this.viewerModeCB = new JCheckBox("Enable 3D view", this.configuration.is3DEnabled());
            this.viewerModeCB.addItemListener(e -> this.positionModeChanged());
            this.scaleSpinner = new ScaleSpinner(this.configuration.getScale(), e -> this.scaleChanged());
            this.scaleSpinner.setEnabled(this.configuration.is3DEnabled());
            this.scaleSpinner.setToolTipText("The scaling ratio. It is only applied if 3D mode is active");
            ((JSpinner.DefaultEditor)this.scaleSpinner.getSpinner().getEditor()).getTextField().addFocusListener(FOCUS_LISTENER);
            viewerModePanel.add((Component)this.viewerModeCB, "North");
            viewerModePanel.add((Component)this.scaleSpinner, "South");
            optionsPanel.add(elementPanel);
            optionsPanel.add(Box.createVerticalStrut(5));
            optionsPanel.add(viewerModePanel);
            optionsPanel.add(Box.createVerticalGlue());
            this.rotationButtonsPanel = new RotationButtonsPanel();
            this.rotationButtonsPanel.addRotationListener(this::rotateViewPoint);
            this.rotationButtonsPanel.set3DEnabled(this.is3DEnabled());
            this.viewPointInformationPanel = new ViewPointInformationPanel();
            this.viewPointInformationPanel.set3DEnabled(this.is3DEnabled());
            JPanel cameraControlPanel = new JPanel();
            cameraControlPanel.setLayout(new BoxLayout(cameraControlPanel, 1));
            cameraControlPanel.setBorder(BorderFactory.createTitledBorder("Camera control"));
            cameraControlPanel.add(this.rotationButtonsPanel);
            cameraControlPanel.add(Box.createVerticalStrut(2));
            cameraControlPanel.add(this.viewPointInformationPanel);
            cameraControlPanel.add(Box.createVerticalGlue());
            northPanel.add((Component)optionsPanel, "North");
            northPanel.add((Component)cameraControlPanel, "South");
            this.eastPanel.add((Component)northPanel, "North");
        }
        return this.eastPanel;
    }

    private Action getSaveAction() {
        return new AbstractAction("Save analysis", ICON_SAVE){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser saveFC = CommonFileChooser.getInstance().getFilechooser();
                saveFC.setSelectedFile(new File(LaImagesAnalysisViewer.this.dataset.getName() + ".lai"));
                int returnVal = saveFC.showSaveDialog(LaImagesAnalysisViewer.this.getParentFrame());
                if (returnVal == 0) {
                    LaImagesAnalysisViewer.this.saveAnalysis(saveFC.getSelectedFile());
                }
            }
        };
    }

    private void saveAnalysis(File file) {
        SerializationLaImagesAnalysisWriter writer = new SerializationLaImagesAnalysisWriter();
        try {
            writer.write(new LaImagesAnalysis(this.dataset, this.getViewConfiguration()), file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ElementDataViewConfiguration getViewConfiguration() {
        ElementDataViewConfiguration viewConfiguration = this.elementDataPanel.getViewConfiguration();
        viewConfiguration.setElementIndex(this.getSelectedElementDataIndex());
        viewConfiguration.setRangeMode(this.getSelectedRangeMode());
        return viewConfiguration;
    }

    private Action getExportAsImageAction() {
        return new AbstractAction("As image ", ICON_EXPORT_PNG){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportAsPngDialog dialog = new ExportAsPngDialog(LaImagesAnalysisViewer.this.getParentFrame(), LaImagesAnalysisViewer.this.getSelectedElementData().getName() + ".png");
                dialog.setVisible(true);
                if (!dialog.isCanceled()) {
                    LaImagesAnalysisViewer.this.exportCurrentElementToPNG(dialog.getSelectedFile(), dialog.getSelectedWidth(), dialog.getSelectedHeight());
                }
            }
        };
    }

    private Action getExportAllAsImageAction() {
        return new AbstractAction("All as image ", ICON_EXPORT_PNG){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportAllAsPngDialog dialog = new ExportAllAsPngDialog(LaImagesAnalysisViewer.this.getParentFrame());
                dialog.setInterpolationLevel(LaImagesAnalysisViewer.this.getSelectedInterpolation());
                dialog.setColorMap(LaImagesAnalysisViewer.this.getSelectedColorMap());
                dialog.set3DEnabled(LaImagesAnalysisViewer.this.is3DEnabled());
                dialog.setShowColorBarLegend(LaImagesAnalysisViewer.this.isShowColorBarLegend());
                dialog.setShowAxes(LaImagesAnalysisViewer.this.isShowAxes());
                dialog.setShowTickLines(LaImagesAnalysisViewer.this.isShowTickLines());
                dialog.setDatasetRange(LaImagesAnalysisViewer.this.getDatasetRange());
                dialog.setCurrentViewPoint(LaImagesAnalysisViewer.this.getCurrentViewPoint());
                dialog.setColorMapRangeMode(LaImagesAnalysisViewer.this.getSelectedRangeMode());
                dialog.setColorMapRange(LaImagesAnalysisViewer.this.getCurrentColorMapRange());
                dialog.setScale(LaImagesAnalysisViewer.this.getScale());
                dialog.setVisible(true);
                if (!dialog.isCanceled()) {
                    LaImagesAnalysisViewer.this.exportDatasetToPNG(dialog.getSelectedFile(), new ElementDataImageConfiguration(dialog.getSelectedWidth(), dialog.getSelectedHeight(), LaImagesAnalysisViewer.this.elementDataPanel.getQuality(), dialog.getSelectedInterpolationLevel(), dialog.getSelectedColorMap(), dialog.getSelectedColorMapRange(), dialog.getSelectedViewPoint(), dialog.isShowColorBarLegend(), dialog.isShowAxes(), dialog.isShowTickLines(), dialog.getSelectedScale(), dialog.is3DEnabled()));
                }
            }
        };
    }

    private Action getExportAsCsvAction() {
        return new AbstractAction("As CSV", ICON_EXPORT_CSV){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCsvDialog dialog = new ExportCsvDialog(LaImagesAnalysisViewer.this.getParentFrame(), LaImagesAnalysisViewer.this.getSelectedElementData().getName() + ".csv");
                dialog.setVisible(true);
                if (!dialog.isCanceled()) {
                    try {
                        LaImagesAnalysisViewer.this.dataset.toCSV(LaImagesAnalysisViewer.this.getSelectedElementData(), dialog.getSelectedFile(), dialog.getCSVFormat());
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(LaImagesAnalysisViewer.this.getParentFrame(), "An error occured while exporting the element to CSV.", "Export Error", 0);
                    }
                }
            }
        };
    }

    private Action getExportAllAsCsvAction() {
        return new AbstractAction("All as CSV", ICON_EXPORT_CSV){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportAllAsCsvDialog dialog = new ExportAllAsCsvDialog(LaImagesAnalysisViewer.this.getParentFrame());
                dialog.setVisible(true);
                if (!dialog.isCanceled()) {
                    LaImagesAnalysisViewer.this.exportDatasetToCSV(dialog.getSelectedFile(), dialog.getCSVFormat());
                }
            }
        };
    }

    private Action getDefaultSettingsAction() {
        return new AbstractAction("Reset to default", ICON_RESET){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LaImagesAnalysisViewer.this.setDefaultSettings();
            }
        };
    }

    protected Coord2d getCurrentViewPoint() {
        return this.elementDataPanel.getCurrentViewPoint();
    }

    public float getMinRangeValue() {
        ElementDataViewConfiguration.ColorMapRangeMode rangeMode = this.getSelectedRangeMode();
        ElementData selectedElement = this.getSelectedElementData();
        float minRange = 0.0f;
        minRange = rangeMode.equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.ELEMENT) ? (float)selectedElement.getMinValue() : (rangeMode.equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.DATASET) ? this.getDatasetRange().getMin() : this.minRangeValues.getOrDefault(selectedElement.getName(), Float.valueOf((float)selectedElement.getMinValue())).floatValue());
        return minRange;
    }

    public float getMaxRangeValue() {
        ElementDataViewConfiguration.ColorMapRangeMode rangeMode = this.getSelectedRangeMode();
        ElementData selectedElement = this.getSelectedElementData();
        float maxRange = 0.0f;
        maxRange = rangeMode.equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.ELEMENT) ? (float)selectedElement.getMaxValue() : (rangeMode.equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.DATASET) ? this.getDatasetRange().getMax() : this.maxRangeValues.getOrDefault(selectedElement.getName(), Float.valueOf((float)selectedElement.getMaxValue())).floatValue());
        return maxRange;
    }

    private void colorMapRangeModeChanged() {
        if (this.isCustomRangeMode()) {
            this.readCustomRangemode();
        }
        this.applyColorMapRange();
    }

    private boolean isCustomRangeMode() {
        ElementDataViewConfiguration.ColorMapRangeMode selected = this.getSelectedRangeMode();
        return !selected.equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.ELEMENT) && !selected.equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.DATASET);
    }

    private void readCustomRangemode() {
        RangeInputDialog rangeInput = new RangeInputDialog(this.getParentFrame(), "Color map range", "Allows you to set the custom color map range.");
        rangeInput.setMinValue(this.getMinRangeValue());
        rangeInput.setMaxValue(this.getMaxRangeValue());
        rangeInput.setVisible(true);
        float minRangeValue = rangeInput.getMinValue();
        float maxRangeValue = rangeInput.getMaxValue();
        this.elementNames.forEach(n -> {
            this.minRangeValues.putIfAbsent((String)n, Float.valueOf(minRangeValue));
            this.maxRangeValues.putIfAbsent((String)n, Float.valueOf(maxRangeValue));
        });
        String selectedElement = this.getSelectedElementData().getName();
        this.minRangeValues.put(selectedElement, Float.valueOf(minRangeValue));
        this.maxRangeValues.put(selectedElement, Float.valueOf(maxRangeValue));
        ColorMapRangeRadioButtonMenuItem customRangeItem = this.getCustomRangeItem();
        customRangeItem.setRange(this.getCurrentColorMapRange());
    }

    private ColorMapRangeRadioButtonMenuItem getCustomRangeItem() {
        return (ColorMapRangeRadioButtonMenuItem)Collections.list(this.rangeModeButtons.getElements()).stream().filter(b -> ((ColorMapRangeRadioButtonMenuItem)b).getColorMapRangeMode().equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.CUSTOM)).findFirst().get();
    }

    private Range getDatasetRange() {
        return new Range((float)this.dataset.getMinValue(), (float)this.dataset.getMaxValue());
    }

    private ElementDataViewConfiguration.ColorMapRangeMode getSelectedRangeMode() {
        return ((ColorMapRangeRadioButtonMenuItem)Collections.list(this.rangeModeButtons.getElements()).stream().filter(this.isSelected()).findFirst().get()).getColorMapRangeMode();
    }

    private void applyColorMapRange() {
        if (!this.mustUpdateElementDataPanel()) {
            return;
        }
        if (this.getSelectedRangeMode().equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.ELEMENT)) {
            this.elementDataPanel.removeColorMapRange();
        } else {
            this.elementDataPanel.setColorMapRange(this.getCurrentColorMapRange());
        }
        if (this.getSelectedRangeMode().equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.CUSTOM)) {
            this.getCustomRangeItem().setRange(this.getCurrentColorMapRange());
        }
    }

    private boolean mustUpdateElementDataPanel() {
        return this.mustUpdateElementDataPanel;
    }

    private Range getCurrentColorMapRange() {
        return new Range(this.getMinRangeValue(), this.getMaxRangeValue());
    }

    private void rotateViewPoint(RotationEvent e) {
        this.elementDataPanel.rotateViewPoint(e.getAngle());
    }

    private void exportCurrentElementToPNG(File file, int width, int height) {
        Thread t = new Thread(() -> {
            try {
                DATASET_EXPORTER.toPNG(this.getSelectedElementData(), file, new ElementDataImageConfiguration(width, height, this.elementDataPanel.getQuality(), this.elementDataPanel.getInterpolationLevel(), this.elementDataPanel.getColorMap(), Optional.of(this.elementDataPanel.getColorMapRange()), this.elementDataPanel.getCurrentViewPoint(), this.elementDataPanel.isShowColorBarLegend(), this.elementDataPanel.isShowAxes(), this.elementDataPanel.isShowTickLines(), this.elementDataPanel.getScale(), this.is3DEnabled()));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "An error occured while exporting the element to PNG.", "Export Error", 0);
            }
        });
        t.start();
    }

    private final ElementDataView createElementDataView(ElementData element) {
        ElementDataView elementDataView = new ElementDataView(element, this.configuration, this.viewPointChangedListener);
        return elementDataView;
    }

    private void exportDatasetToCSV(File selectedFile, CSVFormat csvFormat) {
        this.setExportButtonsEnabled(false);
        List<String> taskNames = this.getExportElementToCSVTaskNames();
        TaskProgressDialog dialog = new TaskProgressDialog(this.getParentFrame(), "Exporting dataset to CSV", taskNames);
        Thread t = new Thread(() -> {
            dialog.setVisible(true);
            try {
                this.dataset.toCSV(selectedFile, csvFormat, () -> dialog.nextTask());
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "An error occured while exporting the element to CSV.", "Export Error", 0);
            }
            dialog.finished("Finished");
            dialog.dispose();
            this.setExportButtonsEnabled(true);
        });
        t.start();
    }

    private List<String> getExportElementToCSVTaskNames() {
        return this.getExportElementTaskNames("Task: export element ELEMENT_NAME to file ELEMENT_NAME.csv");
    }

    private List<String> getExportElementTaskNames(String task) {
        LinkedList<String> taskNames = new LinkedList<String>();
        this.elementNames.stream().forEach(e -> taskNames.add(task.replaceAll(ELEMENT_NAME, (String)e)));
        return taskNames;
    }

    private void exportDatasetToPNG(File directory, ElementDataImageConfiguration configuration) {
        this.setExportButtonsEnabled(false);
        List<String> taskNames = this.getExportElementToPNGTaskNames();
        TaskProgressDialog dialog = new TaskProgressDialog(this.getParentFrame(), "Exporting dataset to PNG", taskNames);
        Thread t = new Thread(() -> {
            dialog.setVisible(true);
            try {
                DATASET_EXPORTER.toPNG(this.dataset, directory, configuration, () -> dialog.nextTask());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "An error occured while exporting the dataset to PNG.", "Export Error", 0);
            }
            dialog.nextTask();
            dialog.finished("Finished");
            dialog.dispose();
            this.setExportButtonsEnabled(true);
        });
        t.start();
    }

    private List<String> getExportElementToPNGTaskNames() {
        return this.getExportElementTaskNames("Task: export element ELEMENT_NAME to file ELEMENT_NAME.png");
    }

    private void setExportButtonsEnabled(boolean enabled) {
        Arrays.asList(this.exportMenu.getMenuComponents()).forEach(c -> ((JMenuItem)c).setEnabled(enabled));
        this.updateUI();
    }

    private void colorMapChanged() {
        this.elementDataPanel.setColorMap(this.getSelectedColorMap());
    }

    private void scaleChanged() {
        if (this.mustUpdateElementDataPanel()) {
            this.elementDataPanel.setScale(this.getScale());
        }
        this.updateColorMapRange();
    }

    private void updateColorMapRange() {
        this.applyColorMapRange();
    }

    private double getScale() {
        return this.scaleSpinner.getScale().doubleValue();
    }

    private void showColorBarLegendChanged() {
        this.elementDataPanel.setShowColorBarLegend(this.isShowColorBarLegend());
    }

    private boolean isShowColorBarLegend() {
        return this.showColorBarLegendCB.isSelected();
    }

    private void showAxesChanged() {
        this.elementDataPanel.setShowAxes(this.isShowAxes());
    }

    private boolean isShowAxes() {
        return this.showAxesCB.isSelected();
    }

    private void showTickLinesChanged() {
        this.elementDataPanel.setShowTickLines(this.isShowTickLines());
    }

    private boolean isShowTickLines() {
        return this.showTickLinesCB.isSelected();
    }

    private final void setDefaultSettings() {
        this.elementDataPanel.setDefaultSettings();
        this.mustUpdateElementDataPanel = false;
        this.setDefaultScaleIntensity();
        this.setDefaultViewMode();
        this.setDefaultInterpolationLevel();
        this.setDefaultColorMap();
        this.setDefaultShowColorBarLegend();
        this.setDefaultShowAxes();
        this.setDefaultShowTickLines();
        this.setDefaultColorMapRangeMode();
        this.mustUpdateElementDataPanel = true;
    }

    private void setDefaultScaleIntensity() {
        this.scaleSpinner.setScale(ElementDataViewConfiguration.DEFAULT_SCALE);
    }

    private final void setDefaultShowColorBarLegend() {
        this.showColorBarLegendCB.setSelected(true);
        if (this.mustUpdateElementDataPanel()) {
            this.elementDataPanel.setShowColorBarLegend(true);
        }
    }

    private final void setDefaultShowAxes() {
        this.showAxesCB.setSelected(true);
        if (this.mustUpdateElementDataPanel()) {
            this.elementDataPanel.setShowAxes(true);
        }
    }

    private final void setDefaultShowTickLines() {
        this.showTickLinesCB.setSelected(true);
        if (this.mustUpdateElementDataPanel()) {
            this.elementDataPanel.setShowTickLines(true);
        }
    }

    private final void setDefaultColorMap() {
        Collections.list(this.colorMapButtons.getElements()).forEach(a -> {
            ColorMapRadioButtonMenuItem c = (ColorMapRadioButtonMenuItem)a;
            c.setSelected(c.getColorMap().equals((Object)ElementDataViewConfiguration.DEFAULT_COLOR_MAP));
        });
        if (this.mustUpdateElementDataPanel()) {
            this.elementDataPanel.setColorMap(this.getSelectedColorMap());
        }
    }

    private final void setDefaultInterpolationLevel() {
        Collections.list(this.interpolationButtons.getElements()).forEach(a -> {
            InterpolationLevelRadioButtonMenuItem i = (InterpolationLevelRadioButtonMenuItem)a;
            i.setSelected(i.getLevel().equals((Object)ElementDataViewConfiguration.DEFAULT_INTERPOLATION));
        });
        if (this.mustUpdateElementDataPanel()) {
            this.elementDataPanel.setInterpolation(this.getSelectedInterpolation());
        }
    }

    private final void setDefaultViewMode() {
        this.viewerModeCB.setSelected(false);
        if (this.mustUpdateElementDataPanel()) {
            this.set3DEnabled(this.is3DEnabled());
        }
    }

    private void set3DEnabled(boolean is3dEnabled) {
        this.elementDataPanel.set3DEnabled(is3dEnabled);
        this.rotationButtonsPanel.set3DEnabled(is3dEnabled);
        this.viewPointInformationPanel.set3DEnabled(this.is3DEnabled());
        this.scaleSpinner.setEnabled(is3dEnabled);
    }

    private final void setDefaultColorMapRangeMode() {
        Collections.list(this.rangeModeButtons.getElements()).forEach(a -> {
            ColorMapRangeRadioButtonMenuItem i = (ColorMapRangeRadioButtonMenuItem)a;
            i.setSelected(i.getColorMapRangeMode().equals((Object)ElementDataViewConfiguration.DEFAULT_COLOR_MAP_RANGE_MODE));
        });
        if (this.mustUpdateElementDataPanel()) {
            this.elementDataPanel.removeColorMapRange();
        }
    }

    private final boolean is3DEnabled() {
        return this.viewerModeCB.isSelected();
    }

    private final void positionModeChanged() {
        this.set3DEnabled(this.is3DEnabled());
    }

    private final void selectedElementChanged() {
        this.elementDataPanel.setElementData(this.getSelectedElementData());
        this.applyColorMapRange();
    }

    private final void interpolationModeChanged() {
        this.elementDataPanel.setInterpolation(this.getSelectedInterpolation());
    }

    private final ElementData getSelectedElementData() {
        return (ElementData)this.dataset.getElements().get(this.elementCombo.getSelectedIndex());
    }

    private int getSelectedElementDataIndex() {
        return this.dataset.getElements().indexOf(this.getSelectedElementData());
    }

    private final ElementDataViewConfiguration.InterpolationLevel getSelectedInterpolation() {
        return ((InterpolationLevelRadioButtonMenuItem)Collections.list(this.interpolationButtons.getElements()).stream().filter(this.isSelected()).findFirst().get()).getLevel();
    }

    private Predicate<? super AbstractButton> isSelected() {
        return b -> ((JRadioButtonMenuItem)b).isSelected();
    }

    private final ElementDataViewConfiguration.ColorMap getSelectedColorMap() {
        return ((ColorMapRadioButtonMenuItem)Collections.list(this.colorMapButtons.getElements()).stream().filter(this.isSelected()).findFirst().get()).getColorMap();
    }

    private void viewPointChanged(ViewPointChangedEvent e) {
        this.viewPointInformationPanel.viewPointChanged(e.getViewPoint());
        this.rotationButtonsPanel.viewPointChanged(e.getViewPoint());
    }

    private final JFrame getParentFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor(this);
    }

    private static final ImageIcon getResource(String resource) {
        return new ImageIcon(LaImagesAnalysisViewer.class.getResource(resource));
    }

    private class ColorMapRangeRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = 1L;
        private ElementDataViewConfiguration.ColorMapRangeMode colorMapRangeMode;

        public ColorMapRangeRadioButtonMenuItem(ElementDataViewConfiguration.ColorMapRangeMode colorMapRangeMode) {
            super(colorMapRangeMode.toString());
            this.colorMapRangeMode = colorMapRangeMode;
            this.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
            this.setSelected(colorMapRangeMode.equals((Object)LaImagesAnalysisViewer.this.configuration.getRangeMode()));
            if (LaImagesAnalysisViewer.this.configuration.getColorMapRange().isPresent()) {
                this.setRange(LaImagesAnalysisViewer.this.configuration.getColorMapRange().get());
            }
            this.addActionListener(e -> LaImagesAnalysisViewer.this.colorMapRangeModeChanged());
        }

        public ElementDataViewConfiguration.ColorMapRangeMode getColorMapRangeMode() {
            return this.colorMapRangeMode;
        }

        public void setRange(Range range) {
            if (this.getColorMapRangeMode().equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.CUSTOM)) {
                this.setText((Object)((Object)ElementDataViewConfiguration.ColorMapRangeMode.CUSTOM) + " [" + range.getMin() + ", " + range.getMax() + "]");
            }
        }
    }

    private class ColorMapRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = 1L;
        private ElementDataViewConfiguration.ColorMap colorMap;

        public ColorMapRadioButtonMenuItem(ElementDataViewConfiguration.ColorMap colorMap) {
            super(colorMap.toString());
            this.setSelected(colorMap.equals((Object)LaImagesAnalysisViewer.this.configuration.getColorMap()));
            this.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
            this.colorMap = colorMap;
            this.addActionListener(e -> LaImagesAnalysisViewer.this.colorMapChanged());
        }

        public ElementDataViewConfiguration.ColorMap getColorMap() {
            return this.colorMap;
        }
    }

    private class InterpolationLevelRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        private static final long serialVersionUID = 1L;
        private ElementDataViewConfiguration.InterpolationLevel level;

        public InterpolationLevelRadioButtonMenuItem(ElementDataViewConfiguration.InterpolationLevel level) {
            super(level.toString());
            this.setSelected(level.equals((Object)LaImagesAnalysisViewer.this.configuration.getInterpolationLevel()));
            this.setPreferredSize(PREFERRED_MENU_ITEM_SIZE);
            this.level = level;
            this.addActionListener(e -> LaImagesAnalysisViewer.this.interpolationModeChanged());
        }

        public ElementDataViewConfiguration.InterpolationLevel getLevel() {
            return this.level;
        }
    }
}

