/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.views;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.gui.jzy3d.Range;
import es.uvigo.ei.sing.laimages.gui.util.DecimalFormatter;
import java.io.Serializable;
import java.util.Optional;
import org.jzy3d.colors.colormaps.ColorMapGrayscale;
import org.jzy3d.colors.colormaps.ColorMapHotCold;
import org.jzy3d.colors.colormaps.ColorMapRBG;
import org.jzy3d.colors.colormaps.ColorMapRainbow;
import org.jzy3d.colors.colormaps.ColorMapRainbowNoBorder;
import org.jzy3d.colors.colormaps.ColorMapRedAndGreen;
import org.jzy3d.colors.colormaps.ColorMapWhiteBlue;
import org.jzy3d.colors.colormaps.ColorMapWhiteGreen;
import org.jzy3d.colors.colormaps.ColorMapWhiteRed;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;

public class ElementDataViewConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Quality QUALITY = new Quality(true, false, true, false, false, false, true);
    public static final int DEFAULT_ELEMENT_INDEX = 0;
    public static final boolean DEFAULT_IS_3D_ENABLED = false;
    public static final Number DEFAULT_SCALE;
    public static final Number DEFAULT_2D_SCALE;
    public static final Number DEFAULT_3D_SCALE;
    public static final ColorMap DEFAULT_COLOR_MAP;
    public static final ColorMapRangeMode DEFAULT_COLOR_MAP_RANGE_MODE;
    public static final InterpolationLevel DEFAULT_INTERPOLATION;
    public static final boolean DEFAULT_SHOW_COLOR_BAR_LEGEND = true;
    public static final boolean DEFAULT_SHOW_AXES = true;
    public static final boolean DEFAULT_SHOW_TICK_LINES = true;
    public static final ViewPositionMode DEFAULT_2D_POSITION_MODE;
    public static final ViewPositionMode DEFAULT_3D_POSITION_MODE;
    public static final ViewPositionMode FREE_2D_POSITION_MODE;
    private int elementIndex = 0;
    private boolean is3DEnabled = false;
    private Number scale = DEFAULT_2D_SCALE;
    private ViewPositionMode viewPositionMode2D = DEFAULT_2D_POSITION_MODE;
    private Coord2d viewPoint = ElementDataViewConfiguration.getDefault2DAngle();
    private InterpolationLevel interpolationLevel = DEFAULT_INTERPOLATION;
    private ColorMap colorMap = DEFAULT_COLOR_MAP;
    private ColorMapRangeMode rangeMode = DEFAULT_COLOR_MAP_RANGE_MODE;
    private boolean showColorBarLegend = true;
    private boolean showAxes = true;
    private boolean showTickLines = true;
    private SerializableRange colorMapRange = null;

    public ElementDataViewConfiguration() {
    }

    public ElementDataViewConfiguration(int elementIndex, boolean is3DEnabled, Number scale, Coord2d viewPoint, ViewPositionMode viewPositionMode2D, InterpolationLevel interpolationLevel, ColorMap colorMap, ColorMapRangeMode rangeMode, Range colorMapRange, boolean showColorBarLegend, boolean showAxes, boolean showTickLines) {
        this.elementIndex = elementIndex;
        this.is3DEnabled = is3DEnabled;
        this.scale = scale;
        this.viewPoint = viewPoint;
        this.viewPositionMode2D = viewPositionMode2D;
        this.interpolationLevel = interpolationLevel;
        this.colorMap = colorMap;
        this.rangeMode = rangeMode;
        this.colorMapRange = new SerializableRange(colorMapRange);
        this.showColorBarLegend = showColorBarLegend;
        this.showAxes = showAxes;
        this.showTickLines = showTickLines;
    }

    public int getElementIndex() {
        return this.elementIndex;
    }

    public void setElementIndex(int elementIndex) {
        this.elementIndex = elementIndex;
    }

    public boolean is3DEnabled() {
        return this.is3DEnabled;
    }

    public void set3DEnabled(boolean enabled) {
        this.is3DEnabled = enabled;
    }

    public Number getScale() {
        return (this.is3DEnabled() ? (Number)this.scale : (Number)DEFAULT_2D_SCALE).doubleValue();
    }

    public void setScale(Number scale) {
        this.scale = scale;
    }

    public ViewPositionMode getViewPositionMode2D() {
        return this.viewPositionMode2D;
    }

    public void setViewPositionMode2D(ViewPositionMode viewPositionMode2D) {
        this.viewPositionMode2D = viewPositionMode2D;
    }

    public Coord2d getViewPoint() {
        return this.viewPoint;
    }

    public void setViewPoint(Coord2d viewPoint) {
        this.viewPoint = viewPoint;
    }

    public InterpolationLevel getInterpolationLevel() {
        return this.interpolationLevel;
    }

    public void setInterpolationLevel(InterpolationLevel interpolationLevel) {
        this.interpolationLevel = interpolationLevel;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public ColorMapRangeMode getRangeMode() {
        return this.rangeMode;
    }

    public void setRangeMode(ColorMapRangeMode rangeMode) {
        this.rangeMode = rangeMode;
    }

    public Optional<Range> getColorMapRange() {
        return Optional.ofNullable(this.colorMapRange == null ? null : this.colorMapRange.getRange());
    }

    public void setColorMapRange(Range colorMapRange) {
        this.colorMapRange = new SerializableRange(colorMapRange);
    }

    public void removeColorMapRange() {
        this.colorMapRange = null;
    }

    public boolean isShowColorBarLegend() {
        return this.showColorBarLegend;
    }

    public void setShowColorBarLegend(boolean showColorBarLegend) {
        this.showColorBarLegend = showColorBarLegend;
    }

    public boolean isShowAxes() {
        return this.showAxes;
    }

    public void setShowAxes(boolean showAxes) {
        this.showAxes = showAxes;
    }

    public boolean isShowTickLines() {
        return this.showTickLines;
    }

    public void setShowTickLines(boolean showTickLines) {
        this.showTickLines = showTickLines;
    }

    public void resetToDefault() {
        this.elementIndex = 0;
        this.is3DEnabled = false;
        this.scale = DEFAULT_2D_SCALE;
        this.viewPositionMode2D = DEFAULT_2D_POSITION_MODE;
        this.viewPoint = ElementDataViewConfiguration.getDefault2DAngle();
        this.interpolationLevel = DEFAULT_INTERPOLATION;
        this.colorMap = DEFAULT_COLOR_MAP;
        this.rangeMode = DEFAULT_COLOR_MAP_RANGE_MODE;
        this.colorMapRange = null;
        this.showColorBarLegend = true;
        this.showAxes = true;
        this.showTickLines = true;
    }

    public static final Coord2d getDefault3DAngle() {
        return new Coord2d(-2.356194490192345, 0.7853981633974483);
    }

    public static final Coord2d getDefault2DAngle() {
        return new Coord2d(-1.5707963267948966, 1.5707963267948966);
    }

    public static String formatAxeValue(double value) {
        return DecimalFormatter.format(value, 3);
    }

    public static final Range normalizeColorMapRange(Range range, ElementData element) {
        return new Range(range.getMin() / (float)element.getMaxValue(), range.getMax() / (float)element.getMaxValue());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ElementDataViewConfiguration)) {
            return false;
        }
        ElementDataViewConfiguration other = (ElementDataViewConfiguration)obj;
        return this.getElementIndex() == other.getElementIndex() && this.is3DEnabled() == other.is3DEnabled() && this.getScale().equals(other.getScale()) && this.getViewPositionMode2D().equals((Object)other.getViewPositionMode2D()) && this.equalsViewPoints(this.getViewPoint(), other.getViewPoint()) && this.getInterpolationLevel().equals((Object)other.getInterpolationLevel()) && this.getColorMap().equals((Object)other.getColorMap()) && this.getRangeMode().equals((Object)other.getRangeMode()) && this.getColorMapRange().equals(other.getColorMapRange()) && this.isShowColorBarLegend() == other.isShowColorBarLegend() && this.isShowAxes() == other.isShowAxes() && this.isShowTickLines() == other.isShowTickLines();
    }

    private boolean equalsViewPoints(Coord2d a, Coord2d b) {
        return a.getX() == b.getX() && a.getY() == b.getY();
    }

    static {
        DEFAULT_2D_SCALE = DEFAULT_SCALE = Integer.valueOf(1);
        DEFAULT_3D_SCALE = DEFAULT_SCALE;
        DEFAULT_COLOR_MAP = ColorMap.RAINBOW;
        DEFAULT_COLOR_MAP_RANGE_MODE = ColorMapRangeMode.ELEMENT;
        DEFAULT_INTERPOLATION = InterpolationLevel.NONE;
        DEFAULT_2D_POSITION_MODE = ViewPositionMode.TOP;
        DEFAULT_3D_POSITION_MODE = ViewPositionMode.FREE;
        FREE_2D_POSITION_MODE = ViewPositionMode.FREE;
    }

    private class SerializableRange
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private float min;
        private float max;

        public SerializableRange(Range range) {
            this.min = range.getMin();
            this.max = range.getMax();
        }

        public float getMin() {
            return this.min * ElementDataViewConfiguration.this.getScale().floatValue();
        }

        public float getMax() {
            return this.max * ElementDataViewConfiguration.this.getScale().floatValue();
        }

        public Range getRange() {
            return new Range(this.getMin(), this.getMax());
        }
    }

    public static enum InterpolationLevel {
        NONE("None", 0),
        LOW("Low", 1),
        MEDIUM("Medium", 2),
        HIGH("High", 3);

        private int level;
        private String name;

        private InterpolationLevel(String name, int level) {
            this.name = name;
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ColorMapRangeMode {
        ELEMENT("Element"),
        DATASET("Dataset"),
        CUSTOM("Custom");

        private String name;

        private ColorMapRangeMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ColorMap {
        RAINBOW("Rainbow", (IColorMap)new ColorMapRainbow()),
        RAINBOW_NO_BORDER("Rainbow (no border)", (IColorMap)new ColorMapRainbowNoBorder()),
        HOT_COLD("Hot cold", (IColorMap)new ColorMapHotCold()),
        RGB("RGB", (IColorMap)new ColorMapRBG()),
        GRAY_ESCALE("Gray scale", (IColorMap)new ColorMapGrayscale()),
        RED_AND_GREEN("Red and green", (IColorMap)new ColorMapRedAndGreen()),
        WHITE_BLUE("White and blue", (IColorMap)new ColorMapWhiteBlue()),
        WHITE_GREEN("White and green", (IColorMap)new ColorMapWhiteGreen()),
        WHITE_RED("White and red", (IColorMap)new ColorMapWhiteRed());

        private IColorMap colormap;
        private String name;

        private ColorMap(String name, IColorMap cm) {
            this.name = name;
            this.colormap = cm;
        }

        public IColorMap getColorMap() {
            return this.colormap;
        }

        public String toString() {
            return this.name;
        }
    }
}

