/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.views;

import com.jogamp.newt.event.MouseEvent;
import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.operations.NormalizeElementData;
import es.uvigo.ei.sing.laimages.gui.jzy3d.CoordinatesUtils;
import es.uvigo.ei.sing.laimages.gui.jzy3d.ElementDataSurfaceAdapter;
import es.uvigo.ei.sing.laimages.gui.jzy3d.Range;
import es.uvigo.ei.sing.laimages.gui.jzy3d.chart2d.Chart2dComponentFactory;
import es.uvigo.ei.sing.laimages.gui.views.ElementDataViewConfiguration;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.chart.controllers.mouse.camera.NewtCameraMouseController;
import org.jzy3d.chart.factories.AWTChartComponentFactory;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.events.IViewPointChangedListener;
import org.jzy3d.events.ViewPointChangedEvent;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Shape;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.legends.ILegend;
import org.jzy3d.plot3d.rendering.legends.colorbars.AWTColorbarLegend;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;

public class ElementDataView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double ROTATION_360_NEG = -7.853983;
    private static final double ROTATION_360_POS = 4.712389;
    private static final ITickRenderer TICK_RENDERER = ElementDataViewConfiguration::formatAxeValue;
    private static final String CARD_CHART_RENDERING = "CARD_CHART_RENDERING";
    private static final String CARD_CHART = "CARD_CHART";
    private CardLayout cardLayout;
    private JPanel renderingPanel;
    private Chart chart;
    private Component currentCanvas;
    private Shape surface;
    private IViewPointChangedListener viewPointChangedListener;
    private final NewtCameraMouseController customCameraController = new CustomNewtCameraMouseController();
    private ElementData element;
    private ElementData normalizedElement;
    private ElementDataViewConfiguration configuration;
    private ElementDataSurfaceAdapter surfaceAdapter;
    private Coord3d current3DAngle = CoordinatesUtils.toCoord3d(ElementDataViewConfiguration.getDefault3DAngle());
    private Coord3d current2DAngle = CoordinatesUtils.toCoord3d(ElementDataViewConfiguration.getDefault2DAngle());

    public ElementDataView(ElementData element, ElementDataViewConfiguration configuration, IViewPointChangedListener viewPointChangedListener) {
        this.element = Objects.requireNonNull(element);
        this.normalizedElement = NormalizeElementData.normalize((ElementData)Objects.requireNonNull(element));
        this.viewPointChangedListener = Objects.requireNonNull(viewPointChangedListener);
        this.setInitialConfiguration(Objects.requireNonNull(configuration));
        this.chart = null;
        this.updateSurfaceAdapter();
        this.init();
    }

    private void setInitialConfiguration(ElementDataViewConfiguration configuration) {
        this.configuration = configuration;
        this.initCurrentAngle();
    }

    private void initCurrentAngle() {
        if (this.configuration.is3DEnabled()) {
            this.current3DAngle = CoordinatesUtils.toCoord3d(this.configuration.getViewPoint());
        } else {
            this.current2DAngle = CoordinatesUtils.toCoord3d(this.configuration.getViewPoint());
        }
    }

    private void updateSurfaceAdapter() {
        this.surfaceAdapter = new ElementDataSurfaceAdapter(this.normalizedElement);
    }

    private void init() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add(this.getRenderingPanel(), CARD_CHART_RENDERING);
        this.addChart();
    }

    private void addChart() {
        this.currentCanvas = (Component)this.getCanvas();
        this.add(this.currentCanvas, CARD_CHART);
        this.showChart();
    }

    private void showChart() {
        this.cardLayout.show(this, CARD_CHART);
    }

    private Component getRenderingPanel() {
        if (this.renderingPanel == null) {
            this.renderingPanel = new JPanel();
            this.renderingPanel.setLayout(new BoxLayout(this.renderingPanel, 0));
            this.renderingPanel.add(Box.createHorizontalGlue());
            JLabel renderingLbl = new JLabel("Rendering chart...");
            renderingLbl.setFont(renderingLbl.getFont().deriveFont(1));
            this.renderingPanel.add(renderingLbl);
            this.renderingPanel.add(Box.createHorizontalGlue());
        }
        return this.renderingPanel;
    }

    public ICanvas getCanvas() {
        return this.getChart().getCanvas();
    }

    private synchronized Chart getChart() {
        if (this.chart == null) {
            this.surface = this.surfaceAdapter.generateSurface(this.getInterpolation().getLevel(), this.getColorMap(), this.getNormalizedColorMapRange(), d -> d * this.getScale());
            this.chart = this.is3DEnabled() ? AWTChartComponentFactory.chart((Quality)ElementDataViewConfiguration.QUALITY, (String)"newt") : Chart2dComponentFactory.chart(ElementDataViewConfiguration.QUALITY, "newt");
            this.chart.getScene().getGraph().add((AbstractDrawable)this.surface);
            this.chart.getView().setSquared(false);
            this.chart.setAxeDisplayed(this.isShowAxes());
            this.chart.getAxeLayout().setTickLineDisplayed(this.isShowTickLines());
            this.chart.getAxeLayout().setXTickRenderer(TICK_RENDERER);
            this.chart.getAxeLayout().setYTickRenderer(TICK_RENDERER);
            this.chart.getAxeLayout().setZTickRenderer(this::formatZTick);
            this.chart.getView().addViewPointChangedListener(this.viewPointChangedListener);
            AxeBox a = (AxeBox)this.chart.getView().getAxe();
            a.setTextRenderer((ITextRenderer)new TextBitmapRenderer(){
                {
                    this.font = 7;
                    this.fontHeight = 14;
                }
            });
            this.setColorBarLegend();
            this._updateViewMode();
            this.chart.pauseAnimator();
        }
        return this.chart;
    }

    private String formatZTick(double value) {
        return ElementDataViewConfiguration.formatAxeValue(value * this.element.getMaxValue() / this.getScale());
    }

    public double getScale() {
        return this.configuration.getScale().doubleValue();
    }

    public Range getNormalizedColorMapRange() {
        return ElementDataViewConfiguration.normalizeColorMapRange(this.getColorMapRange(), this.element);
    }

    public Range getColorMapRange() {
        if (!this.configuration.getColorMapRange().isPresent()) {
            return ElementDataSurfaceAdapter.getElementRange(this.element, d -> d * this.getScale());
        }
        return this.configuration.getColorMapRange().get();
    }

    private void setColorBarLegend() {
        if (this.isShowColorBarLegend()) {
            this.surface.setLegend((ILegend)new AWTColorbarLegend((AbstractDrawable)this.surface, this.chart.getView().getAxe().getLayout()));
        }
    }

    public void setElementData(ElementData elementData) {
        if (!this.normalizedElement.equals(elementData)) {
            this.element = elementData;
            this.normalizedElement = NormalizeElementData.normalize((ElementData)elementData);
            this.updateSurfaceAdapter();
            this.updateChart();
        }
    }

    public void setInterpolation(ElementDataViewConfiguration.InterpolationLevel interpolation) {
        if (!this.getInterpolation().equals((Object)interpolation)) {
            this.configuration.setInterpolationLevel(interpolation);
            this.updateChart();
        }
    }

    public void setScale(Number scale) {
        if (!this.configuration.getScale().equals(scale)) {
            this.configuration.setScale(scale);
            this.updateChart();
        }
    }

    public void set3DEnabled(boolean enabled) {
        if (enabled != this.is3DEnabled()) {
            this.configuration.set3DEnabled(enabled);
            this.updateViewMode();
            SwingUtilities.invokeLater(this::updateChart);
        }
    }

    private final void updateViewMode() {
        this.showChartRendering();
        SwingUtilities.invokeLater(this::_updateViewMode);
    }

    private void showChartRendering() {
        this.cardLayout.show(this, CARD_CHART_RENDERING);
    }

    private void _updateViewMode() {
        this.configureViewPoint();
        this.showChart();
    }

    private void configureViewPoint() {
        if (this.is3DEnabled()) {
            this.chart.setViewMode(ElementDataViewConfiguration.DEFAULT_3D_POSITION_MODE);
            this.chart.setViewPoint(this.current3DAngle);
        } else {
            this.chart.setViewMode(this.getCurrent2DPositionMode());
            if (this.is2DFreeModeEnabled()) {
                this.chart.setViewPoint(this.current2DAngle);
            }
        }
        this.updateCurrentAngle();
        this.addChartControllers();
    }

    private ViewPositionMode getCurrent2DPositionMode() {
        return this.configuration.getViewPositionMode2D();
    }

    private void addChartControllers() {
        if (this.is3DEnabled()) {
            this.chart.addController((AbstractCameraController)this.customCameraController);
        } else {
            this.chart.removeController((AbstractCameraController)this.customCameraController);
        }
    }

    public Coord2d getCurrentViewPoint() {
        return this.getChart().getViewPoint().getXY();
    }

    public void rotateViewPoint(Coord2d angle) {
        if (angle.getX() == 0.0f && angle.getY() == 0.0f) {
            this.setDefaultViewPositionMode();
        } else if (!this.is3DEnabled() && !this.is2DFreeModeEnabled()) {
            this.enable2DFreeModeAndRotateViewPoint(angle);
        } else {
            this._rotateViewPoint(angle);
        }
    }

    private void _rotateViewPoint(Coord2d angle) {
        this.chart.getCanvas().getView().rotate(angle, true);
        if (this.shouldReset2DView()) {
            this.setDefaultViewPositionMode();
        } else {
            this.updateCurrentAngle();
        }
    }

    private boolean shouldReset2DView() {
        return !this.is3DEnabled() && (CoordinatesUtils.equalsTo(this.getChart().getViewPoint().x, ElementDataViewConfiguration.getDefault2DAngle().x) || CoordinatesUtils.equalsTo(this.getChart().getViewPoint().x, 4.712389) || CoordinatesUtils.equalsTo(this.getChart().getViewPoint().x, -7.853983));
    }

    private void enable2DFreeModeAndRotateViewPoint(Coord2d angle) {
        this.showChartRendering();
        this.set2DFreeMode();
        SwingUtilities.invokeLater(() -> {
            this._rotateViewPoint(angle);
            this.showChart();
        });
    }

    private void updateCurrentAngle() {
        if (this.is3DEnabled()) {
            this.current3DAngle = this.chart.getViewPoint();
            this.fireViewPointChangedEvent(this.current3DAngle);
        } else {
            this.current2DAngle = this.is2DFreeModeEnabled() ? this.chart.getViewPoint() : CoordinatesUtils.toCoord3d(ElementDataViewConfiguration.getDefault2DAngle());
            this.fireViewPointChangedEvent(this.current2DAngle);
        }
    }

    private void fireViewPointChangedEvent(Coord3d newAngle) {
        this.configuration.setViewPoint(newAngle.getXY());
        this.viewPointChangedListener.viewPointChanged(new ViewPointChangedEvent((Object)this, newAngle));
    }

    private void setDefaultViewPositionMode() {
        if (this.is3DEnabled()) {
            this.current3DAngle = CoordinatesUtils.toCoord3d(ElementDataViewConfiguration.getDefault3DAngle());
        } else {
            this.configuration.setViewPositionMode2D(ElementDataViewConfiguration.DEFAULT_2D_POSITION_MODE);
            this.current2DAngle = CoordinatesUtils.toCoord3d(ElementDataViewConfiguration.getDefault2DAngle());
        }
        this.configureViewPoint();
    }

    private boolean is2DFreeModeEnabled() {
        return this.chart.getViewMode().equals((Object)ElementDataViewConfiguration.FREE_2D_POSITION_MODE);
    }

    private void set2DFreeMode() {
        this.configuration.setViewPositionMode2D(ElementDataViewConfiguration.FREE_2D_POSITION_MODE);
        this.chart.setViewMode(this.getCurrent2DPositionMode());
        this.chart.setViewPoint(CoordinatesUtils.toCoord3d(ElementDataViewConfiguration.getDefault2DAngle()));
        this.chart.getAxeLayout().setZAxeLabelDisplayed(false);
        this.chart.getAxeLayout().setZTickLabelDisplayed(false);
    }

    private boolean is3DEnabled() {
        return this.configuration.is3DEnabled();
    }

    private void updateChart() {
        this.showChartRendering();
        this.remove(this.currentCanvas);
        this.chart.dispose();
        this.chart = null;
        SwingUtilities.invokeLater(this::addChart);
    }

    private void updateColorMap() {
        this.showChartRendering();
        SwingUtilities.invokeLater(this::_updateColorMap);
    }

    private void _updateColorMap() {
        this.surface.setColorMapper(new ColorMapper(this.getColorMap(), (org.jzy3d.maths.Range)this.getNormalizedColorMapRange()));
        this.setColorBarLegend();
        this.showChart();
    }

    public void setShowColorBarLegend(boolean show) {
        if (show != this.configuration.isShowColorBarLegend()) {
            this.configuration.setShowColorBarLegend(show);
            this.updateChart();
        }
    }

    public void setShowAxes(boolean show) {
        if (show != this.configuration.isShowAxes()) {
            this.configuration.setShowAxes(show);
            this.getChart().setAxeDisplayed(this.isShowAxes());
        }
    }

    public void setShowTickLines(boolean show) {
        if (show != this.configuration.isShowTickLines()) {
            this.configuration.setShowTickLines(show);
            this.getChart().getAxeLayout().setTickLineDisplayed(this.isShowTickLines());
            this.getChart().setAxeDisplayed(this.isShowAxes());
        }
    }

    public boolean isShowTickLines() {
        return this.configuration.isShowTickLines();
    }

    public boolean isShowColorBarLegend() {
        return this.configuration.isShowColorBarLegend();
    }

    public boolean isShowAxes() {
        return this.configuration.isShowAxes();
    }

    public int getInterpolationLevel() {
        return this.getInterpolation().getLevel();
    }

    public IColorMap getColorMap() {
        return this.getColorMapType().getColorMap();
    }

    public ElementDataViewConfiguration.ColorMap getColorMapType() {
        return this.configuration.getColorMap();
    }

    public void setColorMap(ElementDataViewConfiguration.ColorMap colorMap) {
        if (!this.getColorMapType().equals((Object)colorMap)) {
            this.configuration.setColorMap(colorMap);
            this.updateColorMap();
        }
    }

    public Quality getQuality() {
        return ElementDataViewConfiguration.QUALITY;
    }

    public void setColorMapRange(Range range) {
        if (!this.getColorMapRange().equals((Object)range)) {
            this.configuration.setColorMapRange(range);
            this.updateColorMapRange();
        } else if (!this.configuration.getColorMapRange().isPresent()) {
            this.configuration.setColorMapRange(range);
        }
    }

    public void removeColorMapRange() {
        if (this.configuration.getColorMapRange().isPresent()) {
            this.configuration.removeColorMapRange();
            this.updateColorMapRange();
        }
    }

    private void updateColorMapRange() {
        this.showChartRendering();
        SwingUtilities.invokeLater(this::_updateColorMapRange);
    }

    private void _updateColorMapRange() {
        this.surface.getColorMapper().setRange((org.jzy3d.maths.Range)this.getNormalizedColorMapRange());
        this.setColorBarLegend();
        this.showChart();
    }

    public ElementDataViewConfiguration getViewConfiguration() {
        return this.configuration;
    }

    public void setDefaultSettings() {
        this.configuration.resetToDefault();
        this.current2DAngle = CoordinatesUtils.toCoord3d(ElementDataViewConfiguration.getDefault2DAngle());
        this.updateChart();
    }

    private ElementDataViewConfiguration.InterpolationLevel getInterpolation() {
        return this.configuration.getInterpolationLevel();
    }

    class CustomNewtCameraMouseController
    extends NewtCameraMouseController {
        CustomNewtCameraMouseController() {
        }

        public void mouseWheelMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            ElementDataView.this.getChart().resumeAnimator();
            super.mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            ElementDataView.this.getChart().pauseAnimator();
        }
    }
}

