/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.util;

import com.jogamp.opengl.GLCapabilities;
import es.uvigo.ei.sing.laimages.gui.jzy3d.chart2d.Chart2dComponentFactory;
import es.uvigo.ei.sing.laimages.gui.views.ElementDataViewConfiguration;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.Settings;
import org.jzy3d.chart.factories.AWTChartComponentFactory;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Shape;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.OffscreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.ViewportMode;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;

public final class ShapeExporter {
    private ShapeExporter() {
    }

    public static void exportShape(Shape surface, boolean is3D, Quality quality, int size, File imageFile) throws IOException {
        ShapeExporter.exportShape(surface, is3D, quality, size, size, e -> {}, imageFile);
    }

    public static void exportShape(Shape surface, boolean is3D, Quality quality, int width, int height, File imageFile) throws IOException {
        ShapeExporter.exportShape(surface, is3D, quality, width, height, e -> {}, imageFile);
    }

    public static void exportShape(Shape surface, boolean is3D, Quality quality, int size, Consumer<Chart> chartConfigurer, File imageFile) throws IOException {
        ShapeExporter.exportShape(surface, is3D, quality, size, size, chartConfigurer, imageFile);
    }

    public static void exportShape(Shape surface, boolean is3D, Quality quality, int width, int height, Consumer<Chart> chartConfigurer, File imageFile) throws IOException {
        Chart chart = new Chart(ShapeExporter.getChartComponentFactory(is3D, width, height), quality);
        chart.getScene().getGraph().add((AbstractDrawable)surface);
        IAxeLayout axe = chart.getAxeLayout();
        axe.setZAxeLabelDisplayed(true);
        View view = chart.getView();
        view.setViewPositionMode(ViewPositionMode.TOP);
        view.setSquared(true);
        view.getCamera().setViewportMode(ViewportMode.STRETCH_TO_FILL);
        ShapeExporter.adjustFontSize(view, width, height);
        chartConfigurer.accept(chart);
        chart.screenshot(imageFile);
        ImageIO.write((RenderedImage)ImageIO.read(imageFile), "png", imageFile);
    }

    private static IChartComponentFactory getChartComponentFactory(boolean is3d, int width, int height) {
        if (is3d) {
            return new OffsetChart3dComponentFactory(width, height);
        }
        return new OffsetChart2dComponentFactory(width, height);
    }

    private static void adjustFontSize(View view, int width, int height) {
        AxeBox axeBox = (AxeBox)view.getAxe();
        if (width >= 1200 && height >= 1200) {
            axeBox.setTextRenderer((ITextRenderer)new TextBitmapRenderer(){
                {
                    this.font = 8;
                    this.fontHeight = 20;
                }
            });
        } else {
            axeBox.setTextRenderer((ITextRenderer)new TextBitmapRenderer(){
                {
                    this.font = 7;
                    this.fontHeight = 14;
                }
            });
        }
    }

    private static final class OffsetChart3dComponentFactory
    extends AWTChartComponentFactory {
        private final int width;
        private final int height;

        private OffsetChart3dComponentFactory(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public ICanvas newCanvas(IChartComponentFactory factory, Scene scene, Quality quality, String windowingToolkit, GLCapabilities capabilities) {
            return new OffscreenCanvas(factory, scene, ElementDataViewConfiguration.QUALITY, Settings.getInstance().getGLCapabilities(), this.width, this.height);
        }

        public ICanvas newCanvas(Scene scene, Quality quality, String windowingToolkit, GLCapabilities capabilities) {
            return this.newCanvas((IChartComponentFactory)this, scene, quality, windowingToolkit, capabilities);
        }
    }

    private static final class OffsetChart2dComponentFactory
    extends Chart2dComponentFactory {
        private final int width;
        private final int height;

        private OffsetChart2dComponentFactory(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public ICanvas newCanvas(IChartComponentFactory factory, Scene scene, Quality quality, String windowingToolkit, GLCapabilities capabilities) {
            return new OffscreenCanvas(factory, scene, ElementDataViewConfiguration.QUALITY, Settings.getInstance().getGLCapabilities(), this.width, this.height);
        }

        public ICanvas newCanvas(Scene scene, Quality quality, String windowingToolkit, GLCapabilities capabilities) {
            return this.newCanvas((IChartComponentFactory)this, scene, quality, windowingToolkit, capabilities);
        }
    }
}

