/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.util;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class JLimitedTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private int limit = Integer.MAX_VALUE;

    public JLimitedTextField(int limit) {
        this.limit = limit;
    }

    public JLimitedTextField(String string) {
        this.insertString(0, string);
    }

    public JLimitedTextField(String string, int limit) {
        this.limit = limit;
        this.insertString(0, string);
    }

    public JLimitedTextField(String string, int limit, int cols) {
        super(cols);
        this.limit = limit;
        this.insertString(0, string);
    }

    private void insertString(int offset, String s) {
        try {
            this.getDocument().insertString(offset, s, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new LimitDocument();
    }

    private class LimitDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private LimitDocument() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= JLimitedTextField.this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

