/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.licensing;

import es.uvigo.ei.sing.laimages.gui.views.components.RotationButtonsPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class IconAttributionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Font JLABEL = UIManager.getFont("Label.font");
    private static final Font PLAIN = JLABEL.deriveFont(0);
    private static final Font BOLD = JLABEL.deriveFont(1);
    private static final Font ITALIC = PLAIN.deriveFont(2);
    private static final ImageIcon ICON_ARROW = new ImageIcon(IconAttributionsPanel.class.getResource("icons/arrow.png"));
    private static final ImageIcon ICON_VIEW = new ImageIcon(IconAttributionsPanel.class.getResource("icons/view.png"));
    private AuthorAttribution[] attributions = new AuthorAttribution[]{new AuthorAttribution("Aleks", "the Noun Project Collection.", new AttributedIcon[]{new AttributedIcon(RotationButtonsPanel.ICON_UP, "Rotate")}), new AuthorAttribution("Arthur Shlain", "the Noun Project Collection.", new AttributedIcon[]{new AttributedIcon(RotationButtonsPanel.ICON_RESET, "Target")}), new AuthorAttribution("Molly Bramlet", "the Noun Project Collection.", new AttributedIcon[]{new AttributedIcon(ICON_ARROW, "Arrow")}), new AuthorAttribution("Felipe Santana", "the Noun Project Collection.", new AttributedIcon[]{new AttributedIcon(ICON_VIEW, "View")})};

    public IconAttributionsPanel() {
        this.init();
    }

    private void init() {
        this.add(this.getAttributionsPanel());
    }

    private JPanel getAttributionsPanel() {
        List<AuthorAttribution> attributions = this.getAttributions();
        JPanel attributionsPanel = new JPanel(new GridLayout(attributions.size(), 1));
        attributions.forEach(l -> attributionsPanel.add(l.getPanel()));
        return attributionsPanel;
    }

    protected List<AuthorAttribution> getAttributions() {
        return Arrays.asList(this.attributions);
    }

    protected static class AttributedIcon {
        private ImageIcon icon;
        private String name;

        public AttributedIcon(ImageIcon icon, String name) {
            this.icon = icon;
            this.name = name;
        }

        public Component getPanel() {
            JPanel panel = new JPanel(new FlowLayout(0));
            panel.add(new FontJLabel(this.name, BOLD));
            panel.add(new JLabel(this.icon));
            return panel;
        }
    }

    private static class FontJLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        public FontJLabel(String label, Font font) {
            super(label);
            this.setFont(font);
        }
    }

    protected static class AuthorAttribution {
        private AttributedIcon[] icons;
        private String author;
        private String affiliation;

        public AuthorAttribution(String author, String affiliation, AttributedIcon[] icons) {
            this.author = author;
            this.affiliation = affiliation;
            this.icons = icons;
        }

        public Component getPanel() {
            JPanel panel = new JPanel(new FlowLayout(0));
            for (int i = 0; i < this.icons.length; ++i) {
                panel.add(this.icons[i].getPanel());
                this.addSeparator(panel, i);
            }
            panel.add(new FontJLabel("by", PLAIN));
            panel.add(new FontJLabel(this.author, ITALIC));
            panel.add(new FontJLabel("from" + this.affiliation, PLAIN));
            return panel;
        }

        private void addSeparator(JPanel panel, int i) {
            if (i == this.icons.length - 1) {
                panel.add(new FontJLabel(this.icons.length == 1 ? "symbol" : "symbols", PLAIN));
            } else if (i == this.icons.length - 2) {
                panel.add(new FontJLabel("and", PLAIN));
            } else {
                panel.add(new FontJLabel(",", PLAIN));
            }
        }
    }
}

