/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.jzy3d;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.operations.Interpolator;
import es.uvigo.ei.sing.laimages.core.operations.ScaleElementData;
import es.uvigo.ei.sing.laimages.gui.jzy3d.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleFunction;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.builder.Builder;
import org.jzy3d.plot3d.primitives.Shape;

public class ElementDataSurfaceAdapter {
    private ElementData data;

    public ElementDataSurfaceAdapter(ElementData data) {
        this.data = data;
    }

    public Shape generateSurface(int interpolationLevel, IColorMap colorMap, Range colorMapRange, DoubleFunction<Double> scale) {
        List<Coord3d> coords = ElementDataSurfaceAdapter.dataToCoord3d(ScaleElementData.scale(scale, (ElementData)Interpolator.interpolate((ElementData)this.data, (int)interpolationLevel)));
        Shape surface = Builder.buildDelaunay(coords);
        surface.setColorMapper(new ColorMapper(colorMap, (org.jzy3d.maths.Range)colorMapRange));
        surface.setFaceDisplayed(true);
        surface.setWireframeDisplayed(false);
        return surface;
    }

    private static final List<Coord3d> dataToCoord3d(ElementData data) {
        ArrayList<Coord3d> coords = new ArrayList<Coord3d>();
        double[][] dataMatrix = data.getData(0.0);
        List xAxis = data.getXAxis();
        List yAxis = data.getYAxis();
        for (int xIndex = 0; xIndex < xAxis.size(); ++xIndex) {
            for (int yIndex = 0; yIndex < yAxis.size(); ++yIndex) {
                coords.add(new Coord3d(((Double)xAxis.get(xIndex)).doubleValue(), ((Double)yAxis.get(yIndex)).doubleValue(), dataMatrix[yIndex][xIndex]));
            }
        }
        return coords;
    }

    public static final Range getElementRange(ElementData data, DoubleFunction<Double> scale) {
        return new Range((float)scale.apply(data.getMinValue()).doubleValue(), (float)scale.apply(data.getMaxValue()).doubleValue());
    }
}

