/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.jzy3d;

import es.uvigo.ei.sing.laimages.gui.jzy3d.CoordinatesUtils;
import es.uvigo.ei.sing.laimages.gui.jzy3d.Range;
import es.uvigo.ei.sing.laimages.gui.views.ElementDataViewConfiguration;
import java.util.Optional;
import java.util.function.DoubleFunction;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.canvas.Quality;

public class ElementDataImageConfiguration {
    private int width;
    private int height;
    private Quality quality;
    private int interpolationLevel;
    private IColorMap colorMap;
    private Optional<Range> colorMapRange;
    private Coord2d viewPoint;
    private boolean showColorBarLegend;
    private boolean showAxes;
    private boolean showTickLines;
    private double scale;
    private boolean threeDimensional;

    public ElementDataImageConfiguration(int width, int height, Quality quality, int interpolationLevel, IColorMap colorMap, Optional<Range> colorMapRange, Coord2d viewPoint, boolean showColorBarLegend, boolean showAxes, boolean showTickLines, double scale, boolean is3D) {
        this.width = width;
        this.height = height;
        this.quality = quality;
        this.interpolationLevel = interpolationLevel;
        this.colorMap = colorMap;
        this.colorMapRange = colorMapRange;
        this.viewPoint = viewPoint;
        this.showColorBarLegend = showColorBarLegend;
        this.showAxes = showAxes;
        this.showTickLines = showTickLines;
        this.scale = scale;
        this.threeDimensional = is3D;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public int getInterpolationLevel() {
        return this.interpolationLevel;
    }

    public IColorMap getColorMap() {
        return this.colorMap;
    }

    public Optional<Range> getColorMapRange() {
        return this.colorMapRange;
    }

    public void setColorMapRange(Optional<Range> range) {
        this.colorMapRange = range;
    }

    public Coord2d getViewPoint() {
        return this.viewPoint;
    }

    public Coord3d get3DViewPoint() {
        return CoordinatesUtils.toCoord3d(this.viewPoint);
    }

    public boolean isShowColorBarLegend() {
        return this.showColorBarLegend;
    }

    public boolean isShowAxes() {
        return this.showAxes;
    }

    public boolean isShowTickLines() {
        return this.showTickLines;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean is3D() {
        return this.threeDimensional;
    }

    public boolean is2DFreeMode() {
        return !CoordinatesUtils.equalsTo(this.getViewPoint().x, ElementDataViewConfiguration.getDefault2DAngle().x) && !this.is3D();
    }

    public DoubleFunction<Double> getScaleFunction() {
        return d -> d * this.scale;
    }
}

