/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.jzy3d;

import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;

public class CoordinatesUtils {
    private static final Coord3d INCREMENT_2D = CoordinatesUtils.toCoord3d(new Coord2d(Math.toRadians(90.0), Math.toRadians(0.0)));
    private static final Coord3d INCREMENT_3D = CoordinatesUtils.toCoord3d(new Coord2d(Math.toRadians(180.0), Math.toRadians(0.0)));

    public static final Coord3d getDisplayAngle(Coord2d angle, boolean is3D) {
        return CoordinatesUtils.getDisplayAngle(CoordinatesUtils.toCoord3d(angle), is3D);
    }

    public static final Coord3d getDisplayAngle(Coord3d angle, boolean is3D) {
        Coord3d displayAngle = angle.clone().add(is3D ? INCREMENT_3D : INCREMENT_2D);
        return new Coord3d(CoordinatesUtils.computeX(displayAngle), (double)displayAngle.y, (double)displayAngle.z);
    }

    private static double computeX(Coord3d toret) {
        double x = toret.x;
        double actualXDegrees = Math.toDegrees(toret.x);
        if (actualXDegrees > 180.0) {
            double r = (actualXDegrees - 180.0) % 360.0;
            x = Math.toRadians(-180.0 + r);
        } else if (actualXDegrees < -180.0) {
            double r = Math.abs(180.0 + actualXDegrees) % 360.0;
            x = Math.toRadians(180.0 - r);
        }
        return x;
    }

    public static final Coord3d getRealAngle(Coord2d angle, boolean is3D) {
        return CoordinatesUtils.getRealAngle(CoordinatesUtils.toCoord3d(angle), is3D);
    }

    public static final Coord3d getRealAngle(Coord3d angle, boolean is3D) {
        if (is3D) {
            return angle.clone().sub(INCREMENT_3D);
        }
        return angle.clone().sub(INCREMENT_2D);
    }

    public static final boolean equalsTo(double x, double y) {
        return Math.abs(x - y) < 1.0E-5;
    }

    public static final Coord3d toCoord3d(Coord2d coord) {
        return new Coord3d(coord, 0.0f);
    }
}

