/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.export;

import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementData;
import es.uvigo.ei.sing.laimages.core.entities.datasets.ElementDataset;
import es.uvigo.ei.sing.laimages.core.operations.NormalizeElementData;
import es.uvigo.ei.sing.laimages.core.util.FileNameUtils;
import es.uvigo.ei.sing.laimages.core.util.ProgressHandler;
import es.uvigo.ei.sing.laimages.gui.export.ElementDatasetToPngExporter;
import es.uvigo.ei.sing.laimages.gui.jzy3d.ElementDataImageConfiguration;
import es.uvigo.ei.sing.laimages.gui.jzy3d.ElementDataSurfaceAdapter;
import es.uvigo.ei.sing.laimages.gui.jzy3d.Range;
import es.uvigo.ei.sing.laimages.gui.util.ShapeExporter;
import es.uvigo.ei.sing.laimages.gui.views.ElementDataViewConfiguration;
import java.io.File;
import java.io.IOException;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Shape;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;
import org.jzy3d.plot3d.rendering.legends.ILegend;
import org.jzy3d.plot3d.rendering.legends.colorbars.AWTColorbarLegend;

public class DefaultElementDatasetToPngExporter
implements ElementDatasetToPngExporter {
    @Override
    public void toPNG(ElementData data, File file, ElementDataImageConfiguration configuration) throws IOException {
        ElementData normalizedData = NormalizeElementData.normalize((ElementData)data);
        ElementDataSurfaceAdapter surfaceAdapter = new ElementDataSurfaceAdapter(normalizedData);
        Shape surface = surfaceAdapter.generateSurface(configuration.getInterpolationLevel(), configuration.getColorMap(), ElementDataViewConfiguration.normalizeColorMapRange(this.getColorMapRange(data, configuration), data), configuration.getScaleFunction());
        ShapeExporter.exportShape(surface, configuration.is3D(), configuration.getQuality(), configuration.getWidth(), configuration.getHeight(), c -> {
            if (configuration.is3D()) {
                c.setViewMode(ElementDataViewConfiguration.DEFAULT_3D_POSITION_MODE);
                c.setViewPoint(configuration.get3DViewPoint());
            } else if (configuration.is2DFreeMode()) {
                c.setViewMode(ElementDataViewConfiguration.FREE_2D_POSITION_MODE);
                c.setViewPoint(configuration.get3DViewPoint());
            } else {
                c.setViewMode(ElementDataViewConfiguration.DEFAULT_2D_POSITION_MODE);
            }
            c.setAxeDisplayed(configuration.isShowAxes());
            c.getAxeLayout().setTickLineDisplayed(configuration.isShowTickLines());
            c.getAxeLayout().setZAxeLabelDisplayed(configuration.is3D());
            c.getAxeLayout().setZTickLabelDisplayed(configuration.is3D());
            c.getView().setSquared(false);
            ITickRenderer tickRenderer = ElementDataViewConfiguration::formatAxeValue;
            c.getAxeLayout().setXTickRenderer(tickRenderer);
            c.getAxeLayout().setYTickRenderer(tickRenderer);
            c.getAxeLayout().setZTickRenderer(value -> ElementDataViewConfiguration.formatAxeValue(value * data.getMaxValue() / configuration.getScale()));
            if (configuration.isShowColorBarLegend()) {
                surface.setLegend((ILegend)new AWTColorbarLegend((AbstractDrawable)surface, c.getView().getAxe().getLayout()));
            }
        }, file);
    }

    @Override
    public void toPNG(ElementDataset dataset, File directory, ElementDataImageConfiguration configuration) throws IOException {
        this.toPNG(dataset, directory, configuration, () -> {});
    }

    @Override
    public void toPNG(ElementDataset dataset, File directory, ElementDataImageConfiguration configuration, ProgressHandler progressHandler) throws IOException {
        for (ElementData e : dataset.getElements()) {
            File elementFile = FileNameUtils.getFile((String)directory.toString(), (String)e.getName(), (String)".png");
            this.toPNG(e, elementFile, configuration);
            progressHandler.progress();
        }
    }

    private Range getColorMapRange(ElementData data, ElementDataImageConfiguration configuration) {
        boolean useElementRange = !configuration.getColorMapRange().isPresent();
        Range colorMapRange = useElementRange ? ElementDataSurfaceAdapter.getElementRange(data, configuration.getScaleFunction()) : configuration.getColorMapRange().get();
        return colorMapRange;
    }
}

