/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.dialogs;

import es.uvigo.ei.sing.laimages.gui.dialogs.InputJDialog;
import es.uvigo.ei.sing.laimages.gui.util.FloatTextField;
import es.uvigo.ei.sing.laimages.gui.views.components.event.EnterKeyPressedListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class RangeInputDialog
extends InputJDialog {
    private static final long serialVersionUID = 1L;
    public static final Color COLOR_INVALID_INPUT = new Color(255, 148, 148);
    public static final Color COLOR_VALID_INPUT = UIManager.getColor("TextField.background");
    private JPanel inputComponents;
    private JFormattedTextField minRangeValue;
    private JFormattedTextField maxRangeValue;

    public RangeInputDialog(JFrame parent, String title, String description) {
        super(parent, title, description);
        this.setResizable(false);
        this.cancelButton.setVisible(false);
    }

    @Override
    protected JPanel getInputComponents() {
        if (this.inputComponents == null) {
            this.inputComponents = new JPanel(new BorderLayout());
            this.minRangeValue = new FloatTextField(0.0f);
            this.maxRangeValue = new FloatTextField(1.0f);
            PropertyChangeListener listener = e -> this.checkRangeValues();
            this.minRangeValue.addPropertyChangeListener("value", listener);
            this.maxRangeValue.addPropertyChangeListener("value", listener);
            EnterKeyPressedListener keyListener = new EnterKeyPressedListener(this::onOkButtonClicked);
            this.minRangeValue.addKeyListener(keyListener);
            this.maxRangeValue.addKeyListener(keyListener);
            this.minRangeValue.addFocusListener(FOCUS_LISTENER);
            this.maxRangeValue.addFocusListener(FOCUS_LISTENER);
            JPanel minValuePanel = new JPanel();
            minValuePanel.setLayout(new BorderLayout());
            minValuePanel.add((Component)new JLabel("Minimum: "), "West");
            minValuePanel.add((Component)this.minRangeValue, "Center");
            JPanel maxValuePanel = new JPanel();
            maxValuePanel.setLayout(new BorderLayout());
            maxValuePanel.add((Component)new JLabel("Maximum: "), "West");
            maxValuePanel.add((Component)this.maxRangeValue, "Center");
            this.inputComponents.add((Component)minValuePanel, "North");
            this.inputComponents.add((Component)maxValuePanel, "South");
        }
        return this.inputComponents;
    }

    @Override
    protected JTextArea getDescriptionPane() {
        JTextArea descripionPane = super.getDescriptionPane();
        descripionPane.setPreferredSize(new Dimension(165, 75));
        return descripionPane;
    }

    private void checkRangeValues() {
        boolean validRange = this.isRangeValuesValid();
        this.setRangeTextFieldColor(validRange);
        this.checkEnabled();
    }

    private boolean isRangeValuesValid() {
        return this.getMinValue() < this.getMaxValue();
    }

    public float getMaxValue() {
        return ((Float)this.maxRangeValue.getValue()).floatValue();
    }

    public void setMaxValue(float max) {
        this.maxRangeValue.setValue(Float.valueOf(max));
    }

    public float getMinValue() {
        return ((Float)this.minRangeValue.getValue()).floatValue();
    }

    public void setMinValue(float min) {
        this.minRangeValue.setValue(Float.valueOf(min));
    }

    private void setRangeTextFieldColor(boolean validValues) {
        Color backgroundColor = this.getTextFieldBackgroundColor(validValues);
        this.minRangeValue.setBackground(backgroundColor);
        this.maxRangeValue.setBackground(backgroundColor);
    }

    private Color getTextFieldBackgroundColor(boolean validValues) {
        return validValues ? COLOR_VALID_INPUT : COLOR_INVALID_INPUT;
    }

    @Override
    protected void checkEnabled() {
        this.okButton.setEnabled(this.isRangeValuesValid());
    }
}

