/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class InputJDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final ImageIcon ICON_ACCEPT = new ImageIcon(InputJDialog.class.getResource("icons/ok.png"));
    protected static final ImageIcon ICON_CANCEL = new ImageIcon(InputJDialog.class.getResource("icons/cancel.png"));
    protected static final ImageIcon ICON_BROWSE = new ImageIcon(InputJDialog.class.getResource("icons/browse.png"));
    protected static final ImageIcon ICON_HELP = new ImageIcon(InputJDialog.class.getResource("icons/help.png"));
    protected static final FocusListener FOCUS_LISTENER = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getComponent() instanceof JTextField) {
                SwingUtilities.invokeLater(() -> ((JTextField)e.getComponent()).selectAll());
            }
        }
    };
    protected JFrame parent;
    private JTextArea descriptionArea;
    private String description;
    protected JButton okButton;
    protected JButton cancelButton;
    protected boolean canceled = true;

    protected InputJDialog(JFrame parent, String title, String description) {
        super(parent);
        this.parent = parent;
        this.description = description;
        this.setModal(true);
        this.setTitle(title);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDescriptionPane(), "North");
        this.add((Component)new JScrollPane(this.getInputComponents()), "Center");
        this.add(this.getButtonsPane(), "South");
        this.setResizable(true);
        this.setIconsVisible(false);
        this.centerDialogOnParent();
        this.checkEnabled();
        this.addKeyBindings();
    }

    protected JTextArea getDescriptionPane() {
        if (this.descriptionArea == null) {
            this.descriptionArea = new JTextArea(this.description);
            this.descriptionArea.setMargin(new Insets(10, 10, 10, 10));
            this.descriptionArea.setWrapStyleWord(true);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setEditable(false);
            this.descriptionArea.setBackground(Color.WHITE);
            this.descriptionArea.setOpaque(true);
        }
        return this.descriptionArea;
    }

    protected abstract JComponent getInputComponents();

    protected abstract void checkEnabled();

    protected Component getButtonsPane() {
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.okButton = new JButton("OK", ICON_ACCEPT);
        this.okButton.setEnabled(false);
        this.okButton.setToolTipText("Accept");
        this.okButton.addActionListener(a -> this.onOkButtonClicked());
        this.cancelButton = new JButton("Cancel", ICON_CANCEL);
        this.cancelButton.setToolTipText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputJDialog.this.canceled = true;
                InputJDialog.this.dispose();
            }
        });
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        InputMap im = this.okButton.getInputMap();
        im.put(KeyStroke.getKeyStroke("ENTER"), "pressed");
        im.put(KeyStroke.getKeyStroke("released ENTER"), "released");
        return buttonsPanel;
    }

    protected void onOkButtonClicked() {
        this.canceled = false;
        this.dispose();
    }

    protected void addKeyBindings() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "closeTheDialog");
        this.getRootPane().getActionMap().put("closeTheDialog", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                InputJDialog.this.canceled = true;
                InputJDialog.this.dispose();
            }
        });
    }

    protected void centerDialogOnParent() {
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    @Override
    public void setVisible(boolean b) {
        this.pack();
        super.setVisible(b);
    }

    public void setIconsVisible(boolean enabled) {
        this.okButton.setIcon(enabled ? ICON_ACCEPT : null);
        this.cancelButton.setIcon(enabled ? ICON_CANCEL : null);
    }

    protected void addFocusListener(JTextField tF) {
        tF.addFocusListener(FOCUS_LISTENER);
    }
}

