/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.dialogs;

import es.uvigo.ei.sing.laimages.core.io.csv.CSVFormat;
import es.uvigo.ei.sing.laimages.gui.dialogs.ExportDialog;
import es.uvigo.ei.sing.laimages.gui.util.GUIUtils;
import es.uvigo.ei.sing.laimages.gui.util.JLimitedTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class ExportCsvDialog
extends ExportDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Export to CSV";
    private static final String DESCRIPTION = "This dialog allows you to export the data as a CSV file(s). You can select a preconfigured format (Excel, Libre/Open Office) or Custom to customize it.";
    private JPanel inputComponents;
    private JXTaskPane customFormatOptionsTaskPane;
    private JComboBox<CSVFormat.FileFormat> fileFormatCB;
    private File selectedFile;
    private JTextField fileName;
    private JRadioButton rbtnSepTab;
    private JRadioButton rbtnSepCustom;
    private JTextField txtFieldCustomColumnSeparator;
    private JRadioButton rbtnDecimalSepPoint;
    private JRadioButton rbtnDecimalSepComma;
    private JRadioButton rbtnDecimalSepCustom;
    private JTextField txtFieldCustomDecimalPoint;
    private JRadioButton rbtnLineSepWindows;
    private JRadioButton rbtnLineSepLinux;
    private JRadioButton rbtnLineSepMacOS;
    private JCheckBox quoteHeaders;
    private final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
    private String singleFileName;

    public ExportCsvDialog(JFrame parent, String singleFileName) {
        super(parent, TITLE, DESCRIPTION);
        this.singleFileName = singleFileName;
        this.configureDialogFile();
        this.setResizable(true);
        this.setIconsVisible(false);
        this.centerDialogOnParent();
        this.checkEnabled();
    }

    private void configureDialogFile() {
        File selectedDataFile = GUIUtils.getFileChooserSelectedFile(this.getFileChooser(), this.isAcceptDirectoriesOnly(), this.singleFileName);
        this.setSelectedFile(selectedDataFile);
    }

    @Override
    protected JComponent getInputComponents() {
        UIManager.put("TaskPane.animate", Boolean.FALSE);
        if (this.inputComponents != null) {
            throw new RuntimeException("Can't create input components twice (app bug)");
        }
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        formatter.setCommitsOnValidEdit(true);
        JPanel optionsPane = new JPanel();
        GroupLayout groupLayout = new GroupLayout(optionsPane);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        optionsPane.setLayout(groupLayout);
        JLabel lblFormat = new JLabel("Format");
        JLabel lblFormatHelp = new JLabel(ICON_HELP);
        lblFormatHelp.setToolTipText("The file format");
        this.fileFormatCB = new JComboBox();
        this.fileFormatCB.setModel(new DefaultComboBoxModel<CSVFormat.FileFormat>(CSVFormat.FileFormat.values()));
        this.fileFormatCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ExportCsvDialog.this.fileFormatSelectionChanged();
                }
            }
        });
        JLabel lblFileName = new JLabel("File");
        JLabel lblFileNameHelp = new JLabel(ICON_HELP);
        if (this.isAcceptDirectoriesOnly()) {
            lblFileNameHelp.setToolTipText("The selected directory to export the data");
        } else {
            lblFileNameHelp.setToolTipText("The selected file to export the data");
        }
        this.fileName = new JTextField("", 20);
        this.fileName.setEditable(false);
        this.fileName.addMouseListener(this.getBrowseListener());
        JButton browseButton = new JButton(ICON_BROWSE);
        browseButton.setToolTipText("Opens a file chooser to select a file");
        browseButton.addMouseListener(this.getBrowseListener());
        JPanel fileChooserPanel = new JPanel(new BorderLayout());
        fileChooserPanel.add((Component)this.fileName, "Center");
        fileChooserPanel.add((Component)browseButton, "East");
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(lblFileName, GroupLayout.Alignment.TRAILING).addComponent(lblFormat, GroupLayout.Alignment.TRAILING)).addGroup(groupLayout.createParallelGroup().addComponent(fileChooserPanel).addComponent(this.fileFormatCB)).addGroup(groupLayout.createParallelGroup().addComponent(lblFileNameHelp).addComponent(lblFormatHelp)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(lblFileName, GroupLayout.Alignment.CENTER).addComponent(fileChooserPanel, GroupLayout.Alignment.CENTER).addComponent(lblFileNameHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblFormat, GroupLayout.Alignment.CENTER).addComponent(this.fileFormatCB, GroupLayout.Alignment.CENTER).addComponent(lblFormatHelp, GroupLayout.Alignment.CENTER)));
        JXTaskPaneContainer customOptionsTaskPaneContainer = new JXTaskPaneContainer();
        customOptionsTaskPaneContainer.setOpaque(false);
        customOptionsTaskPaneContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.customFormatOptionsTaskPane = new JXTaskPane();
        this.customFormatOptionsTaskPane.setTitle("Custom format");
        this.customFormatOptionsTaskPane.setCollapsed(true);
        this.customFormatOptionsTaskPane.addPropertyChangeListener("collapsed", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ExportCsvDialog.this.pack();
            }
        });
        JPanel customOptionsPane = new JPanel();
        GroupLayout customOptionsGroupLayout = new GroupLayout(customOptionsPane);
        customOptionsGroupLayout.setAutoCreateContainerGaps(true);
        customOptionsGroupLayout.setAutoCreateGaps(true);
        customOptionsPane.setLayout(customOptionsGroupLayout);
        this.customFormatOptionsTaskPane.add((Component)customOptionsPane, (Object)"Center");
        customOptionsTaskPaneContainer.add((Component)this.customFormatOptionsTaskPane);
        ActionListener columnSeparatorListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCsvDialog.this.checkCustomSeparatorButtons();
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCsvDialog.this.formatCustomized();
            }
        };
        JLabel lblQuoteHeaders = new JLabel("Quote headers");
        JLabel lblQuoteHeadersHelp = new JLabel(ICON_HELP);
        lblQuoteHeadersHelp.setToolTipText("Sets wether table headers should be quoted");
        JPanel quotePanel = new JPanel(new GridLayout(1, 1));
        this.quoteHeaders = new JCheckBox("", false);
        this.quoteHeaders.addActionListener(actionListener);
        quotePanel.add(this.quoteHeaders);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportCsvDialog.this.checkEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportCsvDialog.this.checkEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportCsvDialog.this.checkEnabled();
            }
        };
        JLabel lblColumnSeparator = new JLabel("Column separator");
        JLabel lblColumnSeparatorHelp = new JLabel(ICON_HELP);
        lblColumnSeparatorHelp.setToolTipText("Sets the column separator");
        JPanel columnSeparatorPanel = new JPanel(new GridLayout(1, 3));
        this.rbtnSepTab = new JRadioButton("Tabulator");
        this.rbtnSepTab.setSelected(false);
        this.rbtnSepCustom = new JRadioButton("CUSTOM");
        this.rbtnSepCustom.setSelected(true);
        this.txtFieldCustomColumnSeparator = new JLimitedTextField(",", 1, 3);
        this.txtFieldCustomColumnSeparator.getDocument().addDocumentListener(documentListener);
        Dimension size = new Dimension(25, 25);
        this.txtFieldCustomColumnSeparator.setMaximumSize(size);
        this.txtFieldCustomColumnSeparator.setSize(size);
        this.txtFieldCustomColumnSeparator.addFocusListener(FOCUS_LISTENER);
        JPanel customColumnSeparatorTFPanel = new JPanel();
        BoxLayout cCSPanelLayout = new BoxLayout(customColumnSeparatorTFPanel, 0);
        customColumnSeparatorTFPanel.setLayout(cCSPanelLayout);
        customColumnSeparatorTFPanel.add(Box.createHorizontalGlue(), "East");
        customColumnSeparatorTFPanel.add(this.txtFieldCustomColumnSeparator);
        columnSeparatorPanel.add(this.rbtnSepTab);
        columnSeparatorPanel.add(this.rbtnSepCustom);
        columnSeparatorPanel.add(customColumnSeparatorTFPanel);
        ButtonGroup separatorGroup = new ButtonGroup();
        separatorGroup.add(this.rbtnSepTab);
        separatorGroup.add(this.rbtnSepCustom);
        this.rbtnSepTab.addActionListener(columnSeparatorListener);
        this.rbtnSepCustom.addActionListener(columnSeparatorListener);
        this.rbtnSepTab.addActionListener(actionListener);
        this.rbtnSepCustom.addActionListener(actionListener);
        JLabel lblDecimalSeparator = new JLabel("Decimal separator");
        JLabel lblDecimalSeparatorHelp = new JLabel(ICON_HELP);
        lblDecimalSeparatorHelp.setToolTipText("Sets the decimal separator");
        JPanel decimalSeparatorPanel = new JPanel(new GridLayout(1, 4));
        this.rbtnDecimalSepPoint = new JRadioButton("Point");
        this.rbtnDecimalSepPoint.setSelected(true);
        this.rbtnDecimalSepPoint.addActionListener(actionListener);
        this.rbtnDecimalSepComma = new JRadioButton("Comma");
        this.rbtnDecimalSepComma.setSelected(false);
        this.rbtnDecimalSepComma.addActionListener(actionListener);
        this.rbtnDecimalSepCustom = new JRadioButton("CUSTOM");
        this.rbtnDecimalSepCustom.setSelected(false);
        this.rbtnDecimalSepCustom.addActionListener(actionListener);
        this.txtFieldCustomDecimalPoint = new JLimitedTextField(".", 1, 3);
        this.txtFieldCustomDecimalPoint.getDocument().addDocumentListener(documentListener);
        this.txtFieldCustomDecimalPoint.setMaximumSize(size);
        this.txtFieldCustomDecimalPoint.setSize(size);
        this.txtFieldCustomDecimalPoint.addFocusListener(FOCUS_LISTENER);
        JPanel customDecimalPointTFPanel = new JPanel();
        BoxLayout cDPPanelLayout = new BoxLayout(customDecimalPointTFPanel, 0);
        customDecimalPointTFPanel.setLayout(cDPPanelLayout);
        customDecimalPointTFPanel.add(Box.createHorizontalGlue(), "East");
        customDecimalPointTFPanel.add((Component)this.txtFieldCustomDecimalPoint, "East");
        decimalSeparatorPanel.add(this.rbtnDecimalSepPoint);
        decimalSeparatorPanel.add(this.rbtnDecimalSepComma);
        decimalSeparatorPanel.add(this.rbtnDecimalSepCustom);
        decimalSeparatorPanel.add(customDecimalPointTFPanel);
        ButtonGroup decimalPointGroup = new ButtonGroup();
        decimalPointGroup.add(this.rbtnDecimalSepPoint);
        decimalPointGroup.add(this.rbtnDecimalSepComma);
        decimalPointGroup.add(this.rbtnDecimalSepCustom);
        ActionListener decimalPointListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCsvDialog.this.checkDecimalPointButtons();
            }
        };
        this.rbtnDecimalSepPoint.addActionListener(decimalPointListener);
        this.rbtnDecimalSepComma.addActionListener(decimalPointListener);
        this.rbtnDecimalSepCustom.addActionListener(decimalPointListener);
        JLabel lblLineSeparator = new JLabel("Line break");
        JLabel lblLineSeparatorHelp = new JLabel(ICON_HELP);
        lblLineSeparatorHelp.setToolTipText("Sets the line break");
        JPanel lineSeparatorPanel = new JPanel(new GridLayout(1, 3));
        this.rbtnLineSepWindows = new JRadioButton("Windows");
        this.rbtnLineSepWindows.setSelected(true);
        this.rbtnLineSepWindows.addActionListener(actionListener);
        this.rbtnLineSepLinux = new JRadioButton("Linux");
        this.rbtnLineSepLinux.setSelected(false);
        this.rbtnLineSepLinux.addActionListener(actionListener);
        this.rbtnLineSepMacOS = new JRadioButton("Mac OS X");
        this.rbtnLineSepMacOS.setSelected(false);
        this.rbtnLineSepMacOS.addActionListener(actionListener);
        lineSeparatorPanel.add(this.rbtnLineSepWindows);
        lineSeparatorPanel.add(this.rbtnLineSepLinux);
        lineSeparatorPanel.add(this.rbtnLineSepMacOS);
        ButtonGroup lineBreakGroup = new ButtonGroup();
        lineBreakGroup.add(this.rbtnLineSepWindows);
        lineBreakGroup.add(this.rbtnLineSepLinux);
        lineBreakGroup.add(this.rbtnLineSepMacOS);
        customOptionsGroupLayout.setHorizontalGroup(customOptionsGroupLayout.createSequentialGroup().addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblQuoteHeaders, GroupLayout.Alignment.TRAILING).addComponent(lblColumnSeparator, GroupLayout.Alignment.TRAILING).addComponent(lblDecimalSeparator, GroupLayout.Alignment.TRAILING).addComponent(lblLineSeparator, GroupLayout.Alignment.TRAILING)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(quotePanel).addComponent(columnSeparatorPanel).addComponent(decimalSeparatorPanel).addComponent(lineSeparatorPanel)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblQuoteHeadersHelp).addComponent(lblColumnSeparatorHelp).addComponent(lblDecimalSeparatorHelp).addComponent(lblLineSeparatorHelp)));
        customOptionsGroupLayout.setVerticalGroup(customOptionsGroupLayout.createSequentialGroup().addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblQuoteHeaders, GroupLayout.Alignment.CENTER).addComponent(quotePanel, GroupLayout.Alignment.CENTER).addComponent(lblQuoteHeadersHelp, GroupLayout.Alignment.CENTER)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblColumnSeparator, GroupLayout.Alignment.CENTER).addComponent(columnSeparatorPanel, GroupLayout.Alignment.CENTER).addComponent(lblColumnSeparatorHelp, GroupLayout.Alignment.CENTER)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblDecimalSeparator, GroupLayout.Alignment.CENTER).addComponent(decimalSeparatorPanel, GroupLayout.Alignment.CENTER).addComponent(lblDecimalSeparatorHelp, GroupLayout.Alignment.CENTER)).addGroup(customOptionsGroupLayout.createParallelGroup().addComponent(lblLineSeparator, GroupLayout.Alignment.CENTER).addComponent(lineSeparatorPanel, GroupLayout.Alignment.CENTER).addComponent(lblLineSeparatorHelp, GroupLayout.Alignment.CENTER)));
        JPanel toret = new JPanel(new BorderLayout());
        toret.add((Component)optionsPane, "North");
        toret.add((Component)customOptionsTaskPaneContainer, "Center");
        return toret;
    }

    protected void formatCustomized() {
        if (!this.fileFormatCB.getSelectedItem().equals(CSVFormat.FileFormat.CUSTOM)) {
            this.fileFormatCB.setSelectedItem(CSVFormat.FileFormat.CUSTOM);
        }
    }

    protected void fileFormatSelectionChanged() {
        CSVFormat.FileFormat selectedItem = (CSVFormat.FileFormat)this.fileFormatCB.getSelectedItem();
        this.customFormatOptionsTaskPane.setCollapsed(!selectedItem.equals((Object)CSVFormat.FileFormat.CUSTOM));
        if (!selectedItem.equals((Object)CSVFormat.FileFormat.CUSTOM)) {
            this.updateCustomValues(selectedItem);
        }
        this.checkEnabled();
    }

    private void updateCustomValues(CSVFormat.FileFormat format) {
        this.rbtnDecimalSepCustom.setSelected(true);
        this.rbtnSepCustom.setSelected(true);
        this.quoteHeaders.setSelected(false);
        this.txtFieldCustomDecimalPoint.setText(String.valueOf(this.symbols.getDecimalSeparator()));
        if (format.equals((Object)CSVFormat.FileFormat.EXCEL)) {
            this.rbtnLineSepWindows.setSelected(true);
            this.txtFieldCustomColumnSeparator.setText(";");
        } else if (format.equals((Object)CSVFormat.FileFormat.LIBRE_OFFICE)) {
            this.rbtnLineSepLinux.setSelected(true);
            if (this.symbols.getDecimalSeparator() == ',') {
                this.txtFieldCustomColumnSeparator.setText(";");
            } else {
                this.txtFieldCustomColumnSeparator.setText(",");
            }
        }
    }

    protected void checkCustomSeparatorButtons() {
        this.txtFieldCustomColumnSeparator.setEditable(this.rbtnSepCustom.isSelected());
        this.checkEnabled();
    }

    protected void checkDecimalPointButtons() {
        this.txtFieldCustomDecimalPoint.setEditable(this.rbtnDecimalSepCustom.isSelected());
        this.checkEnabled();
    }

    private boolean checkSeparators() {
        if (this.fileFormatCB.getSelectedItem().equals(CSVFormat.FileFormat.CUSTOM) && !this.getColumnSeparator().equals("") && this.getColumnSeparator().charAt(0) == this.getDecimalSeparator()) {
            JOptionPane.showMessageDialog(this, "You have selected the same column and decimal separator, which may result in an unreadable file.", "Invalid configuration", 2);
            return false;
        }
        return true;
    }

    @Override
    protected void setSelectedFile(File newFile) {
        this.selectedFile = newFile;
        if (!this.isAcceptDirectoriesOnly() && !newFile.getName().toLowerCase().endsWith(".csv")) {
            this.selectedFile = new File(newFile.getAbsolutePath() + ".csv");
        }
        this.fileName.setText(this.selectedFile.getAbsolutePath());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public CSVFormat getCSVFormat() {
        CSVFormat toret;
        CSVFormat.FileFormat selectedFormat = (CSVFormat.FileFormat)this.fileFormatCB.getSelectedItem();
        if (selectedFormat.equals((Object)CSVFormat.FileFormat.EXCEL) || selectedFormat.equals((Object)CSVFormat.FileFormat.LIBRE_OFFICE)) {
            try {
                toret = new CSVFormat(selectedFormat);
            }
            catch (Exception e) {
                return null;
            }
        } else {
            toret = new CSVFormat(this.getColumnSeparator(), this.getDecimalSeparator(), this.quoteHeaders.isSelected(), this.getLineBreak());
        }
        return toret;
    }

    private String getColumnSeparator() {
        String columnSeparator = this.rbtnSepTab.isSelected() ? "\t" : (this.rbtnSepCustom.isSelected() ? this.txtFieldCustomColumnSeparator.getText() : null);
        return columnSeparator;
    }

    private char getDecimalSeparator() {
        int decimalSeparator = this.rbtnDecimalSepComma.isSelected() ? 44 : (this.rbtnDecimalSepPoint.isSelected() ? 46 : (this.rbtnDecimalSepCustom.isSelected() ? (int)this.txtFieldCustomDecimalPoint.getText().charAt(0) : 0));
        return (char)decimalSeparator;
    }

    private String getLineBreak() {
        String lineBreak = this.rbtnLineSepWindows.isSelected() ? "\r\n" : "\n";
        return lineBreak;
    }

    @Override
    public File getSelectedFile() {
        return this.selectedFile;
    }

    @Override
    protected void checkEnabled() {
        this.okButton.setEnabled(this.getSelectedFile() != null && this.checkSeparators());
    }

    @Override
    public void setVisible(boolean b) {
        this.fileFormatCB.setSelectedItem(CSVFormat.FileFormat.EXCEL);
        super.setVisible(b);
    }

    @Override
    protected boolean isAcceptDirectoriesOnly() {
        return false;
    }
}

