/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.dialogs;

import es.uvigo.ei.sing.laimages.gui.dialogs.ExportDialog;
import es.uvigo.ei.sing.laimages.gui.util.GUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;

public class ExportAsPngDialog
extends ExportDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Export to PNG";
    private static final String DESCRIPTION = "This dialog allows you to export the current chart as a PNG file with the current settings.";
    private JPanel inputComponents;
    private File selectedFile;
    private JTextField fileName;
    private JFormattedTextField widthTF;
    private JFormattedTextField heightTF;
    private String singleFileName;

    public ExportAsPngDialog(JFrame parent, String singleFileName) {
        super(parent, TITLE, DESCRIPTION);
        this.singleFileName = singleFileName;
        this.configureDialogFile();
        this.setResizable(true);
        this.setIconsVisible(false);
        this.centerDialogOnParent();
        this.checkEnabled();
    }

    private void configureDialogFile() {
        File selectedDataFile = GUIUtils.getFileChooserSelectedFile(this.getFileChooser(), this.isAcceptDirectoriesOnly(), this.singleFileName);
        this.setSelectedFile(selectedDataFile);
    }

    @Override
    protected JPanel getInputComponents() {
        UIManager.put("TaskPane.animate", Boolean.FALSE);
        if (this.inputComponents != null) {
            throw new RuntimeException("Can't create input components twice (app bug)");
        }
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        formatter.setCommitsOnValidEdit(true);
        JPanel optionsPane = new JPanel();
        GroupLayout groupLayout = new GroupLayout(optionsPane);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        optionsPane.setLayout(groupLayout);
        JLabel lblFileName = new JLabel("File");
        JLabel lblFileNameHelp = new JLabel(ICON_HELP);
        if (this.isAcceptDirectoriesOnly()) {
            lblFileNameHelp.setToolTipText("The selected directory to export the images");
        } else {
            lblFileNameHelp.setToolTipText("The selected file to export the image");
        }
        this.fileName = new JTextField("", 20);
        this.fileName.setEditable(false);
        this.fileName.addMouseListener(this.getBrowseListener());
        JButton browseButton = new JButton(ICON_BROWSE);
        browseButton.setToolTipText("Opens a file chooser to select a file");
        browseButton.addMouseListener(this.getBrowseListener());
        JPanel fileChooserPanel = new JPanel(new BorderLayout());
        fileChooserPanel.add((Component)this.fileName, "Center");
        fileChooserPanel.add((Component)browseButton, "East");
        JLabel lblImageSize = new JLabel("Size");
        JLabel lblImageSizeHelp = new JLabel(ICON_HELP);
        lblImageSizeHelp.setToolTipText("Sets the size in px of the image");
        JPanel imageSizePanel = this.getImageSizePanel();
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(lblFileName, GroupLayout.Alignment.TRAILING).addComponent(lblImageSize, GroupLayout.Alignment.TRAILING)).addGroup(groupLayout.createParallelGroup().addComponent(fileChooserPanel).addComponent(imageSizePanel)).addGroup(groupLayout.createParallelGroup().addComponent(lblFileNameHelp).addComponent(lblImageSizeHelp)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(lblFileName, GroupLayout.Alignment.CENTER).addComponent(fileChooserPanel, GroupLayout.Alignment.CENTER).addComponent(lblFileNameHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblImageSize, GroupLayout.Alignment.CENTER).addComponent(imageSizePanel, GroupLayout.Alignment.CENTER).addComponent(lblImageSizeHelp, GroupLayout.Alignment.CENTER)));
        JPanel toret = new JPanel(new BorderLayout());
        toret.add((Component)optionsPane, "North");
        return toret;
    }

    private JPanel getImageSizePanel() {
        JPanel imageSizePanel = new JPanel();
        imageSizePanel.setLayout(new GridLayout(1, 4));
        NumberFormat format = NumberFormat.getInstance();
        format.setGroupingUsed(false);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        formatter.setCommitsOnValidEdit(true);
        this.widthTF = new JFormattedTextField(formatter);
        this.widthTF.setValue(1200);
        this.widthTF.addFocusListener(FOCUS_LISTENER);
        this.heightTF = new JFormattedTextField(formatter);
        this.heightTF.setValue(1000);
        this.heightTF.addFocusListener(FOCUS_LISTENER);
        imageSizePanel.add(new JLabel(" Width:"));
        imageSizePanel.add(this.widthTF);
        imageSizePanel.add(new JLabel(" Height:"));
        imageSizePanel.add(this.heightTF);
        return imageSizePanel;
    }

    @Override
    protected void setSelectedFile(File newFile) {
        this.selectedFile = newFile;
        if (!this.isAcceptDirectoriesOnly() && !newFile.getName().toLowerCase().endsWith(".png")) {
            this.selectedFile = new File(newFile.getAbsolutePath() + ".png");
        }
        this.fileName.setText(this.selectedFile.getAbsolutePath());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public File getSelectedFile() {
        return this.selectedFile;
    }

    @Override
    protected void checkEnabled() {
        this.okButton.setEnabled(this.getSelectedFile() != null && this.checkImageSize());
    }

    private boolean checkImageSize() {
        return this.getSelectedHeight() > 0 && this.getSelectedWidth() > 0;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public int getSelectedWidth() {
        return (Integer)this.widthTF.getValue();
    }

    public int getSelectedHeight() {
        return (Integer)this.heightTF.getValue();
    }

    @Override
    protected boolean isAcceptDirectoriesOnly() {
        return false;
    }
}

