/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.laimages.gui.dialogs;

import es.uvigo.ei.sing.laimages.gui.dialogs.ExportDialog;
import es.uvigo.ei.sing.laimages.gui.dialogs.RangeInputDialog;
import es.uvigo.ei.sing.laimages.gui.jzy3d.Range;
import es.uvigo.ei.sing.laimages.gui.util.FloatTextField;
import es.uvigo.ei.sing.laimages.gui.util.GUIUtils;
import es.uvigo.ei.sing.laimages.gui.views.ElementDataViewConfiguration;
import es.uvigo.ei.sing.laimages.gui.views.components.ScaleSpinner;
import es.uvigo.ei.sing.laimages.gui.views.components.ViewPointEditorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.plot3d.rendering.canvas.Quality;

public class ExportAllAsPngDialog
extends ExportDialog {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Export to PNG";
    private static final String DESCRIPTION = "This dialog allows you to export al the elements as a PNG files. You can configure the settings for the images.";
    private JPanel inputComponents;
    private JComboBox<ElementDataViewConfiguration.InterpolationLevel> interpolationLevelCB;
    private JComboBox<ElementDataViewConfiguration.ColorMap> colorMapCB;
    private JComboBox<ElementDataViewConfiguration.ColorMapRangeMode> rangeModeCB;
    private JCheckBox viewerModeCB;
    private JCheckBox showColorBarLegendCB;
    private JCheckBox showAxesCB;
    private JCheckBox showTickLinesCB;
    private File selectedFile;
    private JTextField fileName;
    private JFormattedTextField widthTF;
    private JFormattedTextField heightTF;
    private JFormattedTextField minRangeValue;
    private JFormattedTextField maxRangeValue;
    private Range datasetRange;
    private Coord2d currentViewPoint;
    private ScaleSpinner scaleSpinner;
    private JRadioButton rbDefaultViewPoint;
    private JRadioButton rbActualViewPoint;
    private JRadioButton rbCustomViewPoint;
    private ViewPointEditorPanel viewPointEditorPanel;

    public ExportAllAsPngDialog(JFrame parent) {
        super(parent, TITLE, DESCRIPTION);
        this.configureDialogFile();
        this.setResizable(true);
        this.setIconsVisible(false);
        this.centerDialogOnParent();
        this.checkEnabled();
    }

    private void configureDialogFile() {
        File selectedDataFile = GUIUtils.getFileChooserSelectedFile(this.getFileChooser(), this.isAcceptDirectoriesOnly(), "");
        this.setSelectedFile(selectedDataFile);
    }

    @Override
    protected JPanel getInputComponents() {
        UIManager.put("TaskPane.animate", Boolean.FALSE);
        if (this.inputComponents != null) {
            throw new RuntimeException("Can't create input components twice (app bug)");
        }
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        formatter.setCommitsOnValidEdit(true);
        JPanel optionsPane = new JPanel();
        GroupLayout groupLayout = new GroupLayout(optionsPane);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        optionsPane.setLayout(groupLayout);
        JLabel lblInterpolationLevel = new JLabel("Interpolation level");
        JLabel lblInterpolationLevelHelp = new JLabel(ICON_HELP);
        lblInterpolationLevelHelp.setToolTipText("The interpolation level.");
        this.interpolationLevelCB = new JComboBox();
        this.interpolationLevelCB.setModel(new DefaultComboBoxModel<ElementDataViewConfiguration.InterpolationLevel>(ElementDataViewConfiguration.InterpolationLevel.values()));
        JLabel lblColorMap = new JLabel("Color map");
        JLabel lblColorMapHelp = new JLabel(ICON_HELP);
        lblColorMapHelp.setToolTipText("The color map.");
        this.colorMapCB = new JComboBox();
        this.colorMapCB.setModel(new DefaultComboBoxModel<ElementDataViewConfiguration.ColorMap>(ElementDataViewConfiguration.ColorMap.values()));
        JLabel lblViewerMode = new JLabel("3D view");
        JLabel lblViewerModeHelp = new JLabel(ICON_HELP);
        lblViewerModeHelp.setToolTipText("Check if you want a 3D image.");
        this.viewerModeCB = new JCheckBox();
        this.viewerModeCB.addItemListener(e -> this.positionModeChanged());
        JLabel lblScale = new JLabel("Scale");
        JLabel lblScaleHelp = new JLabel(ICON_HELP);
        lblScaleHelp.setToolTipText("The image scale. Note that it only applies if 3D is selected");
        this.scaleSpinner = new ScaleSpinner();
        ((JSpinner.DefaultEditor)this.scaleSpinner.getSpinner().getEditor()).getTextField().addFocusListener(FOCUS_LISTENER);
        JLabel lblViewPoint = new JLabel("View point");
        JLabel lblViewPointHelp = new JLabel(ICON_HELP);
        lblViewPointHelp.setToolTipText("The view point angle (in degrees).");
        this.rbDefaultViewPoint = new JRadioButton("Default", true);
        this.rbActualViewPoint = new JRadioButton("Actual");
        this.rbCustomViewPoint = new JRadioButton("CUSTOM");
        ButtonGroup bgViewPoint = new ButtonGroup();
        bgViewPoint.add(this.rbDefaultViewPoint);
        bgViewPoint.add(this.rbActualViewPoint);
        bgViewPoint.add(this.rbCustomViewPoint);
        ActionListener viewPointActionListener = l -> this.viewPointModeChanged();
        this.rbDefaultViewPoint.addActionListener(viewPointActionListener);
        this.rbActualViewPoint.addActionListener(viewPointActionListener);
        this.rbCustomViewPoint.addActionListener(viewPointActionListener);
        JPanel viewPointButtonsPanel = new JPanel(new FlowLayout());
        viewPointButtonsPanel.add(this.rbDefaultViewPoint);
        viewPointButtonsPanel.add(Box.createHorizontalGlue());
        viewPointButtonsPanel.add(this.rbActualViewPoint);
        viewPointButtonsPanel.add(Box.createHorizontalGlue());
        viewPointButtonsPanel.add(this.rbCustomViewPoint);
        JLabel lblViewPointEditor = new JLabel();
        JLabel lblViewPointEditorHelp = new JLabel();
        this.viewPointEditorPanel = new ViewPointEditorPanel(ElementDataViewConfiguration.getDefault2DAngle(), this.is3DEnabled());
        this.viewPointEditorPanel.addFocusListener(FOCUS_LISTENER);
        this.viewPointEditorPanel.setBorder(null);
        JLabel lblShowLegend = new JLabel("Show color bar legend");
        JLabel lblShowLegendHelp = new JLabel(ICON_HELP);
        lblShowLegendHelp.setToolTipText("Check if color bar legend must be shown.");
        this.showColorBarLegendCB = new JCheckBox();
        JLabel lblShowAxes = new JLabel("Show axes");
        JLabel lblShowAxesHelp = new JLabel(ICON_HELP);
        lblShowAxesHelp.setToolTipText("Check if image axes must be shown.");
        this.showAxesCB = new JCheckBox();
        JLabel lblShowTickLines = new JLabel("Show tick lines");
        JLabel lblShowTickLinesHelp = new JLabel(ICON_HELP);
        lblShowTickLinesHelp.setToolTipText("Check if image tick lines axes must be shown.");
        this.showTickLinesCB = new JCheckBox();
        JLabel lblFileName = new JLabel("File");
        JLabel lblFileNameHelp = new JLabel(ICON_HELP);
        if (this.isAcceptDirectoriesOnly()) {
            lblFileNameHelp.setToolTipText("The selected directory to export the images.");
        } else {
            lblFileNameHelp.setToolTipText("The selected file to export the image.");
        }
        this.fileName = new JTextField("", 20);
        this.fileName.setEditable(false);
        this.fileName.addMouseListener(this.getBrowseListener());
        JButton browseButton = new JButton(ICON_BROWSE);
        browseButton.setToolTipText("Opens a file chooser to select a file");
        browseButton.addMouseListener(this.getBrowseListener());
        JPanel fileChooserPanel = new JPanel(new BorderLayout());
        fileChooserPanel.add((Component)this.fileName, "Center");
        fileChooserPanel.add((Component)browseButton, "East");
        JLabel lblRangeMode = new JLabel("Range mode");
        JLabel lblRangeModeHelp = new JLabel(ICON_HELP);
        lblRangeModeHelp.setToolTipText("The color mapper range mode.");
        this.rangeModeCB = new JComboBox();
        this.rangeModeCB.setModel(new DefaultComboBoxModel<ElementDataViewConfiguration.ColorMapRangeMode>(ElementDataViewConfiguration.ColorMapRangeMode.values()));
        this.rangeModeCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ExportAllAsPngDialog.this.colorMapRangeModeChanged();
                }
            }
        });
        JLabel lblRange = new JLabel("Range");
        JLabel lblRangeHelp = new JLabel(ICON_HELP);
        lblRangeHelp.setToolTipText("The color mapper range.");
        JPanel rangePanel = this.getRangePanel();
        JLabel lblImageSize = new JLabel("Size");
        JLabel lblImageSizeHelp = new JLabel(ICON_HELP);
        lblImageSizeHelp.setToolTipText("The size in px of the image.");
        JPanel imageSizePanel = this.getImageSizePanel();
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(lblFileName, GroupLayout.Alignment.TRAILING).addComponent(lblInterpolationLevel, GroupLayout.Alignment.TRAILING).addComponent(lblColorMap, GroupLayout.Alignment.TRAILING).addComponent(lblViewerMode, GroupLayout.Alignment.TRAILING).addComponent(lblScale, GroupLayout.Alignment.TRAILING).addComponent(lblViewPoint, GroupLayout.Alignment.TRAILING).addComponent(lblViewPointEditor, GroupLayout.Alignment.TRAILING).addComponent(lblShowLegend, GroupLayout.Alignment.TRAILING).addComponent(lblShowAxes, GroupLayout.Alignment.TRAILING).addComponent(lblShowTickLines, GroupLayout.Alignment.TRAILING).addComponent(lblRangeMode, GroupLayout.Alignment.TRAILING).addComponent(lblRange, GroupLayout.Alignment.TRAILING).addComponent(lblImageSize, GroupLayout.Alignment.TRAILING)).addGroup(groupLayout.createParallelGroup().addComponent(fileChooserPanel).addComponent(this.interpolationLevelCB).addComponent(this.colorMapCB).addComponent(this.viewerModeCB).addComponent(this.scaleSpinner.getSpinner()).addComponent(viewPointButtonsPanel).addComponent(this.viewPointEditorPanel).addComponent(this.showColorBarLegendCB).addComponent(this.showAxesCB).addComponent(this.showTickLinesCB).addComponent(this.rangeModeCB).addComponent(rangePanel).addComponent(imageSizePanel)).addGroup(groupLayout.createParallelGroup().addComponent(lblFileNameHelp).addComponent(lblInterpolationLevelHelp).addComponent(lblColorMapHelp).addComponent(lblViewerModeHelp).addComponent(lblScaleHelp).addComponent(lblViewPointHelp).addComponent(lblViewPointEditorHelp).addComponent(lblShowLegendHelp).addComponent(lblShowAxesHelp).addComponent(lblShowTickLinesHelp).addComponent(lblRangeModeHelp).addComponent(lblRangeHelp).addComponent(lblImageSizeHelp)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(lblFileName, GroupLayout.Alignment.CENTER).addComponent(fileChooserPanel, GroupLayout.Alignment.CENTER).addComponent(lblFileNameHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblInterpolationLevel, GroupLayout.Alignment.CENTER).addComponent(this.interpolationLevelCB, GroupLayout.Alignment.CENTER).addComponent(lblInterpolationLevelHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblColorMap, GroupLayout.Alignment.CENTER).addComponent(this.colorMapCB, GroupLayout.Alignment.CENTER).addComponent(lblColorMapHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblViewerMode, GroupLayout.Alignment.CENTER).addComponent(this.viewerModeCB, GroupLayout.Alignment.CENTER).addComponent(lblViewerModeHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblScale, GroupLayout.Alignment.CENTER).addComponent(this.scaleSpinner.getSpinner(), GroupLayout.Alignment.CENTER).addComponent(lblScaleHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblViewPoint, GroupLayout.Alignment.CENTER).addComponent(viewPointButtonsPanel, GroupLayout.Alignment.CENTER).addComponent(lblViewPointHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblViewPointEditor, GroupLayout.Alignment.CENTER).addComponent(this.viewPointEditorPanel, GroupLayout.Alignment.CENTER).addComponent(lblViewPointEditorHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblShowLegend, GroupLayout.Alignment.CENTER).addComponent(this.showColorBarLegendCB, GroupLayout.Alignment.CENTER).addComponent(lblShowLegendHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblShowAxes, GroupLayout.Alignment.CENTER).addComponent(this.showAxesCB, GroupLayout.Alignment.CENTER).addComponent(lblShowAxesHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblShowTickLines, GroupLayout.Alignment.CENTER).addComponent(this.showTickLinesCB, GroupLayout.Alignment.CENTER).addComponent(lblShowTickLinesHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblRangeMode, GroupLayout.Alignment.CENTER).addComponent(this.rangeModeCB, GroupLayout.Alignment.CENTER).addComponent(lblRangeModeHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblRange, GroupLayout.Alignment.CENTER).addComponent(rangePanel, GroupLayout.Alignment.CENTER).addComponent(lblRangeHelp, GroupLayout.Alignment.CENTER)).addGroup(groupLayout.createParallelGroup().addComponent(lblImageSize, GroupLayout.Alignment.CENTER).addComponent(imageSizePanel, GroupLayout.Alignment.CENTER).addComponent(lblImageSizeHelp, GroupLayout.Alignment.CENTER)));
        JPanel toret = new JPanel(new BorderLayout());
        toret.add((Component)optionsPane, "North");
        return toret;
    }

    private void positionModeChanged() {
        this.scaleSpinner.setEnabled(this.is3DEnabled());
        this.viewPointEditorPanel.set3DEnabled(this.is3DEnabled());
        this.updateViewerPointEditor();
    }

    private void updateViewerPointEditor() {
        if (this.rbDefaultViewPoint.isSelected() || this.rbActualViewPoint.isSelected()) {
            this.viewPointEditorPanel.setViewPoint(this.getSelectedViewPoint());
        }
    }

    public final boolean is3DEnabled() {
        return this.viewerModeCB.isSelected();
    }

    private void viewPointModeChanged() {
        boolean editable = this.rbCustomViewPoint.isSelected();
        this.viewPointEditorPanel.setEditable(editable);
        this.updateViewerPointEditor();
    }

    protected void colorMapRangeModeChanged() {
        boolean customRangeMode;
        ElementDataViewConfiguration.ColorMapRangeMode selected = this.getSelectedRangeMode();
        boolean bl = customRangeMode = !selected.equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.ELEMENT) && !selected.equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.DATASET);
        if (!customRangeMode) {
            this.updateRangeFields();
        }
        this.setColorMapRangeControlsEnabled(customRangeMode);
    }

    private void updateRangeFields() {
        if (this.getSelectedRangeMode().equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.DATASET)) {
            this.minRangeValue.setValue(Float.valueOf(this.datasetRange.getMin()));
            this.maxRangeValue.setValue(Float.valueOf(this.datasetRange.getMax()));
        }
    }

    private ElementDataViewConfiguration.ColorMapRangeMode getSelectedRangeMode() {
        return (ElementDataViewConfiguration.ColorMapRangeMode)((Object)this.rangeModeCB.getSelectedItem());
    }

    private void setColorMapRangeControlsEnabled(boolean enabled) {
        this.minRangeValue.setEnabled(enabled);
        this.maxRangeValue.setEnabled(enabled);
    }

    private JPanel getImageSizePanel() {
        JPanel imageSizePanel = new JPanel();
        imageSizePanel.setLayout(new GridLayout(1, 4));
        NumberFormat format = NumberFormat.getInstance();
        format.setGroupingUsed(false);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        formatter.setCommitsOnValidEdit(true);
        this.widthTF = new JFormattedTextField(formatter);
        this.widthTF.setValue(1200);
        this.addFocusListener(this.widthTF);
        this.heightTF = new JFormattedTextField(formatter);
        this.heightTF.setValue(1000);
        this.addFocusListener(this.heightTF);
        imageSizePanel.add(new JLabel(" Width:"));
        imageSizePanel.add(this.widthTF);
        imageSizePanel.add(new JLabel(" Height:"));
        imageSizePanel.add(this.heightTF);
        return imageSizePanel;
    }

    private JPanel getRangePanel() {
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new GridLayout(1, 4));
        this.minRangeValue = new FloatTextField(0.0f);
        this.maxRangeValue = new FloatTextField(1.0f);
        this.addFocusListener(this.minRangeValue);
        this.addFocusListener(this.maxRangeValue);
        this.setColorMapRangeControlsEnabled(false);
        PropertyChangeListener listener = e -> this.checkRangeValues();
        this.minRangeValue.addPropertyChangeListener("value", listener);
        this.maxRangeValue.addPropertyChangeListener("value", listener);
        rangePanel.add(new JLabel(" Min.:"));
        rangePanel.add(this.minRangeValue);
        rangePanel.add(new JLabel(" Max.:"));
        rangePanel.add(this.maxRangeValue);
        return rangePanel;
    }

    private void checkRangeValues() {
        boolean validRange = this.isRangeValuesValid();
        this.setRangeTextFieldColor(validRange);
        this.checkEnabled();
    }

    private void setRangeTextFieldColor(boolean validValues) {
        Color backgroundColor = this.getTextFieldBackgroundColor(validValues);
        this.minRangeValue.setBackground(backgroundColor);
        this.maxRangeValue.setBackground(backgroundColor);
    }

    private Color getTextFieldBackgroundColor(boolean validValues) {
        return validValues ? RangeInputDialog.COLOR_VALID_INPUT : RangeInputDialog.COLOR_INVALID_INPUT;
    }

    private boolean isRangeValuesValid() {
        return this.getMinRangeValue() < this.getMaxRangeValue();
    }

    public float getMinRangeValue() {
        return ((Float)this.minRangeValue.getValue()).floatValue();
    }

    public float getMaxRangeValue() {
        return ((Float)this.maxRangeValue.getValue()).floatValue();
    }

    @Override
    protected void setSelectedFile(File newFile) {
        this.selectedFile = newFile;
        if (!this.isAcceptDirectoriesOnly() && !newFile.getName().toLowerCase().endsWith(".png")) {
            this.selectedFile = new File(newFile.getAbsolutePath() + ".png");
        }
        this.fileName.setText(this.selectedFile.getAbsolutePath());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public File getSelectedFile() {
        return this.selectedFile;
    }

    @Override
    protected void checkEnabled() {
        this.okButton.setEnabled(this.getSelectedFile() != null && this.checkImageSize() && this.isRangeValuesValid());
    }

    private boolean checkImageSize() {
        return this.getSelectedHeight() > 0 && this.getSelectedWidth() > 0;
    }

    @Override
    public void setVisible(boolean b) {
        this.interpolationLevelCB.setSelectedItem(Quality.Intermediate);
        super.setVisible(b);
    }

    public int getSelectedWidth() {
        return (Integer)this.widthTF.getValue();
    }

    public int getSelectedHeight() {
        return (Integer)this.heightTF.getValue();
    }

    public int getSelectedInterpolationLevel() {
        return ((ElementDataViewConfiguration.InterpolationLevel)((Object)this.interpolationLevelCB.getSelectedItem())).getLevel();
    }

    public IColorMap getSelectedColorMap() {
        return ((ElementDataViewConfiguration.ColorMap)((Object)this.colorMapCB.getSelectedItem())).getColorMap();
    }

    public Coord2d getSelectedViewPoint() {
        if (this.rbDefaultViewPoint.isSelected()) {
            if (this.is3DEnabled()) {
                return ElementDataViewConfiguration.getDefault3DAngle();
            }
            return ElementDataViewConfiguration.getDefault2DAngle();
        }
        if (this.rbActualViewPoint.isSelected()) {
            return this.currentViewPoint;
        }
        if (this.rbCustomViewPoint.isSelected()) {
            return this.viewPointEditorPanel.getViewPoint();
        }
        throw new IllegalStateException();
    }

    public boolean isShowColorBarLegend() {
        return this.showColorBarLegendCB.isSelected();
    }

    public boolean isShowAxes() {
        return this.showAxesCB.isSelected();
    }

    public boolean isShowTickLines() {
        return this.showTickLinesCB.isSelected();
    }

    public Optional<Range> getSelectedColorMapRange() {
        if (this.getColorMapRangeMode().equals((Object)ElementDataViewConfiguration.ColorMapRangeMode.ELEMENT)) {
            return Optional.empty();
        }
        return Optional.of(this.getColorMapRange());
    }

    private ElementDataViewConfiguration.ColorMapRangeMode getColorMapRangeMode() {
        return (ElementDataViewConfiguration.ColorMapRangeMode)((Object)this.rangeModeCB.getSelectedItem());
    }

    private Range getColorMapRange() {
        return new Range(this.getMinRangeValue(), this.getMaxRangeValue());
    }

    public void setInterpolationLevel(ElementDataViewConfiguration.InterpolationLevel interpolationLevel) {
        this.interpolationLevelCB.setSelectedItem((Object)interpolationLevel);
    }

    public void setColorMap(ElementDataViewConfiguration.ColorMap colorMap) {
        this.colorMapCB.setSelectedItem((Object)colorMap);
    }

    public void setColorMapRangeMode(ElementDataViewConfiguration.ColorMapRangeMode mode) {
        this.rangeModeCB.setSelectedItem((Object)mode);
    }

    public void setColorMapRange(Range range) {
        this.setRangeValues(range);
    }

    public void set3DEnabled(boolean enabled) {
        this.viewerModeCB.setSelected(enabled);
        this.positionModeChanged();
    }

    public void setShowColorBarLegend(boolean show) {
        this.showColorBarLegendCB.setSelected(show);
    }

    public void setShowAxes(boolean show) {
        this.showAxesCB.setSelected(show);
    }

    public void setShowTickLines(boolean show) {
        this.showTickLinesCB.setSelected(show);
    }

    public void setDatasetRange(Range range) {
        this.datasetRange = range;
        this.setRangeValues(range);
    }

    public void setCurrentViewPoint(Coord2d currentViewPoint) {
        this.currentViewPoint = currentViewPoint;
        this.rbActualViewPoint.setSelected(true);
        this.updateViewerPointEditor();
    }

    private void setRangeValues(Range range) {
        this.minRangeValue.setValue(Float.valueOf(range.getMin()));
        this.maxRangeValue.setValue(Float.valueOf(range.getMax()));
    }

    public void setScale(double scale) {
        this.scaleSpinner.setScale(new Double(scale));
    }

    public double getSelectedScale() {
        return this.is3DEnabled() ? this.scaleSpinner.getScale().doubleValue() : ElementDataViewConfiguration.DEFAULT_2D_SCALE.doubleValue();
    }

    @Override
    protected boolean isAcceptDirectoriesOnly() {
        return true;
    }
}

