/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.ui.editors;

import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jzy3d.chart.Chart;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.lights.Light;
import org.jzy3d.ui.editors.ColorEditor;
import org.jzy3d.ui.editors.Coord3dEditor;

public class LightEditor
extends JPanel {
    protected ColorEditor ambiantColorControl;
    protected ColorEditor diffuseColorControl;
    protected ColorEditor specularColorControl;
    protected Coord3dEditor positionControl;
    protected Chart chart;
    protected Light light;
    private static final long serialVersionUID = 4903947408608903517L;

    public LightEditor(Chart chart) {
        this.chart = chart;
        BoundingBox3d box = new BoundingBox3d(chart.getView().getBounds());
        box.scale(new Coord3d(3.0f, 3.0f, 3.0f));
        box.getXRange().createEnlarge(2.0);
        this.ambiantColorControl = new ColorEditor("Ambiant");
        this.diffuseColorControl = new ColorEditor("Diffuse");
        this.specularColorControl = new ColorEditor("Specular");
        this.positionControl = new Coord3dEditor("Position", box.getXRange().createEnlarge(2.0), box.getYRange().createEnlarge(2.0), box.getZRange().createEnlarge(2.0));
        this.setLayout(new GridLayout(4, 1));
        this.add(this.ambiantColorControl);
        this.add(this.diffuseColorControl);
        this.add(this.specularColorControl);
        this.add(this.positionControl);
    }

    protected void registerColorControl(ColorEditor colorControl, final Color color) {
        final JSlider slider0 = colorControl.getSlider(0);
        slider0.setValue((int)color.r * slider0.getMaximum());
        slider0.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                color.r = LightEditor.this.getPercent(slider0);
                LightEditor.this.chart.render();
            }
        });
        final JSlider slider1 = colorControl.getSlider(1);
        slider1.setValue((int)color.g * slider1.getMaximum());
        slider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                color.g = LightEditor.this.getPercent(slider1);
                LightEditor.this.chart.render();
            }
        });
        final JSlider slider2 = colorControl.getSlider(2);
        slider2.setValue((int)color.b * slider2.getMaximum());
        slider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                color.b = LightEditor.this.getPercent(slider2);
                LightEditor.this.chart.render();
            }
        });
    }

    protected void registerCoord3dControl(Coord3dEditor colorControl, final Coord3d coord) {
        final JSlider slider0 = colorControl.getSlider(0);
        slider0.setValue((int)coord.x);
        slider0.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                coord.x = slider0.getValue();
                LightEditor.this.light.setPosition(coord);
                LightEditor.this.chart.render();
            }
        });
        final JSlider slider1 = colorControl.getSlider(1);
        slider1.setValue((int)coord.y);
        slider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                coord.y = slider1.getValue();
                LightEditor.this.light.setPosition(coord);
                LightEditor.this.chart.render();
            }
        });
        final JSlider slider2 = colorControl.getSlider(2);
        slider2.setValue((int)coord.z);
        slider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                coord.z = slider2.getValue();
                LightEditor.this.light.setPosition(coord);
                LightEditor.this.chart.render();
            }
        });
    }

    protected float getPercent(JSlider slider) {
        return (float)slider.getValue() / (float)slider.getMaximum();
    }

    public void setTarget(Light light) {
        this.light = light;
        this.registerColorControl(this.ambiantColorControl, light.getAmbiantColor());
        this.registerColorControl(this.diffuseColorControl, light.getDiffuseColor());
        this.registerColorControl(this.specularColorControl, light.getSpecularColor());
        this.registerCoord3dControl(this.positionControl, light.getPosition());
    }
}

