/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jzy3d.chart.Chart;
import org.jzy3d.plot3d.rendering.canvas.OffscreenCanvas;
import org.jzy3d.plot3d.rendering.view.AWTRenderer3d;
import org.jzy3d.ui.LookAndFeel;
import org.jzy3d.ui.views.ImagePanel;

public class MultiChartPanel
extends JPanel {
    private static final long serialVersionUID = 7519209038396190502L;
    protected JTextField tf;
    protected JTextArea textArea;
    protected JScrollPane textPane;
    protected int lineHeightPX = 300;
    protected int columnWidthPX = 500;
    protected boolean growCol = true;
    protected boolean growLine = false;
    protected boolean vertical;
    public static String WT = "awt";
    private int nComponent = 0;

    public static void ui(String[] headers, Chart[][] charts) throws IOException {
        MultiChartPanel monitorPanel = new MultiChartPanel(charts, headers, null, false, 100, 100, false, false);
        monitorPanel.ui();
    }

    public static void ui(String[] headers, Chart[][] charts, int width, int height) throws IOException {
        MultiChartPanel monitorPanel = new MultiChartPanel(charts, headers, null, false, width, height, false, false);
        monitorPanel.ui();
    }

    public MultiChartPanel(List<Chart> charts) {
        this(charts, true);
    }

    public MultiChartPanel(List<Chart> charts, boolean vertical) {
        this(charts, vertical, 500, 300);
    }

    public MultiChartPanel(List<Chart> charts, boolean vertical, int width, int height) {
        this(charts, vertical, width, height, true, false);
    }

    public MultiChartPanel(List<Chart> charts, boolean vertical, int width, int height, boolean growCol, boolean growLine) {
        LookAndFeel.apply();
        this.vertical = vertical;
        this.lineHeightPX = height;
        this.columnWidthPX = width;
        this.growCol = growCol;
        this.growLine = growLine;
        String lines = this.lineInstruction();
        String columns = this.columnInstruction();
        this.setLayout((LayoutManager)new MigLayout(this.insets0(), columns, lines));
        for (Chart c : charts) {
            this.addChart(c);
        }
    }

    public MultiChartPanel(Chart[][] charts, boolean vertical, int width, int height, boolean growCol, boolean growLine) throws IOException {
        this(charts, null, null, vertical, width, height, growCol, growLine);
    }

    public MultiChartPanel(Chart[][] charts, String[] header, String[] row, boolean vertical, int width, int height, boolean growCol, boolean growLine) throws IOException {
        int i;
        LookAndFeel.apply();
        this.vertical = vertical;
        this.lineHeightPX = height;
        this.columnWidthPX = width;
        this.growCol = growCol;
        this.growLine = growLine;
        boolean hasHeader = header != null;
        String lines = null;
        lines = growLine ? (hasHeader ? "[20px][" + this.lineHeightPX + "px,grow]" : "[" + this.lineHeightPX + "px,grow]") : (hasHeader ? "[20px][" + this.lineHeightPX + "px]" : "[" + this.lineHeightPX + "px]");
        String columns = this.columnInstruction();
        this.setLayout((LayoutManager)new MigLayout(this.insets0(), columns, lines));
        if (hasHeader) {
            for (i = 0; i < header.length; ++i) {
                this.addPanelAt(new JLabel(header[i]), 0, i);
            }
        }
        for (i = 0; i < charts.length; ++i) {
            for (int j = 0; j < charts[i].length; ++j) {
                if (charts[i][j] == null) continue;
                int r = hasHeader ? i + 1 : i;
                int c = j;
                this.addChartAt(charts[i][j], r, c);
            }
        }
    }

    public String insetsDefault() {
        return "";
    }

    public String insets0() {
        return "insets 0 0 0 0";
    }

    public String lineInstruction() {
        if (this.growLine) {
            return "[" + this.lineHeightPX + "px,grow]";
        }
        return "[" + this.lineHeightPX + "px]";
    }

    public String columnInstruction() {
        if (this.growCol) {
            return "[" + this.columnWidthPX + "px,grow]";
        }
        return "[" + this.columnWidthPX + "px]";
    }

    public JPanel addChart(Chart chart) {
        Component component = this.getChartAsComponent(chart);
        return this.addPanel(component);
    }

    public JPanel addChartAt(Chart chart, int nlin, int ncol) {
        Component component = chart.getCanvas() instanceof OffscreenCanvas ? this.getChartScreenshotAsComponent(chart) : this.getChartAsComponent(chart);
        return this.addPanelAt(component, nlin, ncol);
    }

    public JPanel getChartScreenshotAsComponent(Chart chart) {
        chart.screenshot();
        AWTRenderer3d renderer = (AWTRenderer3d)chart.getCanvas().getRenderer();
        BufferedImage i = renderer.getLastScreenshotImage();
        ImagePanel component = new ImagePanel(i);
        return component;
    }

    public Component getChartAsComponent(Chart chart) {
        return (Component)((Object)chart.getCanvas());
    }

    public JPanel addPanel(Component panel) {
        if (this.vertical) {
            int ncol = 0;
            int nlin = this.nComponent++;
            return this.addPanelAt(panel, nlin, ncol);
        }
        int nlin = 0;
        int ncol = this.nComponent++;
        return this.addPanelAt(panel, nlin, ncol);
    }

    public JPanel addPanelAt(Component panel, int nlin, int ncol) {
        JPanel chartPanel = new JPanel(new BorderLayout());
        Border b = BorderFactory.createLineBorder(Color.black);
        chartPanel.setBorder(b);
        chartPanel.add(panel, "Center");
        this.add((Component)chartPanel, "cell " + ncol + " " + nlin + ", grow");
        return chartPanel;
    }

    public JFrame ui() {
        JScrollPane pane = new JScrollPane(this, 22, 32);
        JPanel parent = new JPanel();
        parent.add(pane);
        return MultiChartPanel.frame(parent);
    }

    public JFrame frame() {
        return MultiChartPanel.frame(this);
    }

    public static JFrame frame(JPanel panel) {
        JFrame frame = new JFrame();
        MultiChartPanel.windowExitListener(frame);
        frame.add(panel);
        frame.pack();
        frame.show();
        frame.setVisible(true);
        return frame;
    }

    public static void windowExitListener(final JFrame frame) {
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.dispose();
                System.exit(0);
            }
        });
    }
}

