/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.transform;

import com.jogamp.opengl.GL;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.Transformer;

public class Rotate
implements Transformer {
    private float angle;
    private Coord3d rotate;

    public Rotate(float angle, Coord3d rotate) {
        this.angle = angle;
        this.rotate = rotate;
    }

    public Rotate(double angle, Coord3d rotate) {
        this.angle = (float)angle;
        this.rotate = rotate;
    }

    @Override
    public void execute(GL gl) {
        if (gl.isGL2()) {
            gl.getGL2().glRotatef(this.angle, this.rotate.x, this.rotate.y, this.rotate.z);
        } else {
            GLES2CompatUtils.glRotatef(this.angle, this.rotate.x, this.rotate.y, this.rotate.z);
        }
    }

    @Override
    public Coord3d compute(Coord3d input) {
        return input.rotate(this.angle, this.rotate);
    }

    public String toString() {
        return "(Rotate)a=" + this.angle + " " + this.rotate;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public Coord3d getRotate() {
        return this.rotate;
    }

    public void setRotate(Coord3d rotate) {
        this.rotate = rotate;
    }
}

