/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.renderers.jogl;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jzy3d.plot3d.text.renderers.jogl.ITextStyle;

public class ShadowedTextStyle
implements ITextStyle {
    private float gradientSize;
    private int dropShadowDepth;
    private Color color1;
    private Color color2;
    protected static final Color DROP_SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);

    public ShadowedTextStyle(float gradientSize, int dropShadowDepth, Color color1, Color color2) {
        this.gradientSize = gradientSize;
        this.dropShadowDepth = dropShadowDepth;
        this.color1 = color1;
        this.color2 = color2;
    }

    public boolean intensityOnly() {
        return false;
    }

    public Rectangle2D getBounds(CharSequence str, Font font, FontRenderContext frc) {
        return this.getBounds(str.toString(), font, frc);
    }

    public Rectangle2D getBounds(String str, Font font, FontRenderContext frc) {
        return this.getBounds(font.createGlyphVector(frc, str), frc);
    }

    public Rectangle2D getBounds(GlyphVector gv, FontRenderContext frc) {
        Rectangle stringBounds = gv.getPixelBounds(frc, 0.0f, 0.0f);
        return new Rectangle2D.Double(((RectangularShape)stringBounds).getX(), ((RectangularShape)stringBounds).getY(), ((RectangularShape)stringBounds).getWidth() + (double)this.dropShadowDepth, ((RectangularShape)stringBounds).getHeight() + (double)this.dropShadowDepth);
    }

    public void drawGlyphVector(Graphics2D graphics, GlyphVector str, int x, int y) {
        graphics.setColor(DROP_SHADOW_COLOR);
        graphics.drawGlyphVector(str, x + this.dropShadowDepth, y + this.dropShadowDepth);
        graphics.setColor(Color.WHITE);
        graphics.setPaint(new GradientPaint(x, y, this.color1, x, (float)y + this.gradientSize / 2.0f, this.color2, true));
        graphics.drawGlyphVector(str, x, y);
    }

    public void draw(Graphics2D graphics, String str, int x, int y) {
        graphics.setColor(DROP_SHADOW_COLOR);
        graphics.drawString(str, x + this.dropShadowDepth, y + this.dropShadowDepth);
        graphics.setColor(Color.WHITE);
        graphics.setPaint(new GradientPaint(x, y, this.color1, x, (float)y + this.gradientSize / 2.0f, this.color2, true));
        graphics.drawString(str, x, y);
    }
}

