/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view.annotation;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.AbstractGeometry;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.ordering.AbstractOrderingStrategy;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;

public class CameraDistanceAnnotation
extends Point {
    protected View view;
    protected ITextRenderer txt = new TextBitmapRenderer();

    public CameraDistanceAnnotation(View view, Color color) {
        this.view = view;
        this.setColor(color);
        this.setWidth(5.0f);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.computeCameraPosition();
        this.doTransform(gl, glu, cam);
        this.doDrawCamera(gl, glu, cam);
        Halign h = Halign.RIGHT;
        Valign v = Valign.CENTER;
        Coord2d screenOffset = new Coord2d(10.0f, 0.0f);
        Color colorBary = Color.BLACK;
        Color colorPt = Color.GRAY.clone();
        colorPt.alphaSelf(0.5f);
        Graph graph = this.view.getScene().getGraph();
        AbstractOrderingStrategy strat = graph.getStrategy();
        for (AbstractDrawable drawables : graph.getDecomposition()) {
            double d = strat.score(drawables);
            this.txt.drawText(gl, glu, this.view.getCamera(), Utils.num2str(d, 4), drawables.getBarycentre(), h, v, colorBary, screenOffset);
            if (!(drawables instanceof AbstractGeometry)) continue;
            Polygon p = (Polygon)drawables;
            for (Point pt : p.getPoints()) {
                d = strat.score(pt);
                this.txt.drawText(gl, glu, this.view.getCamera(), Utils.num2str(d, 4), pt.getCoord(), h, v, colorPt, screenOffset);
            }
        }
    }

    public void computeCameraPosition() {
        Coord3d scaling = this.view.getLastViewScaling().clone();
        this.xyz = this.view.getCamera().getEye().clone();
        this.xyz = this.xyz.div(scaling);
    }

    public void doDrawCamera(GL gl, GLU glu, Camera cam) {
        if (gl.isGL2()) {
            gl.getGL2().glPointSize(this.width);
            gl.getGL2().glBegin(0);
            gl.getGL2().glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
            gl.getGL2().glVertex3f(this.xyz.x, this.xyz.y, this.xyz.z);
            gl.getGL2().glEnd();
        } else {
            GLES2CompatUtils.glPointSize(this.width);
            GLES2CompatUtils.glBegin(0);
            GLES2CompatUtils.glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
            GLES2CompatUtils.glVertex3f(this.xyz.x, this.xyz.y, this.xyz.z);
            GLES2CompatUtils.glEnd();
        }
    }
}

