/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Grid;
import org.jzy3d.maths.PolygonArray;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.AbstractViewportManager;
import org.jzy3d.plot3d.rendering.view.ViewportConfiguration;
import org.jzy3d.plot3d.rendering.view.ViewportMode;
import org.jzy3d.plot3d.rendering.view.modes.CameraMode;
import org.jzy3d.plot3d.transform.Transform;

public class Camera
extends AbstractViewportManager {
    static Logger LOGGER = Logger.getLogger(Camera.class);
    public static final Coord3d DEFAULT_VIEW = new Coord3d(1.0471975511965976, 0.6283185307179586, 500.0);
    public static final boolean DEFAULT_CAMERA_DISTANCE_MODE = true;
    boolean failOnException = false;
    Color camColor = Color.BLACK;
    int camWidth = 3;
    protected Coord3d eye;
    protected Coord3d target;
    protected Coord3d up;
    protected float radius;
    protected float near;
    protected float far;
    protected boolean useSquaredDistance = true;

    public Camera(Coord3d target) {
        this.setTarget(target);
        this.setEye(DEFAULT_VIEW.cartesian().add(target));
        this.setUp(new Coord3d(0.0f, 0.0f, 1.0f));
        this.setViewPort(1, 1, 0.0f, 1.0f);
        this.setRenderingDepth(0.5f, 100000.0f);
        this.setRenderingSphereRadius(1.0f);
        this.setViewportMode(ViewportMode.RECTANGLE_NO_STRETCH);
    }

    public void setEye(Coord3d eye) {
        this.eye = eye;
    }

    public Coord3d getEye() {
        return this.eye;
    }

    public void setTarget(Coord3d target) {
        this.target = target;
    }

    public Coord3d getTarget() {
        return this.target;
    }

    public void setUp(Coord3d up) {
        this.up = up;
    }

    public Coord3d getUp() {
        return this.up;
    }

    public boolean isTiltUp() {
        return this.eye.z < this.target.z;
    }

    public void setRenderingSphereRadius(float radius) {
        this.radius = radius;
        this.near = (float)this.eye.distance(this.target) - radius * 2.0f;
        this.far = (float)this.eye.distance(this.target) + radius * 2.0f;
    }

    public float getRenderingSphereRadius() {
        return this.radius;
    }

    public void setRenderingDepth(float near, float far) {
        this.near = near;
        this.far = far;
    }

    public float getNear() {
        return this.near;
    }

    public float getFar() {
        return this.far;
    }

    public boolean side(Coord3d point) {
        return 0.0f < (point.x - this.target.x) * (this.eye.y - this.target.y) - (point.y - this.target.y) * (this.eye.x - this.target.x);
    }

    public Coord3d screenToModel(GL gl, GLU glu, Coord3d screen) {
        float[] worldcoord;
        float[] projection;
        int[] viewport = this.getViewPortAsInt(gl);
        float[] modelView = this.getModelViewAsFloat(gl);
        boolean s = glu.gluUnProject(screen.x, screen.y, screen.z, modelView, 0, projection = this.getProjectionAsFloat(gl), 0, viewport, 0, worldcoord = new float[3], 0);
        if (!s) {
            this.failedProjection("Could not retrieve screen coordinates in model.");
        }
        return new Coord3d(worldcoord[0], worldcoord[1], worldcoord[2]);
    }

    public Coord3d modelToScreen(GL gl, GLU glu, Coord3d point) {
        int[] viewport = this.getViewPortAsInt(gl);
        float[] screencoord = new float[3];
        if (!glu.gluProject(point.x, point.y, point.z, this.getModelViewAsFloat(gl), 0, this.getProjectionAsFloat(gl), 0, viewport, 0, screencoord, 0)) {
            this.failedProjection("Could not retrieve model coordinates in screen for " + point);
        }
        return new Coord3d(screencoord[0], screencoord[1], screencoord[2]);
    }

    public Coord3d[] modelToScreen(GL gl, GLU glu, Coord3d[] points) {
        int[] viewport = this.getViewPortAsInt(gl);
        float[] screencoord = new float[3];
        Coord3d[] projection = new Coord3d[points.length];
        for (int i = 0; i < points.length; ++i) {
            if (!glu.gluProject(points[i].x, points[i].y, points[i].z, this.getModelViewAsFloat(gl), 0, this.getProjectionAsFloat(gl), 0, viewport, 0, screencoord, 0)) {
                this.failedProjection("Could not retrieve model coordinates in screen for " + points[i]);
            }
            projection[i] = new Coord3d(screencoord[0], screencoord[1], screencoord[2]);
        }
        return projection;
    }

    public Coord3d[][] modelToScreen(GL gl, GLU glu, Coord3d[][] points) {
        int[] viewport = this.getViewPortAsInt(gl);
        float[] screencoord = new float[3];
        Coord3d[][] projection = new Coord3d[points.length][points[0].length];
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[i].length; ++j) {
                if (!glu.gluProject(points[i][j].x, points[i][j].y, points[i][j].z, this.getModelViewAsFloat(gl), 0, this.getProjectionAsFloat(gl), 0, viewport, 0, screencoord, 0)) {
                    this.failedProjection("Could not retrieve model coordinates in screen for " + points[i][j]);
                }
                projection[i][j] = new Coord3d(screencoord[0], screencoord[1], screencoord[2]);
            }
        }
        return projection;
    }

    public List<Coord3d> modelToScreen(GL gl, GLU glu, List<Coord3d> points) {
        int[] viewport = this.getViewPortAsInt(gl);
        float[] screencoord = new float[3];
        Vector<Coord3d> projection = new Vector<Coord3d>();
        for (Coord3d point : points) {
            if (!glu.gluProject(point.x, point.y, point.z, this.getModelViewAsFloat(gl), 0, this.getProjectionAsFloat(gl), 0, viewport, 0, screencoord, 0)) {
                this.failedProjection("Could not retrieve model coordinates in screen for " + point);
            }
            projection.add(new Coord3d(screencoord[0], screencoord[1], screencoord[2]));
        }
        return projection;
    }

    public ArrayList<ArrayList<Coord3d>> modelToScreen(GL gl, GLU glu, ArrayList<ArrayList<Coord3d>> polygons) {
        int[] viewport = this.getViewPortAsInt(gl);
        float[] screencoord = new float[3];
        ArrayList<ArrayList<Coord3d>> projections = new ArrayList<ArrayList<Coord3d>>(polygons.size());
        for (ArrayList<Coord3d> polygon : polygons) {
            ArrayList<Coord3d> projection = new ArrayList<Coord3d>(polygon.size());
            for (Coord3d point : polygon) {
                if (!glu.gluProject(point.x, point.y, point.z, this.getModelViewAsFloat(gl), 0, this.getProjectionAsFloat(gl), 0, viewport, 0, screencoord, 0)) {
                    this.failedProjection("Could not retrieve model coordinates in screen for " + point);
                }
                projection.add(new Coord3d(screencoord[0], screencoord[1], screencoord[2]));
            }
            projections.add(projection);
        }
        return projections;
    }

    public PolygonArray modelToScreen(GL gl, GLU glu, PolygonArray polygon) {
        int[] viewport = this.getViewPortAsInt(gl);
        float[] screencoord = new float[3];
        int len = polygon.length();
        float[] x = new float[len];
        float[] y = new float[len];
        float[] z = new float[len];
        for (int i = 0; i < len; ++i) {
            if (!glu.gluProject(polygon.x[i], polygon.y[i], polygon.z[i], this.getModelViewAsFloat(gl), 0, this.getProjectionAsFloat(gl), 0, viewport, 0, screencoord, 0)) {
                this.failedProjection("Could not retrieve model coordinates in screen for point " + i);
            }
            x[i] = screencoord[0];
            y[i] = screencoord[1];
            z[i] = screencoord[2];
        }
        return new PolygonArray(x, y, z);
    }

    public Grid modelToScreen(GL gl, GLU glu, Grid grid) {
        int[] viewport = this.getViewPortAsInt(gl);
        double[] screencoord = new double[3];
        int xlen = grid.getX().length;
        int ylen = grid.getY().length;
        float[] x = new float[xlen];
        float[] y = new float[ylen];
        float[][] z = new float[xlen][ylen];
        for (int i = 0; i < xlen; ++i) {
            for (int j = 0; j < ylen; ++j) {
                this.failedProjection("Could not retrieve model coordinates in screen for point " + i);
                x[i] = (float)screencoord[0];
                y[j] = (float)screencoord[1];
                z[i][j] = (float)screencoord[2];
            }
        }
        return new Grid(x, y, z);
    }

    public PolygonArray[][] modelToScreen(GL gl, GLU glu, PolygonArray[][] polygons) {
        int[] viewport = this.getViewPortAsInt(gl);
        float[] screencoord = new float[3];
        PolygonArray[][] projections = new PolygonArray[polygons.length][polygons[0].length];
        for (int i = 0; i < polygons.length; ++i) {
            for (int j = 0; j < polygons[i].length; ++j) {
                PolygonArray polygon = polygons[i][j];
                int len = polygon.length();
                float[] x = new float[len];
                float[] y = new float[len];
                float[] z = new float[len];
                for (int k = 0; k < len; ++k) {
                    if (!glu.gluProject(polygon.x[k], polygon.y[k], polygon.z[k], this.getModelViewAsFloat(gl), 0, this.getProjectionAsFloat(gl), 0, viewport, 0, screencoord, 0)) {
                        this.failedProjection("Could not retrieve model coordinates in screen for point " + k);
                    }
                    x[k] = screencoord[0];
                    y[k] = screencoord[1];
                    z[k] = screencoord[2];
                }
                projections[i][j] = new PolygonArray(x, y, z);
            }
        }
        return projections;
    }

    protected void failedProjection(String message) {
        if (this.failOnException) {
            throw new RuntimeException(message);
        }
        Logger.getLogger(Camera.class).warn((Object)message);
    }

    protected int[] getViewPortAsInt(GL gl) {
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        return viewport;
    }

    protected double[] getProjectionAsDouble(GL gl) {
        double[] projection = new double[16];
        if (gl.isGL2()) {
            gl.getGL2().glGetDoublev(2983, projection, 0);
        } else {
            GLES2CompatUtils.glGetDoublev(2983, projection, 0);
        }
        return projection;
    }

    protected float[] getProjectionAsFloat(GL gl) {
        float[] projection = new float[16];
        gl.glGetFloatv(2983, projection, 0);
        return projection;
    }

    protected double[] getModelViewAsDouble(GL gl) {
        double[] modelview = new double[16];
        if (gl.isGL2()) {
            gl.getGL2().glGetDoublev(2982, modelview, 0);
        } else {
            GLES2CompatUtils.glGetDoublev(2982, modelview, 0);
        }
        return modelview;
    }

    protected float[] getModelViewAsFloat(GL gl) {
        float[] modelview = new float[16];
        gl.glGetFloatv(2982, modelview, 0);
        return modelview;
    }

    public void show(GL gl, Transform transform, Coord3d scaling) {
        if (transform != null) {
            transform.execute(gl);
        }
        Coord3d eye = this.getEye().mul(scaling);
        if (gl.isGL2()) {
            gl.getGL2().glBegin(0);
            gl.getGL2().glPointSize((float)this.camWidth);
            gl.getGL2().glColor4f(this.camColor.r, this.camColor.g, this.camColor.b, this.camColor.a);
            gl.getGL2().glVertex3f(eye.x, eye.y, eye.z);
            gl.getGL2().glEnd();
        } else {
            gl.getGL2().glBegin(0);
            gl.getGL2().glPointSize((float)this.camWidth);
            gl.getGL2().glColor4f(this.camColor.r, this.camColor.g, this.camColor.b, this.camColor.a);
            gl.getGL2().glVertex3f(eye.x, eye.y, eye.z);
            gl.getGL2().glEnd();
        }
    }

    public void shoot(GL gl, GLU glu, CameraMode projection) {
        this.shoot(gl, glu, projection, false);
    }

    public void shoot(GL gl, GLU glu, CameraMode projection, boolean doPushMatrixBeforeShooting) {
        if (gl.isGL2()) {
            gl.getGL2().glMatrixMode(5889);
            if (doPushMatrixBeforeShooting) {
                gl.getGL2().glPushMatrix();
            }
            gl.getGL2().glLoadIdentity();
        } else {
            GLES2CompatUtils.glMatrixMode(5889);
            if (doPushMatrixBeforeShooting) {
                GLES2CompatUtils.glPushMatrix();
            }
            GLES2CompatUtils.glLoadIdentity();
        }
        this.doShoot(gl, glu, projection);
    }

    public void doShoot(GL gl, GLU glu, CameraMode projection) {
        ViewportConfiguration viewport = this.applyViewport(gl, glu);
        if (projection == CameraMode.PERSPECTIVE) {
            boolean stretchToFill = ViewportMode.STRETCH_TO_FILL.equals((Object)viewport.getMode());
            double fov = this.computeFieldOfView(this.radius * 2.0f, this.eye.distance(this.target));
            float aspect = stretchToFill ? (float)this.screenWidth / (float)this.screenHeight : 1.0f;
            float nearCorrected = this.near <= 0.0f ? 1.0E-39f : this.near;
            glu.gluPerspective(fov, (double)aspect, (double)nearCorrected, (double)this.far);
        } else if (projection == CameraMode.ORTHOGONAL) {
            if (gl.isGL2()) {
                this.projectionOrthoGL2(gl, viewport);
            } else {
                this.projectionOrthoGLES2(viewport);
            }
        } else {
            throw new RuntimeException("Camera.shoot(): unknown projection mode '" + (Object)((Object)projection) + "'");
        }
        glu.gluLookAt(this.eye.x, this.eye.y, this.eye.z, this.target.x, this.target.y, this.target.z, this.up.x, this.up.y, this.up.z);
    }

    private void projectionOrthoGLES2(ViewportConfiguration viewport) {
        if (ViewportMode.STRETCH_TO_FILL.equals((Object)viewport.getMode())) {
            GLES2CompatUtils.glOrtho(-this.radius, this.radius, -this.radius, this.radius, this.near, this.far);
        } else if (ViewportMode.RECTANGLE_NO_STRETCH.equals((Object)viewport.getMode())) {
            GLES2CompatUtils.glOrtho(-this.radius * viewport.ratio(), this.radius * viewport.ratio(), -this.radius, this.radius, this.near, this.far);
        } else if (ViewportMode.SQUARE.equals((Object)viewport.getMode())) {
            GLES2CompatUtils.glOrtho(-this.radius, this.radius, -this.radius, this.radius, this.near, this.far);
        }
    }

    private void projectionOrthoGL2(GL gl, ViewportConfiguration viewport) {
        if (ViewportMode.STRETCH_TO_FILL.equals((Object)viewport.getMode())) {
            gl.getGL2().glOrtho((double)(-this.radius), (double)this.radius, (double)(-this.radius), (double)this.radius, (double)this.near, (double)this.far);
        } else if (ViewportMode.RECTANGLE_NO_STRETCH.equals((Object)viewport.getMode())) {
            gl.getGL2().glOrtho((double)(-this.radius * viewport.ratio()), (double)(this.radius * viewport.ratio()), (double)(-this.radius), (double)this.radius, (double)this.near, (double)this.far);
        } else if (ViewportMode.SQUARE.equals((Object)viewport.getMode())) {
            gl.getGL2().glOrtho((double)(-this.radius), (double)this.radius, (double)(-this.radius), (double)this.radius, (double)this.near, (double)this.far);
        }
    }

    protected double computeFieldOfView(double size, double distance) {
        double radtheta = 2.0 * Math.atan2(size / 2.0, distance);
        double degtheta = 180.0 * radtheta / Math.PI;
        return degtheta;
    }

    public double getDistance(AbstractDrawable drawable) {
        if (this.useSquaredDistance) {
            return drawable.getBarycentre().distanceSq(this.getEye());
        }
        return drawable.getBarycentre().distance(this.getEye());
    }

    public double getDistance(AbstractDrawable drawable, Coord3d viewScale) {
        if (this.useSquaredDistance) {
            return drawable.getBarycentre().distanceSq(this.getEye().div(viewScale));
        }
        return drawable.getBarycentre().distance(this.getEye().div(viewScale));
    }

    public double getDistance(Coord3d coord) {
        if (this.useSquaredDistance) {
            return coord.distanceSq(this.getEye());
        }
        return coord.distance(this.getEye());
    }

    public double getDistance(Coord3d coord, Coord3d viewScale) {
        if (this.useSquaredDistance) {
            return coord.distanceSq(this.getEye().div(viewScale));
        }
        return coord.distance(this.getEye().div(viewScale));
    }

    public boolean isUseSquaredDistance() {
        return this.useSquaredDistance;
    }

    public void setUseSquaredDistance(boolean useSquaredDistance) {
        this.useSquaredDistance = useSquaredDistance;
    }

    public String toString() {
        return this.toString(this.eye, this.target, this.up);
    }

    protected String toString(Coord3d eye, Coord3d target, Coord3d up) {
        String output = "(Camera)";
        output = output + " lookFrom  = {" + eye.x + ", " + eye.y + ", " + eye.z + "}";
        output = output + " lookTo    = {" + target.x + ", " + target.y + ", " + target.z + "}";
        output = output + " topToward = {" + up.x + ", " + up.y + ", " + up.z + "}";
        return output;
    }
}

