/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.tooltips;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.plot3d.rendering.tooltips.ITooltipRenderer;

public class TextTooltipRenderer
implements ITooltipRenderer {
    protected Coord3d target = Coord3d.INVALID;
    protected IntegerCoord2d screenLocation = new IntegerCoord2d();
    protected Rectangle lastBounds;
    protected String text = "";

    public TextTooltipRenderer(String text, IntegerCoord2d screen, Coord3d target) {
        if (screen != null) {
            this.text = text;
        }
        if (screen != null) {
            this.screenLocation = screen;
        }
        if (target != null) {
            this.target = target;
        }
    }

    @Override
    public void render(Graphics2D g2d) {
        this.lastBounds = new Rectangle(this.screenLocation.x - 10, this.screenLocation.y - 13, 10 + this.text.length() * 6, 16);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(this.lastBounds.x, this.lastBounds.y, this.lastBounds.width, this.lastBounds.height);
        g2d.drawString(this.text, this.screenLocation.x, this.screenLocation.y);
    }

    @Override
    public void updateScreenPosition(IntegerCoord2d position) {
        this.screenLocation = position;
    }

    public void updateTargetCoordinate(Coord3d target) {
        this.target = target;
    }
}

