/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.legends;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.jzy3d.colors.Color;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.events.IDrawableListener;
import org.jzy3d.io.FileImage;
import org.jzy3d.maths.Dimension;
import org.jzy3d.plot2d.primitive.AWTImageGenerator;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.legends.ILegend;
import org.jzy3d.plot3d.rendering.view.AWTImageViewport;

public abstract class AWTLegend
extends AWTImageViewport
implements IDrawableListener,
ILegend {
    protected AbstractDrawable drawable;
    protected Color foreground;
    protected Color background;
    protected Dimension minimumDimension;
    protected AWTImageGenerator imageGenerator;

    public AWTLegend(AbstractDrawable drawable) {
        this.drawable = drawable;
        if (drawable != null) {
            drawable.addDrawableListener(this);
        }
    }

    public AWTLegend(AbstractDrawable drawable, Color foreground, Color background) {
        this(drawable);
        this.foreground = foreground;
        this.background = background;
    }

    public void dispose() {
        if (this.drawable != null) {
            this.drawable.removeDrawableListener(this);
        }
    }

    public abstract BufferedImage toImage(int var1, int var2);

    @Override
    public void setViewPort(int width, int height, float left, float right) {
        super.setViewPort(width, height, left, right);
        int imgWidth = (int)((float)width * (right - left));
        if (this.imageWidth != imgWidth || this.imageHeight != height) {
            this.setImage(this.toImage(imgWidth, height));
        }
    }

    @Override
    public void drawableChanged(DrawableChangedEvent e) {
        if (e.what() == 2) {
            this.updateImage();
        }
    }

    @Override
    public void updateImage() {
        this.setImage(this.toImage(this.imageWidth, this.imageHeight));
    }

    public void saveImage(String filename) throws IOException {
        FileImage.savePNG(this.imageObj, filename);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumDimension;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minimumDimension = dimension;
    }

    public void setGeneratorColors() {
        if (this.foreground != null) {
            this.imageGenerator.setForegroundColor(this.foreground);
        } else {
            this.imageGenerator.setForegroundColor(Color.BLACK);
        }
        if (this.background != null) {
            this.imageGenerator.setBackgroundColor(this.background);
            this.imageGenerator.setHasBackground(true);
        } else {
            this.imageGenerator.setHasBackground(false);
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Dimension getMinimumDimension() {
        return this.minimumDimension;
    }

    public void setMinimumDimension(Dimension minimumDimension) {
        this.minimumDimension = minimumDimension;
    }
}

