/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.canvas;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import org.jzy3d.chart.Settings;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer3d;
import org.jzy3d.plot3d.rendering.view.View;

@Deprecated
public class CanvasSwing
extends GLJPanel
implements IScreenCanvas {
    protected View view;
    protected Renderer3d renderer;
    protected Animator animator;
    private static final long serialVersionUID = 980088854683562436L;

    public CanvasSwing(IChartComponentFactory factory, Scene scene, Quality quality) {
        this(factory, scene, quality, (GLCapabilitiesImmutable)Settings.getInstance().getGLCapabilities());
    }

    public CanvasSwing(IChartComponentFactory factory, Scene scene, Quality quality, GLCapabilitiesImmutable glci) {
        this(factory, scene, quality, glci, false, false);
    }

    public CanvasSwing(IChartComponentFactory factory, Scene scene, Quality quality, GLCapabilitiesImmutable glci, boolean traceGL, boolean debugGL) {
        super(glci);
        this.view = scene.newView(this, quality);
        this.renderer = factory.newRenderer(this.view, traceGL, debugGL);
        this.addGLEventListener(this.renderer);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.setAutoSwapBufferMode(quality.isAutoSwapBuffer());
        if (quality.isAnimated()) {
            this.animator = new Animator((GLAutoDrawable)this);
            this.getAnimator().start();
        }
        if (quality.isPreserveViewportSize()) {
            this.setPixelScale(new float[]{1.0f, 1.0f});
        }
    }

    @Override
    public void dispose() {
        if (this.animator != null) {
            this.animator.stop();
        }
        if (this.renderer != null) {
            this.renderer.dispose((GLAutoDrawable)this);
        }
        this.renderer = null;
        this.view = null;
    }

    @Override
    public void forceRepaint() {
        this.display();
    }

    @Override
    public TextureData screenshot(File file) throws IOException {
        TextureData screen = this.screenshot();
        TextureIO.write((TextureData)screen, (File)file);
        return screen;
    }

    @Override
    public TextureData screenshot() {
        this.renderer.nextDisplayUpdateScreenshot();
        this.display();
        return this.renderer.getLastScreenshot();
    }

    @Override
    public GLDrawable getDrawable() {
        return this;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public int getRendererWidth() {
        return this.renderer != null ? this.renderer.getWidth() : 0;
    }

    @Override
    public int getRendererHeight() {
        return this.renderer != null ? this.renderer.getHeight() : 0;
    }

    @Override
    public Renderer3d getRenderer() {
        return this.renderer;
    }

    @Override
    public String getDebugInfo() {
        GL gl = this.getView().getCurrentGL();
        StringBuffer sb = new StringBuffer();
        sb.append("Chosen GLCapabilities: " + this.getChosenGLCapabilities() + "\n");
        sb.append("GL_VENDOR: " + gl.glGetString(7936) + "\n");
        sb.append("GL_RENDERER: " + gl.glGetString(7937) + "\n");
        sb.append("GL_VERSION: " + gl.glGetString(7938) + "\n");
        return sb.toString();
    }

    @Override
    public void addMouseController(Object o) {
        this.addMouseListener((MouseListener)o);
    }

    @Override
    public void addKeyController(Object o) {
        this.addKeyListener((KeyListener)o);
    }

    @Override
    public void removeMouseController(Object o) {
        this.removeMouseListener((MouseListener)o);
    }

    @Override
    public void removeKeyController(Object o) {
        this.removeKeyListener((KeyListener)o);
    }

    @Override
    public void setPixelScale(float[] scale) {
        this.setSurfaceScale(scale);
    }
}

