/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.vbo.drawable;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.apache.log4j.Logger;
import org.jzy3d.colors.Color;
import org.jzy3d.io.IGLLoader;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.IGLBindedResource;
import org.jzy3d.plot3d.primitives.vbo.buffers.FloatVBO;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Rotate;
import org.jzy3d.plot3d.transform.Rotator;
import org.jzy3d.plot3d.transform.Transform;

public class DrawableVBO
extends AbstractDrawable
implements IGLBindedResource {
    protected int geometry = 4;
    protected float width = 1.0f;
    protected Quality quality = Quality.Nicest;
    protected int colorChannelNumber = 3;
    boolean hasColorBuffer = false;
    protected IGLLoader<DrawableVBO> loader;
    protected int byteOffset;
    protected int normalOffset;
    protected int dimensions;
    protected int size;
    protected int pointer;
    protected int[] arrayName = new int[1];
    protected int[] elementName = new int[1];
    protected boolean hasMountedOnce = false;
    protected Color color = new Color(1.0f, 0.0f, 1.0f, 0.75f);

    public DrawableVBO(IGLLoader<DrawableVBO> loader) {
        this.loader = loader;
    }

    @Override
    public boolean hasMountedOnce() {
        return this.hasMountedOnce;
    }

    @Override
    public void mount(GL gl) {
        try {
            this.loader.load(gl, this);
            this.hasMountedOnce = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getLogger(DrawableVBO.class).error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        if (this.hasMountedOnce) {
            this.doTransform(gl, glu, cam);
            this.configure(gl);
            this.doDrawElements(gl);
            this.doDrawBounds(gl, glu, cam);
        }
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public void setQuality(Quality quality) {
        this.quality = quality;
    }

    protected void doDrawElements(GL gl) {
        if (gl.isGL2()) {
            this.doBindGL2(gl);
            this.pointers(gl);
            this.color(gl);
            this.enable(gl);
            this.applyWidth(gl);
            this.applyQuality(gl);
            this.applyVertices(gl);
            this.disable(gl);
            this.disableColor(gl);
        } else {
            GLES2CompatUtils.glBindBuffer(34962, this.arrayName[0]);
            GLES2CompatUtils.glBindBuffer(34963, this.elementName[0]);
            GLES2CompatUtils.glVertexPointer(this.dimensions, 5126, this.byteOffset, this.pointer);
            GLES2CompatUtils.glNormalPointer(5126, this.byteOffset, this.normalOffset);
            GLES2CompatUtils.glEnableClientState(32884);
            GLES2CompatUtils.glEnableClientState(32885);
            GLES2CompatUtils.glDrawElements(this.getGeometry(), this.size, 5125, this.pointer);
            GLES2CompatUtils.glBindBuffer(34963, this.elementName[0]);
            GLES2CompatUtils.glBindBuffer(34962, this.arrayName[0]);
            GLES2CompatUtils.glEnableClientState(32884);
            GLES2CompatUtils.glEnableClientState(32885);
        }
    }

    private void disableColor(GL gl) {
        if (this.hasColorBuffer) {
            gl.getGL2().glDisableClientState(32886);
        }
    }

    private void pointers(GL gl) {
        gl.getGL2().glVertexPointer(this.dimensions, 5126, this.byteOffset, (long)this.pointer);
        gl.getGL2().glNormalPointer(5126, this.byteOffset, (long)this.normalOffset);
    }

    private void color(GL gl) {
        if (this.hasColorBuffer) {
            int p = 12;
            gl.getGL2().glEnableClientState(32886);
            gl.getGL2().glColorPointer(this.colorChannelNumber, 5126, this.byteOffset, (long)p);
        }
    }

    private void enable(GL gl) {
        gl.getGL2().glEnableClientState(32884);
        gl.getGL2().glEnableClientState(32885);
    }

    private void disable(GL gl) {
        gl.getGL2().glDisableClientState(32884);
        gl.getGL2().glDisableClientState(32885);
    }

    private void applyVertices(GL gl) {
        gl.getGL2().glDrawElements(this.getGeometry(), this.size, 5125, (long)this.pointer);
        this.doBindGL2(gl);
    }

    private void applyWidth(GL gl) {
        if (this.geometry == 0) {
            gl.getGL2().glPointSize(this.width);
        } else if (this.geometry == 1) {
            gl.getGL2().glLineWidth(this.width);
        }
    }

    private void applyQuality(GL gl) {
        if (this.quality.isSmoothPolygon()) {
            gl.glEnable(2881);
            gl.glHint(3155, 4354);
        } else {
            gl.glDisable(2881);
        }
        if (this.quality.isSmoothLine()) {
            gl.glEnable(2848);
            gl.glHint(3154, 4354);
        } else {
            gl.glDisable(2848);
        }
        if (this.quality.isSmoothPoint()) {
            gl.glEnable(2832);
            gl.glHint(3153, 4354);
        } else {
            gl.glDisable(2832);
        }
    }

    protected void doBindGL2(GL gl) {
        gl.getGL2().glBindBuffer(34962, this.arrayName[0]);
        gl.getGL2().glBindBuffer(34963, this.elementName[0]);
    }

    public Rotator rotator(boolean start) {
        Rotate r = new Rotate(25.0f, new Coord3d(0.0f, 0.0f, 1.0f));
        Transform t = new Transform();
        t.add(r);
        this.setTransformBefore(t);
        Rotator rotator = new Rotator(10, r);
        if (start) {
            rotator.start();
        }
        return rotator;
    }

    public Rotator rotator() {
        return this.rotator(false);
    }

    protected void configure(GL gl) {
        if (gl.isGL2()) {
            gl.getGL2().glPolygonMode(1032, 6914);
        } else {
            GLES2CompatUtils.glPolygonMode(1032, 6914);
        }
        this.call(gl, this.color);
    }

    public boolean isHasColorBuffer() {
        return this.hasColorBuffer;
    }

    public void setHasColorBuffer(boolean hasColorBuffer) {
        this.hasColorBuffer = hasColorBuffer;
    }

    public int getGeometry() {
        return this.geometry;
    }

    public void setGeometry(int geometry) {
        this.geometry = geometry;
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        Logger.getLogger(DrawableVBO.class).warn((Object)"not implemented");
    }

    @Override
    public void updateBounds() {
        Logger.getLogger(DrawableVBO.class).warn((Object)"not implemented");
    }

    public void setData(GL gl, FloatVBO vbo) {
        this.setData(gl.getGL2(), vbo.getIndices(), vbo.getVertices(), vbo.getBounds(), 0);
    }

    public void setData(GL gl, IntBuffer indices, FloatBuffer vertices, BoundingBox3d bounds) {
        this.setData(gl.getGL2(), indices, vertices, bounds, 0);
    }

    public void setData(GL2 gl, IntBuffer indices, FloatBuffer vertices, BoundingBox3d bounds, int pointer) {
        this.doConfigure(pointer, indices.capacity());
        this.doLoadArrayFloatBuffer((GL)gl, vertices);
        this.doLoadElementIntBuffer((GL)gl, indices);
        this.doSetBoundingBox(bounds);
    }

    public void doConfigure(int pointer, int size) {
        int dimensions = 3;
        int byteOffset = dimensions * 2 * 4;
        int normalOffset = dimensions * 4;
        this.doConfigure(pointer, size, byteOffset, normalOffset, dimensions);
    }

    public void doConfigure(int pointer, int size, int byteOffset, int normalOffset, int dimensions) {
        this.byteOffset = byteOffset;
        this.normalOffset = normalOffset;
        this.dimensions = dimensions;
        this.size = size;
        this.pointer = pointer;
    }

    public void doLoadArrayFloatBuffer(GL gl, FloatBuffer vertices) {
        this.doLoadArrayFloatBuffer(gl, vertices.capacity() * 4, vertices);
    }

    public void doLoadArrayFloatBuffer(GL gl, int vertexSize, FloatBuffer vertices) {
        gl.glGenBuffers(1, this.arrayName, 0);
        gl.glBindBuffer(34962, this.arrayName[0]);
        gl.glBufferData(34962, (long)vertexSize, (Buffer)vertices, 35044);
        gl.glBindBuffer(34962, this.pointer);
    }

    public void doLoadElementIntBuffer(GL gl, IntBuffer indices) {
        this.doLoadElementIntBuffer(gl, indices.capacity() * 4, indices);
    }

    public void doLoadElementIntBuffer(GL gl, int indexSize, IntBuffer indices) {
        gl.glGenBuffers(1, this.elementName, 0);
        gl.glBindBuffer(34963, this.elementName[0]);
        gl.glBufferData(34963, (long)indexSize, (Buffer)indices, 35044);
        gl.glBindBuffer(34963, this.pointer);
    }

    public void doSetBoundingBox(BoundingBox3d bounds) {
        this.bbox = bounds;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

