/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.selectable;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Polygon2d;
import org.jzy3d.plot3d.builder.concrete.SphereScatterGenerator;
import org.jzy3d.plot3d.primitives.Sphere;
import org.jzy3d.plot3d.primitives.selectable.Selectable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;

public class SelectableSphere
extends Sphere
implements Selectable {
    protected List<Coord3d> anchors;
    protected int PRECISION = 10;
    protected boolean isHighlighted = false;
    protected List<Coord3d> projection;

    public SelectableSphere() {
        this(Coord3d.ORIGIN, 10.0f, 15, Color.BLACK);
    }

    public SelectableSphere(Coord3d position, float radius, int slicing, Color color) {
        super(position, radius, slicing, color);
        this.buildAnchors();
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        super.draw(gl, glu, cam);
        if (gl.isGL2()) {
            gl.getGL2().glBegin(0);
            gl.getGL2().glColor4f(Color.RED.r, Color.RED.g, Color.RED.b, Color.RED.a);
            for (Coord3d a : this.anchors) {
                gl.getGL2().glVertex3f(a.x, a.y, a.z);
            }
            gl.getGL2().glEnd();
        } else {
            GLES2CompatUtils.glBegin(0);
            GLES2CompatUtils.glColor4f(Color.RED.r, Color.RED.g, Color.RED.b, Color.RED.a);
            for (Coord3d a : this.anchors) {
                GLES2CompatUtils.glVertex3f(a.x, a.y, a.z);
            }
            GLES2CompatUtils.glEnd();
        }
    }

    @Override
    public void project(GL gl, GLU glu, Camera cam) {
        this.projection = cam.modelToScreen(gl, glu, this.anchors);
    }

    public List<Coord3d> getProjection() {
        return this.projection;
    }

    @Override
    public void setPosition(Coord3d position) {
        super.setPosition(position);
        this.buildAnchors();
    }

    @Override
    public void setVolume(float radius) {
        super.setVolume(radius);
        this.buildAnchors();
    }

    protected void buildAnchors() {
        this.anchors = this.buildAnchors(this.position, this.radius);
    }

    protected List<Coord3d> buildAnchors(Coord3d position, float radius) {
        return SphereScatterGenerator.generate(position, radius, this.PRECISION, false);
    }

    @Override
    public Polygon2d getHull2d() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public List<Coord3d> getLastProjection() {
        throw new RuntimeException("not implemented");
    }

    public void setHighlighted(boolean value) {
        this.isHighlighted = value;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void resetHighlighting() {
        this.isHighlighted = false;
    }
}

