/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.log;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.log.GlVertexExecutor;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeTransformablePoint
extends Point {
    SpaceTransformer transformers;

    public AxeTransformablePoint(SpaceTransformer transformers) {
        this(Coord3d.ORIGIN, Color.WHITE, 1.0f, transformers);
    }

    public AxeTransformablePoint(Coord3d xyz, SpaceTransformer transformers) {
        this(xyz, Color.WHITE, 1.0f, transformers);
    }

    public AxeTransformablePoint(Coord3d xyz, Color rgb, SpaceTransformer transformers) {
        this(xyz, rgb, 1.0f, transformers);
    }

    public AxeTransformablePoint(Coord3d xyz, Color rgb, float width, SpaceTransformer transformers) {
        super(xyz, rgb, width);
        this.transformers = transformers;
        this.updateBounds();
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            gl.getGL2().glPointSize(this.width);
            gl.getGL2().glBegin(0);
            gl.getGL2().glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
            GlVertexExecutor.Vertex(gl, new Coord3d(this.xyz.x, this.xyz.y, this.xyz.z), this.transformers);
            gl.getGL2().glEnd();
        } else {
            GLES2CompatUtils.glPointSize(this.width);
            GLES2CompatUtils.glBegin(0);
            GLES2CompatUtils.glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
            GLES2CompatUtils.glVertex3f(this.transformers.getX().compute(this.xyz.x), this.transformers.getY().compute(this.xyz.y), this.transformers.getZ().compute(this.xyz.z));
            GLES2CompatUtils.glEnd();
        }
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        if (this.transformers != null) {
            this.bbox.add(this.transformers.compute(this.xyz));
        } else {
            this.bbox.add(this);
        }
    }
}

