/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.log;

import com.jogamp.opengl.GL;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.log.GlVertexExecutor;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeTransformableLineStrip
extends LineStrip {
    SpaceTransformer transformers;

    public AxeTransformableLineStrip(SpaceTransformer transformers) {
        this(2, transformers);
    }

    public AxeTransformableLineStrip(int n, SpaceTransformer transformers) {
        this.transformers = transformers;
        this.points = new ArrayList(n);
        this.bbox = new BoundingBox3d();
        for (Point p : this.points) {
            this.bbox.add(p);
        }
        this.setWireframeColor(null);
    }

    public AxeTransformableLineStrip(List<Coord3d> coords, SpaceTransformer transformers) {
        this(transformers);
        for (Coord3d c : coords) {
            Point p = new Point(c);
            this.add(p);
        }
    }

    public AxeTransformableLineStrip(Point c1, Point c2, SpaceTransformer transformers) {
        this(transformers);
        this.add(c1);
        this.add(c2);
    }

    @Override
    public void drawLineGLES2() {
        GLES2CompatUtils.glBegin(3);
        if (this.wfcolor == null) {
            for (Point p : this.points) {
                GLES2CompatUtils.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                GLES2CompatUtils.glVertex3f(this.transformers.getX().compute(p.xyz.x), this.transformers.getY().compute(p.xyz.y), this.transformers.getZ().compute(p.xyz.z));
            }
        } else {
            for (Point p : this.points) {
                GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                GLES2CompatUtils.glVertex3f(this.transformers.getX().compute(p.xyz.x), this.transformers.getY().compute(p.xyz.y), this.transformers.getZ().compute(p.xyz.z));
            }
        }
        GLES2CompatUtils.glEnd();
    }

    @Override
    public void drawLineGL2(GL gl) {
        gl.getGL2().glBegin(3);
        if (this.wfcolor == null) {
            for (Point p : this.points) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                GlVertexExecutor.Vertex(gl, new Coord3d(p.xyz.x, p.xyz.y, p.xyz.z), this.transformers);
            }
        } else {
            for (Point p : this.points) {
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                GlVertexExecutor.Vertex(gl, new Coord3d(p.xyz.x, p.xyz.y, p.xyz.z), this.transformers);
            }
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void drawPoints(GL gl) {
        if (this.showPoints) {
            if (gl.isGL2()) {
                this.drawPointsGL2(gl);
            } else {
                this.drawPointsGLES2();
            }
        }
    }

    @Override
    public void drawPointsGLES2() {
        GLES2CompatUtils.glBegin(0);
        for (Point p : this.points) {
            if (this.wfcolor == null) {
                GLES2CompatUtils.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
            } else {
                GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            }
            GLES2CompatUtils.glVertex3f(this.transformers.getX().compute(p.xyz.x), this.transformers.getY().compute(p.xyz.y), this.transformers.getZ().compute(p.xyz.z));
        }
        GLES2CompatUtils.glEnd();
    }

    @Override
    public void drawPointsGL2(GL gl) {
        gl.getGL2().glBegin(0);
        for (Point p : this.points) {
            if (this.wfcolor == null) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
            } else {
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
            }
            GlVertexExecutor.Vertex(gl, new Coord3d(p.xyz.x, p.xyz.y, p.xyz.z), this.transformers);
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        for (Point p : this.points) {
            this.bbox.add(this.transform.compute(p.xyz));
        }
    }
}

