/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.log;

import com.jogamp.opengl.GL;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.ConcurrentScatterMultiColorList;
import org.jzy3d.plot3d.primitives.log.GlVertexExecutor;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeTransformableConcurrentScatterMultiColorList
extends ConcurrentScatterMultiColorList {
    SpaceTransformer transformers;

    public AxeTransformableConcurrentScatterMultiColorList(ColorMapper mapper, SpaceTransformer transformers) {
        this(new ArrayList<Coord3d>(), mapper, 1.0f, transformers);
    }

    public AxeTransformableConcurrentScatterMultiColorList(List<Coord3d> coordinates, ColorMapper mapper, SpaceTransformer transformers) {
        this(coordinates, mapper, 1.0f, transformers);
    }

    public AxeTransformableConcurrentScatterMultiColorList(List<Coord3d> coordinates, ColorMapper mapper, float width, SpaceTransformer transformers) {
        super(coordinates, mapper, width);
        this.transformers = transformers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.coordinates != null) {
            List list = this.coordinates;
            synchronized (list) {
                for (Coord3d coord : this.coordinates) {
                    Color color = this.mapper.getColor(coord);
                    GLES2CompatUtils.glColor4f(color.r, color.g, color.b, color.a);
                    GLES2CompatUtils.glVertex3f(this.transformers.getX().compute(coord.x), this.transformers.getY().compute(coord.y), this.transformers.getZ().compute(coord.z));
                }
            }
        }
        GLES2CompatUtils.glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.coordinates != null) {
            List list = this.coordinates;
            synchronized (list) {
                for (Coord3d coord : this.coordinates) {
                    Color color = this.mapper.getColor(coord);
                    gl.getGL2().glColor4f(color.r, color.g, color.b, color.a);
                    GlVertexExecutor.Vertex(gl, new Coord3d(coord.x, coord.y, coord.z), this.transformers);
                }
            }
        }
        gl.getGL2().glEnd();
    }
}

