/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.interactive.tools;

import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.interactive.tools.IProjection;

public class PolygonProjection
implements IProjection {
    public List<Coord3d> coords;
    public List<Color> colors;

    public PolygonProjection(List<Coord3d> coords, List<Color> colors) {
        this.coords = coords;
        this.colors = colors;
    }

    @Override
    public float deapness() {
        float dist = 1.0f;
        for (Coord3d c : this.coords) {
            if (!(c.z < dist)) continue;
            dist = c.z;
        }
        return dist;
    }

    public Color getMeanColor() {
        Color mean = new Color(0, 0, 0);
        for (Color c : this.colors) {
            mean.r += c.r;
            mean.g += c.g;
            mean.b += c.b;
        }
        mean.r /= (float)this.colors.size();
        mean.g /= (float)this.colors.size();
        mean.b /= (float)this.colors.size();
        return mean;
    }
}

