/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.graphs.impl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.HashMap;
import java.util.Map;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.graphs.IGraph;
import org.jzy3d.picking.PickingSupport;
import org.jzy3d.plot3d.primitives.graphs.impl.DefaultDrawableGraph2d;
import org.jzy3d.plot3d.primitives.pickable.PickablePoint;
import org.jzy3d.plot3d.rendering.view.Camera;

public class PointGraph2d<V, E>
extends DefaultDrawableGraph2d<V, E> {
    protected Map<V, PickablePoint> vertexObjects = new HashMap<V, PickablePoint>();

    public PointGraph2d() {
        this.bbox = new BoundingBox3d();
        this.labelScreenOffset = new Coord2d(0.0f, -2.0f);
    }

    @Override
    public void setGraphModel(IGraph<V, E> graph, PickingSupport picking) {
        super.setGraphModel(graph, picking);
        for (V v : graph.getVertices()) {
            PickablePoint p = this.newPoint(v);
            p.setWidth(this.formatter.getVertexWidth());
            this.vertexObjects.put((PickablePoint)v, p);
            picking.registerDrawableObject(p, v);
        }
    }

    @Override
    public void setGraphModel(IGraph<V, E> graph) {
        super.setGraphModel(graph);
        for (V v : graph.getVertices()) {
            PickablePoint p = this.newPoint(v);
            p.setWidth(this.formatter.getVertexWidth());
            this.vertexObjects.put((PickablePoint)v, p);
        }
    }

    protected PickablePoint newPoint(V vertex) {
        PickablePoint p = new PickablePoint(Coord3d.ORIGIN, this.formatter.getVertexColor(), this.formatter.getVertexWidth());
        return p;
    }

    @Override
    protected void drawVertices(GL gl, GLU glu, Camera cam) {
        for (Object v : this.graph.getVertices()) {
            if (((Boolean)this.highlights.get(v)).booleanValue()) {
                this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getHighlightedVertexColor());
                continue;
            }
            this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getVertexColor());
        }
    }

    @Override
    protected void drawVertexNode(GL gl, GLU glu, Camera cam, V v, Coord2d coord, Color color) {
        PickablePoint pt = this.vertexObjects.get(v);
        pt.setData(new Coord3d(coord, Z));
        pt.setColor(color);
        pt.draw(gl, glu, cam);
    }
}

