/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.graphs.impl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.apache.log4j.Logger;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.graphs.AbstractDrawableGraph2d;
import org.jzy3d.plot3d.primitives.textured.DrawableTexture;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.transform.Transform;

public class DefaultDrawableGraph2d<V, E>
extends AbstractDrawableGraph2d<V, E> {
    public DefaultDrawableGraph2d() {
        this.bbox = new BoundingBox3d();
        this.labelScreenOffset = new Coord2d(0.0f, 0.0f);
        this.labelSceneOffset = new Coord3d(0.0f, 0.0f, 0.0f);
    }

    @Override
    protected void drawVertices(GL gl, GLU glu, Camera cam) {
        if (gl.isGL2()) {
            gl.getGL2().glPointSize((float)this.formatter.getVertexWidth());
            gl.getGL2().glBegin(0);
            for (Object v : this.graph.getVertices()) {
                if (((Boolean)this.highlights.get(v)).booleanValue()) {
                    this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getHighlightedVertexColor());
                    continue;
                }
                this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getVertexColor());
            }
            gl.getGL2().glEnd();
        } else {
            GLES2CompatUtils.glPointSize(this.formatter.getVertexWidth());
            GLES2CompatUtils.glBegin(0);
            for (Object v : this.graph.getVertices()) {
                if (((Boolean)this.highlights.get(v)).booleanValue()) {
                    this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getHighlightedVertexColor());
                    continue;
                }
                this.drawVertexNode(gl, glu, cam, v, this.layout.get(v), this.formatter.getVertexColor());
            }
            GLES2CompatUtils.glEnd();
        }
    }

    @Override
    protected void drawVertexLabels(GL gl, GLU glu, Camera cam) {
        for (Object v : this.graph.getVertices()) {
            if (((Boolean)this.highlights.get(v)).booleanValue()) {
                this.drawVertexLabel(gl, glu, cam, v, this.layout.get(v), this.formatter.getHighlightedVertexColor());
                continue;
            }
            this.drawVertexLabel(gl, glu, cam, v, this.layout.get(v), this.formatter.getVertexLabelColor());
        }
    }

    @Override
    protected void drawEdges(GL gl, GLU glu, Camera cam) {
        for (Object e : this.graph.getEdges()) {
            Object v1 = this.graph.getEdgeStartVertex(e);
            Object v2 = this.graph.getEdgeStopVertex(e);
            this.drawEdge(gl, glu, cam, e, this.layout.get(v1), this.layout.get(v2), this.formatter.getEdgeColor());
        }
    }

    protected void drawVertexNode(GL gl, GLU glu, Camera cam, V v, Coord2d coord, Color color) {
        if (gl.isGL2()) {
            gl.getGL2().glColor4f(color.r, color.g, color.b, color.a);
            gl.getGL2().glVertex3f(coord.x, coord.y, Z);
        } else {
            GLES2CompatUtils.glColor4f(color.r, color.g, color.b, color.a);
            GLES2CompatUtils.glVertex3f(coord.x, coord.y, Z);
        }
    }

    protected void drawVertexLabel(GL gl, GLU glu, Camera cam, V v, Coord2d coord, Color color) {
        Coord3d textPosition = new Coord3d(coord, Z);
        this.txt.drawText(gl, glu, cam, v.toString(), textPosition, Halign.CENTER, Valign.BOTTOM, color, this.labelScreenOffset, this.labelSceneOffset);
    }

    protected void drawEdge(GL gl, GLU glu, Camera cam, E e, Coord2d c1, Coord2d c2, Color color) {
        if (gl.isGL2()) {
            gl.getGL2().glBegin(3);
            gl.getGL2().glColor4f(color.r, color.g, color.b, color.a);
            gl.getGL2().glVertex3f(c1.x, c1.y, Z);
            gl.getGL2().glVertex3f(c2.x, c2.y, Z);
            gl.getGL2().glEnd();
        } else {
            GLES2CompatUtils.glBegin(3);
            GLES2CompatUtils.glColor4f(color.r, color.g, color.b, color.a);
            GLES2CompatUtils.glVertex3f(c1.x, c1.y, Z);
            GLES2CompatUtils.glVertex3f(c2.x, c2.y, Z);
            GLES2CompatUtils.glEnd();
        }
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        Logger.getLogger(DrawableTexture.class).warn((Object)"not implemented");
    }

    @Override
    public void updateBounds() {
        Logger.getLogger(DrawableTexture.class).warn((Object)"not implemented");
    }
}

