/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.enlightables;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.enlightables.AbstractEnlightable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class EnlightableSphere
extends AbstractEnlightable
implements ISingleColorable {
    private float x;
    private float y;
    private float z;
    private float radius;
    private int slices;
    private int stacks;
    private Color color;

    public EnlightableSphere() {
        this(Coord3d.ORIGIN, 10.0f, 15, Color.BLACK);
    }

    public EnlightableSphere(Coord3d position, float radius, int slicing, Color color) {
        this.bbox = new BoundingBox3d();
        this.setPosition(position);
        this.setVolume(radius);
        this.setSlicing(slicing, slicing);
        this.setColor(color);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            gl.getGL2().glTranslatef(this.x, this.y, this.z);
        } else {
            GLES2CompatUtils.glTranslatef(this.x, this.y, this.z);
        }
        this.applyMaterial(gl);
        gl.glLineWidth(this.wfwidth);
        GLUquadric qobj = glu.gluNewQuadric();
        if (gl.isGL2()) {
            if (this.facestatus) {
                gl.getGL2().glPolygonMode(1032, 6914);
                gl.getGL2().glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
                glu.gluSphere(qobj, (double)this.radius, this.slices, this.stacks);
            }
            if (this.wfstatus) {
                gl.getGL2().glPolygonMode(1032, 6913);
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                glu.gluSphere(qobj, (double)this.radius, this.slices, this.stacks);
            }
        } else {
            if (this.facestatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6914);
                GLES2CompatUtils.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
                glu.gluSphere(qobj, (double)this.radius, this.slices, this.stacks);
            }
            if (this.wfstatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6913);
                GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                glu.gluSphere(qobj, (double)this.radius, this.slices, this.stacks);
            }
        }
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        Coord3d change = transform.compute(new Coord3d(this.x, this.y, this.z));
        this.x = change.x;
        this.y = change.y;
        this.z = change.z;
        this.updateBounds();
    }

    public void setData(Coord3d position, float radius, float height, int slices, int stacks) {
        this.setPosition(position);
        this.setVolume(radius);
        this.setSlicing(slices, stacks);
    }

    public void setPosition(Coord3d position) {
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        this.bbox.add(this.x + this.radius, this.y + this.radius, this.z + this.radius);
        this.bbox.add(this.x - this.radius, this.y - this.radius, this.z - this.radius);
    }

    public void setVolume(float radius) {
        this.radius = radius;
        this.bbox.reset();
        this.bbox.add(this.x + radius, this.y + radius, this.z + radius);
        this.bbox.add(this.x - radius, this.y - radius, this.z - radius);
    }

    public void setSlicing(int verticalWires, int horizontalWires) {
        this.slices = verticalWires;
        this.stacks = horizontalWires;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public String toString(int depth) {
        return Utils.blanks(depth) + "(EnlightableSphere) x=" + this.x + " y=" + this.y + " z=" + this.z + " r=" + this.color.r + " g=" + this.color.g + " b=" + this.color.b + " a=" + this.color.a;
    }
}

