/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.opengl.GL;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.primitives.axes.AxeAnnotation;
import org.jzy3d.plot3d.primitives.axes.AxeXLineAnnotation;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;

public class AxeXRectangleAnnotation
extends AxeXLineAnnotation
implements AxeAnnotation {
    PolygonMode polygonMode = PolygonMode.FRONT_AND_BACK;

    public void drawLineGLES2(Range yrange, Range zrange) {
        GLES2CompatUtils.glBegin(9);
        GLES2CompatUtils.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        GLES2CompatUtils.glVertex3f(this.value, yrange.getMin(), 0.0f);
        GLES2CompatUtils.glVertex3f(this.value, yrange.getMax(), 0.0f);
        GLES2CompatUtils.glVertex3f(this.value - this.width, yrange.getMax(), 0.0f);
        GLES2CompatUtils.glVertex3f(this.value - this.width, yrange.getMin(), 0.0f);
        GLES2CompatUtils.glEnd();
    }

    public synchronized void drawLineGL2(GL gl, Range yrange, Range zrange) {
        gl.getGL2().glBegin(9);
        gl.getGL2().glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        this.applyPolygonModeLine(gl);
        this.applyPolygonModeFill(gl);
        float ymin = yrange.getMin() - yrange.getRange() / 30.0f;
        float ymax = yrange.getMax() + yrange.getRange() / 30.0f;
        float z = zrange.getMin() - 2.0f;
        gl.getGL2().glVertex3f(this.value - this.width, ymin, z);
        gl.getGL2().glVertex3f(this.value - this.width, ymax, z);
        gl.getGL2().glVertex3f(this.value, ymax, z);
        gl.getGL2().glVertex3f(this.value, ymin, z);
        gl.getGL2().glEnd();
    }

    protected void applyPolygonModeLine(GL gl) {
        if (gl.isGL2()) {
            switch (this.polygonMode) {
                case FRONT: {
                    gl.getGL2().glPolygonMode(1028, 6913);
                    break;
                }
                case BACK: {
                    gl.getGL2().glPolygonMode(1029, 6913);
                    break;
                }
                case FRONT_AND_BACK: {
                    gl.getGL2().glPolygonMode(1032, 6913);
                    break;
                }
            }
        } else {
            switch (this.polygonMode) {
                case FRONT: {
                    GLES2CompatUtils.glPolygonMode(1028, 6913);
                    break;
                }
                case BACK: {
                    GLES2CompatUtils.glPolygonMode(1029, 6913);
                    break;
                }
                case FRONT_AND_BACK: {
                    GLES2CompatUtils.glPolygonMode(1032, 6913);
                    break;
                }
            }
        }
    }

    protected void applyPolygonModeFill(GL gl) {
        if (gl.isGL2()) {
            switch (this.polygonMode) {
                case FRONT: {
                    gl.getGL2().glPolygonMode(1028, 6914);
                    break;
                }
                case BACK: {
                    gl.getGL2().glPolygonMode(1029, 6914);
                    break;
                }
                case FRONT_AND_BACK: {
                    gl.getGL2().glPolygonMode(1032, 6914);
                    break;
                }
            }
        } else {
            switch (this.polygonMode) {
                case FRONT: {
                    GLES2CompatUtils.glPolygonMode(1028, 6914);
                    break;
                }
                case BACK: {
                    GLES2CompatUtils.glPolygonMode(1029, 6914);
                    break;
                }
                case FRONT_AND_BACK: {
                    GLES2CompatUtils.glPolygonMode(1032, 6914);
                    break;
                }
            }
        }
    }

    protected void polygonOffseFillEnable(GL gl) {
        gl.glEnable(32823);
        gl.glPolygonOffset(1.0f, 1.0f);
    }

    protected void polygonOffsetFillDisable(GL gl) {
        gl.glDisable(32823);
    }

    public static enum PolygonMode {
        FRONT,
        BACK,
        FRONT_AND_BACK;

    }
}

