/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.opengl.GL;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;

public class AxeLineAnnotation {
    protected Color color = Color.RED;
    protected float width = 3.0f;

    public void drawVerticalLineGLES2(Range yrange, float value) {
        GLES2CompatUtils.glBegin(3);
        GLES2CompatUtils.glLineWidth(this.width);
        GLES2CompatUtils.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        GLES2CompatUtils.glVertex3f(value, yrange.getMin(), 0.0f);
        GLES2CompatUtils.glVertex3f(value, yrange.getMax(), 0.0f);
        GLES2CompatUtils.glEnd();
    }

    public synchronized void drawVerticalLineGL2(GL gl, Range yrange, float value) {
        gl.getGL2().glLineWidth(this.width);
        gl.getGL2().glBegin(3);
        gl.getGL2().glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        gl.getGL2().glVertex3f(value, yrange.getMin() - yrange.getRange() / 30.0f, 0.0f);
        gl.getGL2().glVertex3f(value, yrange.getMax() + yrange.getRange() / 30.0f, 0.0f);
        gl.getGL2().glEnd();
    }

    public void drawHorizontalLineGLES2(Range xrange, float value) {
        GLES2CompatUtils.glBegin(3);
        GLES2CompatUtils.glLineWidth(this.width);
        GLES2CompatUtils.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        GLES2CompatUtils.glVertex3f(xrange.getMin(), value, 0.0f);
        GLES2CompatUtils.glVertex3f(xrange.getMax(), value, 0.0f);
        GLES2CompatUtils.glEnd();
    }

    public synchronized void drawHorizontalLineGL2(GL gl, Range xrange, float value) {
        gl.getGL2().glLineWidth(this.width);
        gl.getGL2().glBegin(3);
        gl.getGL2().glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        gl.getGL2().glVertex3f(xrange.getMin() - xrange.getRange() / 30.0f, value, 0.0f);
        gl.getGL2().glVertex3f(xrange.getMax() + xrange.getRange() / 30.0f, value, 0.0f);
        gl.getGL2().glEnd();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

