/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Vector3d;
import org.jzy3d.plot3d.primitives.axes.AxeAnnotation;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.primitives.axes.layout.AxeBoxLayout;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeBox
implements IAxe {
    protected static final int PRECISION = 6;
    protected View view;
    protected ITextRenderer txt = new TextBitmapRenderer();
    protected IAxeLayout layout;
    protected BoundingBox3d boxBounds;
    protected BoundingBox3d wholeBounds;
    protected Coord3d center;
    protected Coord3d scale;
    protected float xrange;
    protected float yrange;
    protected float zrange;
    protected float[][] quadx;
    protected float[][] quady;
    protected float[][] quadz;
    protected float[] normx;
    protected float[] normy;
    protected float[] normz;
    protected float[][] axeXx;
    protected float[][] axeXy;
    protected float[][] axeXz;
    protected float[][] axeYx;
    protected float[][] axeYy;
    protected float[][] axeYz;
    protected float[][] axeZx;
    protected float[][] axeZy;
    protected float[][] axeZz;
    protected int[][] axeXquads;
    protected int[][] axeYquads;
    protected int[][] axeZquads;
    protected boolean[] quadIsHidden;
    public static final int AXE_X = 0;
    public static final int AXE_Y = 1;
    public static final int AXE_Z = 2;
    protected List<AxeAnnotation> annotations = new ArrayList<AxeAnnotation>();
    protected SpaceTransformer spaceTransformer;

    public AxeBox(BoundingBox3d bbox) {
        this(bbox, new AxeBoxLayout());
    }

    public AxeBox(BoundingBox3d bbox, IAxeLayout layout) {
        this.layout = layout;
        if (bbox.valid()) {
            this.setAxe(bbox);
        } else {
            this.setAxe(new BoundingBox3d(-1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f));
        }
        this.wholeBounds = new BoundingBox3d();
        this.init();
    }

    @Override
    public List<AxeAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(List<AxeAnnotation> annotations) {
        this.annotations = annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(AxeAnnotation annotation) {
        List<AxeAnnotation> list = this.annotations;
        synchronized (list) {
            this.annotations.add(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(GL gl, GLU glu, Camera camera) {
        this.cullingEnable(gl);
        this.updateHiddenQuads(gl, camera);
        this.doTransform(gl);
        this.drawFace(gl);
        this.doTransform(gl);
        this.drawGrid(gl);
        List<AxeAnnotation> list = this.annotations;
        synchronized (list) {
            for (AxeAnnotation a : this.annotations) {
                a.draw(gl, this);
            }
        }
        this.doTransform(gl);
        this.drawTicksAndLabels(gl, glu, camera);
        this.cullingDisable(gl);
    }

    public void doTransform(GL gl) {
        if (gl.isGL2()) {
            gl.getGL2().glLoadIdentity();
            gl.getGL2().glScalef(this.scale.x, this.scale.y, this.scale.z);
        } else {
            GLES2CompatUtils.glLoadIdentity();
            GLES2CompatUtils.glScalef(this.scale.x, this.scale.y, this.scale.z);
        }
    }

    public void cullingDisable(GL gl) {
        gl.glDisable(2884);
    }

    public void cullingEnable(GL gl) {
        gl.glEnable(2884);
        gl.glFrontFace(2305);
        gl.glCullFace(1028);
    }

    public void drawFace(GL gl) {
        if (this.layout.isFaceDisplayed()) {
            Color quadcolor = this.layout.getQuadColor();
            if (gl.isGL2()) {
                gl.getGL2().glPolygonMode(1029, 6914);
                gl.getGL2().glColor4f(quadcolor.r, quadcolor.g, quadcolor.b, quadcolor.a);
            } else {
                GLES2CompatUtils.glPolygonMode(1029, 6914);
                GLES2CompatUtils.glColor4f(quadcolor.r, quadcolor.g, quadcolor.b, quadcolor.a);
            }
            gl.glLineWidth(1.0f);
            gl.glEnable(32823);
            gl.glPolygonOffset(1.0f, 1.0f);
            this.drawCube(gl, 7168);
            gl.glDisable(32823);
        }
    }

    public void drawGrid(GL gl) {
        Color gridcolor = this.layout.getGridColor();
        if (gl.isGL2()) {
            gl.getGL2().glPolygonMode(1029, 6913);
            gl.getGL2().glColor4f(gridcolor.r, gridcolor.g, gridcolor.b, gridcolor.a);
            gl.getGL2().glLineWidth(1.0f);
            this.drawCube(gl, 7168);
            gl.getGL2().glPolygonMode(1029, 6913);
            gl.getGL2().glColor4f(gridcolor.r, gridcolor.g, gridcolor.b, gridcolor.a);
            gl.getGL2().glLineWidth(1.0f);
            gl.getGL2().glLineStipple(1, (short)-21846);
        } else {
            GLES2CompatUtils.glPolygonMode(1029, 6913);
            GLES2CompatUtils.glColor4f(gridcolor.r, gridcolor.g, gridcolor.b, gridcolor.a);
            gl.glLineWidth(1.0f);
            this.drawCube(gl, 7168);
            GLES2CompatUtils.glPolygonMode(1029, 6913);
            GLES2CompatUtils.glColor4f(gridcolor.r, gridcolor.g, gridcolor.b, gridcolor.a);
            GLES2CompatUtils.glLineWidth(1.0f);
            GLES2CompatUtils.glLineStipple(1, (short)-21846);
        }
        gl.glEnable(2852);
        for (int quad = 0; quad < 6; ++quad) {
            if (this.quadIsHidden[quad]) continue;
            this.drawGridOnQuad(gl, quad);
        }
        gl.glDisable(2852);
    }

    public void drawTicksAndLabels(GL gl, GLU glu, Camera camera) {
        this.wholeBounds.reset();
        this.wholeBounds.add(this.boxBounds);
        this.drawTicksAndLabelsX(gl, glu, camera);
        this.drawTicksAndLabelsY(gl, glu, camera);
        this.drawTicksAndLabelsZ(gl, glu, camera);
    }

    public void drawTicksAndLabelsX(GL gl, GLU glu, Camera camera) {
        if (this.xrange > 0.0f && this.layout.isXTickLabelDisplayed()) {
            if (this.view != null && this.view.getViewMode().equals((Object)ViewPositionMode.TOP)) {
                BoundingBox3d bbox = this.drawTicks(gl, glu, camera, 1, 0, this.layout.getXTickColor(), Halign.LEFT, Valign.TOP);
                this.wholeBounds.add(bbox);
            } else {
                int xselect = this.findClosestXaxe(camera);
                if (xselect >= 0) {
                    BoundingBox3d bbox = this.drawTicks(gl, glu, camera, xselect, 0, this.layout.getXTickColor());
                    this.wholeBounds.add(bbox);
                } else {
                    BoundingBox3d bbox = this.drawTicks(gl, glu, camera, 2, 0, this.layout.getXTickColor(), Halign.CENTER, Valign.TOP);
                    this.wholeBounds.add(bbox);
                }
            }
        }
    }

    public void drawTicksAndLabelsY(GL gl, GLU glu, Camera camera) {
        if (this.yrange > 0.0f && this.layout.isYTickLabelDisplayed()) {
            if (this.view != null && this.view.getViewMode().equals((Object)ViewPositionMode.TOP)) {
                BoundingBox3d bbox = this.drawTicks(gl, glu, camera, 2, 1, this.layout.getYTickColor(), Halign.LEFT, Valign.GROUND);
                this.wholeBounds.add(bbox);
            } else {
                int yselect = this.findClosestYaxe(camera);
                if (yselect >= 0) {
                    BoundingBox3d bbox = this.drawTicks(gl, glu, camera, yselect, 1, this.layout.getYTickColor());
                    this.wholeBounds.add(bbox);
                } else {
                    BoundingBox3d bbox = this.drawTicks(gl, glu, camera, 1, 1, this.layout.getYTickColor(), Halign.RIGHT, Valign.GROUND);
                    this.wholeBounds.add(bbox);
                }
            }
        }
    }

    public void drawTicksAndLabelsZ(GL gl, GLU glu, Camera camera) {
        int zselect;
        if (this.zrange > 0.0f && this.layout.isZTickLabelDisplayed() && (this.view == null || !this.view.getViewMode().equals((Object)ViewPositionMode.TOP)) && (zselect = this.findClosestZaxe(camera)) >= 0) {
            BoundingBox3d bbox = this.drawTicks(gl, glu, camera, zselect, 2, this.layout.getZTickColor());
            this.wholeBounds.add(bbox);
        }
    }

    protected void drawCube(GL gl, int mode) {
        for (int q = 0; q < 6; ++q) {
            Coord3d quadCoord;
            int v;
            if (gl.isGL2()) {
                if (mode == 7169) {
                    gl.getGL2().glPassThrough((float)q);
                }
                gl.getGL2().glBegin(7);
                for (v = 0; v < 4; ++v) {
                    quadCoord = new Coord3d(this.quadx[q][v], this.quady[q][v], this.quadz[q][v]);
                    this.vertexGL2(gl, quadCoord);
                }
                gl.getGL2().glEnd();
                continue;
            }
            if (mode == 7169) {
                GLES2CompatUtils.glPassThrough(q);
            }
            GLES2CompatUtils.glBegin(7);
            for (v = 0; v < 4; ++v) {
                quadCoord = new Coord3d(this.quadx[q][v], this.quady[q][v], this.quadz[q][v]);
                this.vertexGLES2(quadCoord);
            }
            GLES2CompatUtils.glEnd();
        }
    }

    protected void drawGridOnQuad(GL gl, int quad) {
        Coord3d quadCoord;
        int t;
        if (quad != 0 && quad != 1) {
            double[] xticks = this.layout.getXTicks();
            for (t = 0; t < xticks.length; ++t) {
                if (!gl.isGL2()) continue;
                gl.getGL2().glBegin(1);
                quadCoord = new Coord3d(xticks[t], (double)this.quady[quad][0], (double)this.quadz[quad][0]);
                this.vertexGL2(gl, quadCoord);
                quadCoord = new Coord3d(xticks[t], (double)this.quady[quad][2], (double)this.quadz[quad][2]);
                this.vertexGL2(gl, quadCoord);
                gl.getGL2().glEnd();
            }
        }
        if (quad != 2 && quad != 3) {
            double[] yticks = this.layout.getYTicks();
            for (t = 0; t < yticks.length; ++t) {
                if (!gl.isGL2()) continue;
                gl.getGL2().glBegin(1);
                quadCoord = new Coord3d((double)this.quadx[quad][0], yticks[t], (double)this.quadz[quad][0]);
                this.vertexGL2(gl, quadCoord);
                quadCoord = new Coord3d((double)this.quadx[quad][2], yticks[t], (double)this.quadz[quad][2]);
                this.vertexGL2(gl, quadCoord);
                gl.getGL2().glEnd();
            }
        }
        if (quad != 4 && quad != 5) {
            double[] zticks = this.layout.getZTicks();
            for (t = 0; t < zticks.length; ++t) {
                if (!gl.isGL2()) continue;
                gl.getGL2().glBegin(1);
                quadCoord = new Coord3d((double)this.quadx[quad][0], (double)this.quady[quad][0], zticks[t]);
                this.vertexGL2(gl, quadCoord);
                quadCoord = new Coord3d((double)this.quadx[quad][2], (double)this.quady[quad][2], zticks[t]);
                this.vertexGL2(gl, quadCoord);
                gl.getGL2().glEnd();
            }
        }
    }

    protected BoundingBox3d drawTicks(GL gl, GLU glu, Camera cam, int axis, int direction, Color color) {
        return this.drawTicks(gl, glu, cam, axis, direction, color, null, null);
    }

    protected BoundingBox3d drawTicks(GL gl, GLU glu, Camera cam, int axis, int direction, Color color, Halign hal, Valign val) {
        String axeLabel;
        double zlab;
        double ylab;
        double xlab;
        int quad_1;
        int quad_0;
        float tickLength = 20.0f;
        float axeLabelDist = 2.5f;
        BoundingBox3d ticksTxtBounds = new BoundingBox3d();
        if (this.isX(direction)) {
            quad_0 = this.axeXquads[axis][0];
            quad_1 = this.axeXquads[axis][1];
        } else if (this.isY(direction)) {
            quad_0 = this.axeYquads[axis][0];
            quad_1 = this.axeYquads[axis][1];
        } else {
            quad_0 = this.axeZquads[axis][0];
            quad_1 = this.axeZquads[axis][1];
        }
        double xpos = 0.0;
        double ypos = 0.0;
        double zpos = 0.0;
        if (this.spaceTransformer == null) {
            xpos = this.normx[quad_0] + this.normx[quad_1];
            ypos = this.normy[quad_0] + this.normy[quad_1];
            zpos = this.normz[quad_0] + this.normz[quad_1];
        } else {
            xpos = this.spaceTransformer.getX().compute(this.normx[quad_0]) + this.spaceTransformer.getX().compute(this.normx[quad_1]);
            ypos = this.spaceTransformer.getY().compute(this.normy[quad_0]) + this.spaceTransformer.getY().compute(this.normy[quad_1]);
            zpos = this.spaceTransformer.getZ().compute(this.normz[quad_0]) + this.spaceTransformer.getZ().compute(this.normz[quad_1]);
        }
        float xdir = this.normx[quad_0] + this.normx[quad_1] - this.center.x;
        float ydir = this.normy[quad_0] + this.normy[quad_1] - this.center.y;
        float zdir = this.normz[quad_0] + this.normz[quad_1] - this.center.z;
        xdir = xdir == 0.0f ? 0.0f : xdir / Math.abs(xdir);
        ydir = ydir == 0.0f ? 0.0f : ydir / Math.abs(ydir);
        zdir = zdir == 0.0f ? 0.0f : zdir / Math.abs(zdir);
        boolean dist = true;
        if (this.isX(direction)) {
            xlab = this.center.x;
            ylab = (double)(axeLabelDist * (this.yrange / tickLength) * (float)dist * ydir) + ypos;
            zlab = (double)(axeLabelDist * (this.zrange / tickLength) * (float)dist * zdir) + zpos;
            axeLabel = this.layout.getXAxeLabel();
        } else if (this.isY(direction)) {
            xlab = (double)(axeLabelDist * (this.xrange / tickLength) * (float)dist * xdir) + xpos;
            ylab = this.center.y;
            zlab = (double)(axeLabelDist * (this.zrange / tickLength) * (float)dist * zdir) + zpos;
            axeLabel = this.layout.getYAxeLabel();
        } else {
            xlab = (double)(axeLabelDist * (this.xrange / tickLength) * (float)dist * xdir) + xpos;
            ylab = (double)(axeLabelDist * (this.yrange / tickLength) * (float)dist * ydir) + ypos;
            zlab = this.center.z;
            axeLabel = this.layout.getZAxeLabel();
        }
        this.drawAxisLabel(gl, glu, cam, direction, color, ticksTxtBounds, xlab, ylab, zlab, axeLabel);
        this.drawAxisTicks(gl, glu, cam, direction, color, hal, val, tickLength, ticksTxtBounds, xpos, ypos, zpos, xdir, ydir, zdir, this.getAxisTicks(direction));
        return ticksTxtBounds;
    }

    public void drawAxisLabel(GL gl, GLU glu, Camera cam, int direction, Color color, BoundingBox3d ticksTxtBounds, double xlab, double ylab, double zlab, String axeLabel) {
        Coord3d labelPosition;
        BoundingBox3d labelBounds;
        if ((this.isXDisplayed(direction) || this.isYDisplayed(direction) || this.isZDisplayed(direction)) && (labelBounds = this.txt.drawText(gl, glu, cam, axeLabel, labelPosition = new Coord3d(xlab, ylab, zlab), Halign.CENTER, Valign.CENTER, color)) != null) {
            ticksTxtBounds.add(labelBounds);
        }
    }

    public boolean isZDisplayed(int direction) {
        return this.isZ(direction) && this.layout.isZAxeLabelDisplayed();
    }

    public boolean isYDisplayed(int direction) {
        return this.isY(direction) && this.layout.isYAxeLabelDisplayed();
    }

    public boolean isXDisplayed(int direction) {
        return this.isX(direction) && this.layout.isXAxeLabelDisplayed();
    }

    public boolean isZ(int direction) {
        return direction == 2;
    }

    public boolean isY(int direction) {
        return direction == 1;
    }

    public boolean isX(int direction) {
        return direction == 0;
    }

    public double[] getAxisTicks(int direction) {
        double[] ticks = this.isX(direction) ? this.layout.getXTicks() : (this.isY(direction) ? this.layout.getYTicks() : this.layout.getZTicks());
        return ticks;
    }

    public void drawAxisTicks(GL gl, GLU glu, Camera cam, int direction, Color color, Halign hal, Valign val, float tickLength, BoundingBox3d ticksTxtBounds, double xpos, double ypos, double zpos, float xdir, float ydir, float zdir, double[] ticks) {
        String tickLabel = "";
        for (int t = 0; t < ticks.length; ++t) {
            double zlab;
            double ylab;
            double xlab;
            if (this.spaceTransformer == null) {
                if (this.isX(direction)) {
                    xlab = xpos = ticks[t];
                    ylab = (double)(this.yrange / tickLength * ydir) + ypos;
                    zlab = (double)(this.zrange / tickLength * zdir) + zpos;
                    tickLabel = this.layout.getXTickRenderer().format(xpos);
                } else if (this.isY(direction)) {
                    ypos = ticks[t];
                    xlab = (double)(this.xrange / tickLength * xdir) + xpos;
                    ylab = ypos;
                    zlab = (double)(this.zrange / tickLength * zdir) + zpos;
                    tickLabel = this.layout.getYTickRenderer().format(ypos);
                } else {
                    zpos = ticks[t];
                    xlab = (double)(this.xrange / tickLength * xdir) + xpos;
                    ylab = (double)(this.yrange / tickLength * ydir) + ypos;
                    zlab = zpos;
                    tickLabel = this.layout.getZTickRenderer().format(zpos);
                }
            } else if (this.isX(direction)) {
                xlab = xpos = (double)this.spaceTransformer.getX().compute((float)ticks[t]);
                ylab = (double)(Math.signum(tickLength * ydir) * (this.yrange / this.spaceTransformer.getY().compute(Math.abs(tickLength))) * this.spaceTransformer.getY().compute(Math.abs(ydir))) + ypos;
                zlab = (double)(Math.signum(tickLength * ydir) * (this.zrange / this.spaceTransformer.getZ().compute(Math.abs(tickLength))) * this.spaceTransformer.getZ().compute(Math.abs(zdir))) + zpos;
                tickLabel = this.layout.getXTickRenderer().format(xpos);
            } else if (this.isY(direction)) {
                ypos = this.spaceTransformer.getY().compute((float)ticks[t]);
                xlab = (double)(Math.signum(tickLength * xdir) * (this.xrange / this.spaceTransformer.getX().compute(Math.abs(tickLength))) * this.spaceTransformer.getX().compute(Math.abs(xdir))) + xpos;
                ylab = ypos;
                zlab = (double)(Math.signum(tickLength * zdir) * (this.zrange / this.spaceTransformer.getZ().compute(Math.abs(tickLength))) * this.spaceTransformer.getZ().compute(Math.abs(zdir))) + zpos;
                tickLabel = this.layout.getYTickRenderer().format(ypos);
            } else {
                zpos = this.spaceTransformer.getZ().compute((float)ticks[t]);
                xlab = (double)(Math.signum(tickLength * xdir) * (this.xrange / this.spaceTransformer.getX().compute(Math.abs(tickLength))) * this.spaceTransformer.getX().compute(Math.abs(xdir))) + xpos;
                ylab = (double)(Math.signum(tickLength * ydir) * (this.yrange / this.spaceTransformer.getY().compute(Math.abs(tickLength))) * this.spaceTransformer.getY().compute(Math.abs(ydir))) + ypos;
                zlab = zpos;
                tickLabel = this.layout.getZTickRenderer().format(zpos);
            }
            Coord3d tickPosition = new Coord3d(xlab, ylab, zlab);
            if (this.layout.isTickLineDisplayed() && gl.isGL2()) {
                this.drawTickLine(gl, color, xpos, ypos, zpos, xlab, ylab, zlab);
            }
            Halign hAlign = this.layoutHorizontal(direction, cam, hal, tickPosition);
            Valign vAlign = this.layoutVertical(direction, val, zdir);
            this.drawAxisTickNumericLabel(gl, glu, direction, cam, color, hAlign, vAlign, ticksTxtBounds, tickLabel, tickPosition);
        }
    }

    public void drawAxisTickNumericLabel(GL gl, GLU glu, int direction, Camera cam, Color color, Halign hAlign, Valign vAlign, BoundingBox3d ticksTxtBounds, String tickLabel, Coord3d tickPosition) {
        if (gl.isGL2()) {
            gl.getGL2().glLoadIdentity();
            gl.getGL2().glScalef(this.scale.x, this.scale.y, this.scale.z);
        } else {
            GLES2CompatUtils.glLoadIdentity();
            GLES2CompatUtils.glScalef(this.scale.x, this.scale.y, this.scale.z);
        }
        BoundingBox3d tickBounds = this.txt.drawText(gl, glu, cam, tickLabel, tickPosition, hAlign, vAlign, color);
        if (tickBounds != null) {
            ticksTxtBounds.add(tickBounds);
        }
    }

    public Valign layoutVertical(int direction, Valign val, float zdir) {
        Valign vAlign = val == null ? (this.isZ(direction) ? Valign.CENTER : (zdir > 0.0f ? Valign.TOP : Valign.BOTTOM)) : val;
        return vAlign;
    }

    public Halign layoutHorizontal(int direction, Camera cam, Halign hal, Coord3d tickPosition) {
        Halign hAlign = hal == null ? (cam.side(tickPosition) ? Halign.LEFT : Halign.RIGHT) : hal;
        return hAlign;
    }

    public void drawTickLine(GL gl, Color color, double xpos, double ypos, double zpos, double xlab, double ylab, double zlab) {
        gl.getGL2().glColor3f(color.r, color.g, color.b);
        gl.getGL2().glLineWidth(1.0f);
        gl.getGL2().glBegin(1);
        gl.getGL2().glVertex3d(xpos, ypos, zpos);
        gl.getGL2().glVertex3d(xlab, ylab, zlab);
        gl.getGL2().glEnd();
    }

    protected void vertexGL2(GL gl, Coord3d c) {
        if (this.spaceTransformer == null) {
            gl.getGL2().glVertex3f(c.x, c.y, c.z);
        } else {
            gl.getGL2().glVertex3f(this.spaceTransformer.getX().compute(c.x), this.spaceTransformer.getY().compute(c.y), this.spaceTransformer.getZ().compute(c.z));
        }
    }

    protected void vertexGLES2(Coord3d c) {
        if (this.spaceTransformer == null) {
            GLES2CompatUtils.glVertex3f(c.x, c.y, c.z);
        } else {
            GLES2CompatUtils.glVertex3f(this.spaceTransformer.getX().compute(c.x), this.spaceTransformer.getY().compute(c.y), this.spaceTransformer.getZ().compute(c.z));
        }
    }

    protected int findClosestXaxe(Camera cam) {
        int a;
        int na = 4;
        double[] distAxeX = new double[na];
        for (a = 0; a < na; ++a) {
            distAxeX[a] = this.quadIsHidden[this.axeXquads[a][0]] ^ this.quadIsHidden[this.axeXquads[a][1]] ? new Vector3d(this.axeXx[a][0], this.axeXy[a][0], this.axeXz[a][0], this.axeXx[a][1], this.axeXy[a][1], this.axeXz[a][1]).distance(cam.getEye()) : Double.MAX_VALUE;
        }
        for (a = 0; a < na; ++a) {
            if (!(distAxeX[a] < Double.MAX_VALUE) || !(this.center.z > (this.axeXz[a][0] + this.axeXz[a][1]) / 2.0f)) continue;
            int n = a;
            distAxeX[n] = distAxeX[n] * -1.0;
        }
        return this.min(distAxeX);
    }

    protected int findClosestYaxe(Camera cam) {
        int a;
        int na = 4;
        double[] distAxeY = new double[na];
        for (a = 0; a < na; ++a) {
            distAxeY[a] = this.quadIsHidden[this.axeYquads[a][0]] ^ this.quadIsHidden[this.axeYquads[a][1]] ? new Vector3d(this.axeYx[a][0], this.axeYy[a][0], this.axeYz[a][0], this.axeYx[a][1], this.axeYy[a][1], this.axeYz[a][1]).distance(cam.getEye()) : Double.MAX_VALUE;
        }
        for (a = 0; a < na; ++a) {
            if (!(distAxeY[a] < Double.MAX_VALUE) || !(this.center.z > (this.axeYz[a][0] + this.axeYz[a][1]) / 2.0f)) continue;
            int n = a;
            distAxeY[n] = distAxeY[n] * -1.0;
        }
        return this.min(distAxeY);
    }

    protected int findClosestZaxe(Camera cam) {
        int a;
        int na = 4;
        double[] distAxeZ = new double[na];
        for (a = 0; a < na; ++a) {
            distAxeZ[a] = this.quadIsHidden[this.axeZquads[a][0]] ^ this.quadIsHidden[this.axeZquads[a][1]] ? new Vector3d(this.axeZx[a][0], this.axeZy[a][0], this.axeZz[a][0], this.axeZx[a][1], this.axeZy[a][1], this.axeZz[a][1]).distance(cam.getEye()) : Double.MAX_VALUE;
        }
        for (a = 0; a < na; ++a) {
            Coord3d axeCenter;
            if (!(distAxeZ[a] < Double.MAX_VALUE) || cam.side(axeCenter = new Coord3d((this.axeZx[a][0] + this.axeZx[a][1]) / 2.0f, (this.axeZy[a][0] + this.axeZy[a][1]) / 2.0f, (this.axeZz[a][0] + this.axeZz[a][1]) / 2.0f))) continue;
            int n = a;
            distAxeZ[n] = distAxeZ[n] * -1.0;
        }
        return this.min(distAxeZ);
    }

    protected int min(double[] values) {
        double minv = Double.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < minv)) continue;
            minv = values[i];
            index = i;
        }
        return index;
    }

    public void updateHiddenQuads(GL gl, Camera camera) {
        this.quadIsHidden = this.getHiddenQuads(gl, camera);
    }

    protected boolean[] getHiddenQuads(GL gl, Camera cam) {
        boolean[] status = new boolean[6];
        Coord3d se = cam.getEye().div(this.scale);
        if (se.x <= this.center.x) {
            status[0] = false;
            status[1] = true;
        } else {
            status[0] = true;
            status[1] = false;
        }
        if (se.y <= this.center.y) {
            status[2] = false;
            status[3] = true;
        } else {
            status[2] = true;
            status[3] = false;
        }
        if (se.z <= this.center.z) {
            status[4] = false;
            status[5] = true;
        } else {
            status[4] = true;
            status[5] = false;
        }
        return status;
    }

    protected int print3DcolorVertex(int size, int count, float[] buffer) {
        int id = size - count;
        int veclength = 7;
        System.out.print("  [" + id + "]");
        for (int i = 0; i < veclength; ++i) {
            System.out.print(" " + buffer[size - count]);
            --count;
        }
        System.out.println();
        return count;
    }

    protected void printHiddenQuads() {
        for (int t = 0; t < this.quadIsHidden.length; ++t) {
            if (this.quadIsHidden[t]) {
                System.out.println("Quad[" + t + "] is not displayed");
                continue;
            }
            System.out.println("Quad[" + t + "] is displayed");
        }
    }

    protected void setAxeBox(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        this.center = new Coord3d((xmax + xmin) / 2.0f, (ymax + ymin) / 2.0f, (zmax + zmin) / 2.0f);
        this.xrange = xmax - xmin;
        this.yrange = ymax - ymin;
        this.zrange = zmax - zmin;
        this.quadx = new float[6][4];
        this.quady = new float[6][4];
        this.quadz = new float[6][4];
        this.quadx[0][0] = xmax;
        this.quady[0][0] = ymin;
        this.quadz[0][0] = zmax;
        this.quadx[0][1] = xmax;
        this.quady[0][1] = ymin;
        this.quadz[0][1] = zmin;
        this.quadx[0][2] = xmax;
        this.quady[0][2] = ymax;
        this.quadz[0][2] = zmin;
        this.quadx[0][3] = xmax;
        this.quady[0][3] = ymax;
        this.quadz[0][3] = zmax;
        this.quadx[1][0] = xmin;
        this.quady[1][0] = ymax;
        this.quadz[1][0] = zmax;
        this.quadx[1][1] = xmin;
        this.quady[1][1] = ymax;
        this.quadz[1][1] = zmin;
        this.quadx[1][2] = xmin;
        this.quady[1][2] = ymin;
        this.quadz[1][2] = zmin;
        this.quadx[1][3] = xmin;
        this.quady[1][3] = ymin;
        this.quadz[1][3] = zmax;
        this.quadx[2][0] = xmax;
        this.quady[2][0] = ymax;
        this.quadz[2][0] = zmax;
        this.quadx[2][1] = xmax;
        this.quady[2][1] = ymax;
        this.quadz[2][1] = zmin;
        this.quadx[2][2] = xmin;
        this.quady[2][2] = ymax;
        this.quadz[2][2] = zmin;
        this.quadx[2][3] = xmin;
        this.quady[2][3] = ymax;
        this.quadz[2][3] = zmax;
        this.quadx[3][0] = xmin;
        this.quady[3][0] = ymin;
        this.quadz[3][0] = zmax;
        this.quadx[3][1] = xmin;
        this.quady[3][1] = ymin;
        this.quadz[3][1] = zmin;
        this.quadx[3][2] = xmax;
        this.quady[3][2] = ymin;
        this.quadz[3][2] = zmin;
        this.quadx[3][3] = xmax;
        this.quady[3][3] = ymin;
        this.quadz[3][3] = zmax;
        this.quadx[4][0] = xmin;
        this.quady[4][0] = ymin;
        this.quadz[4][0] = zmax;
        this.quadx[4][1] = xmax;
        this.quady[4][1] = ymin;
        this.quadz[4][1] = zmax;
        this.quadx[4][2] = xmax;
        this.quady[4][2] = ymax;
        this.quadz[4][2] = zmax;
        this.quadx[4][3] = xmin;
        this.quady[4][3] = ymax;
        this.quadz[4][3] = zmax;
        this.quadx[5][0] = xmax;
        this.quady[5][0] = ymin;
        this.quadz[5][0] = zmin;
        this.quadx[5][1] = xmin;
        this.quady[5][1] = ymin;
        this.quadz[5][1] = zmin;
        this.quadx[5][2] = xmin;
        this.quady[5][2] = ymax;
        this.quadz[5][2] = zmin;
        this.quadx[5][3] = xmax;
        this.quady[5][3] = ymax;
        this.quadz[5][3] = zmin;
        this.normx = new float[6];
        this.normy = new float[6];
        this.normz = new float[6];
        this.normx[0] = xmax;
        this.normy[0] = 0.0f;
        this.normz[0] = 0.0f;
        this.normx[1] = xmin;
        this.normy[1] = 0.0f;
        this.normz[1] = 0.0f;
        this.normx[2] = 0.0f;
        this.normy[2] = ymax;
        this.normz[2] = 0.0f;
        this.normx[3] = 0.0f;
        this.normy[3] = ymin;
        this.normz[3] = 0.0f;
        this.normx[4] = 0.0f;
        this.normy[4] = 0.0f;
        this.normz[4] = zmax;
        this.normx[5] = 0.0f;
        this.normy[5] = 0.0f;
        this.normz[5] = zmin;
        int na = 4;
        int np = 2;
        int nq = 2;
        this.axeXquads = new int[na][nq];
        this.axeYquads = new int[na][nq];
        this.axeZquads = new int[na][nq];
        int i = 0;
        this.axeXquads[i][0] = 4;
        this.axeXquads[i][1] = 3;
        i = 1;
        this.axeXquads[i][0] = 3;
        this.axeXquads[i][1] = 5;
        i = 2;
        this.axeXquads[i][0] = 5;
        this.axeXquads[i][1] = 2;
        i = 3;
        this.axeXquads[i][0] = 2;
        this.axeXquads[i][1] = 4;
        i = 0;
        this.axeYquads[i][0] = 4;
        this.axeYquads[i][1] = 0;
        i = 1;
        this.axeYquads[i][0] = 0;
        this.axeYquads[i][1] = 5;
        i = 2;
        this.axeYquads[i][0] = 5;
        this.axeYquads[i][1] = 1;
        i = 3;
        this.axeYquads[i][0] = 1;
        this.axeYquads[i][1] = 4;
        i = 0;
        this.axeZquads[i][0] = 3;
        this.axeZquads[i][1] = 0;
        i = 1;
        this.axeZquads[i][0] = 0;
        this.axeZquads[i][1] = 2;
        i = 2;
        this.axeZquads[i][0] = 2;
        this.axeZquads[i][1] = 1;
        i = 3;
        this.axeZquads[i][0] = 1;
        this.axeZquads[i][1] = 3;
        this.axeXx = new float[na][np];
        this.axeXy = new float[na][np];
        this.axeXz = new float[na][np];
        this.axeYx = new float[na][np];
        this.axeYy = new float[na][np];
        this.axeYz = new float[na][np];
        this.axeZx = new float[na][np];
        this.axeZy = new float[na][np];
        this.axeZz = new float[na][np];
        i = 0;
        this.axeXx[i][0] = xmin;
        this.axeXy[i][0] = ymin;
        this.axeXz[i][0] = zmax;
        this.axeXx[i][1] = xmax;
        this.axeXy[i][1] = ymin;
        this.axeXz[i][1] = zmax;
        i = 1;
        this.axeXx[i][0] = xmin;
        this.axeXy[i][0] = ymin;
        this.axeXz[i][0] = zmin;
        this.axeXx[i][1] = xmax;
        this.axeXy[i][1] = ymin;
        this.axeXz[i][1] = zmin;
        i = 2;
        this.axeXx[i][0] = xmin;
        this.axeXy[i][0] = ymax;
        this.axeXz[i][0] = zmin;
        this.axeXx[i][1] = xmax;
        this.axeXy[i][1] = ymax;
        this.axeXz[i][1] = zmin;
        i = 3;
        this.axeXx[i][0] = xmin;
        this.axeXy[i][0] = ymax;
        this.axeXz[i][0] = zmax;
        this.axeXx[i][1] = xmax;
        this.axeXy[i][1] = ymax;
        this.axeXz[i][1] = zmax;
        i = 0;
        this.axeYx[i][0] = xmax;
        this.axeYy[i][0] = ymin;
        this.axeYz[i][0] = zmax;
        this.axeYx[i][1] = xmax;
        this.axeYy[i][1] = ymax;
        this.axeYz[i][1] = zmax;
        i = 1;
        this.axeYx[i][0] = xmax;
        this.axeYy[i][0] = ymin;
        this.axeYz[i][0] = zmin;
        this.axeYx[i][1] = xmax;
        this.axeYy[i][1] = ymax;
        this.axeYz[i][1] = zmin;
        i = 2;
        this.axeYx[i][0] = xmin;
        this.axeYy[i][0] = ymin;
        this.axeYz[i][0] = zmin;
        this.axeYx[i][1] = xmin;
        this.axeYy[i][1] = ymax;
        this.axeYz[i][1] = zmin;
        i = 3;
        this.axeYx[i][0] = xmin;
        this.axeYy[i][0] = ymin;
        this.axeYz[i][0] = zmax;
        this.axeYx[i][1] = xmin;
        this.axeYy[i][1] = ymax;
        this.axeYz[i][1] = zmax;
        i = 0;
        this.axeZx[i][0] = xmax;
        this.axeZy[i][0] = ymin;
        this.axeZz[i][0] = zmin;
        this.axeZx[i][1] = xmax;
        this.axeZy[i][1] = ymin;
        this.axeZz[i][1] = zmax;
        i = 1;
        this.axeZx[i][0] = xmax;
        this.axeZy[i][0] = ymax;
        this.axeZz[i][0] = zmin;
        this.axeZx[i][1] = xmax;
        this.axeZy[i][1] = ymax;
        this.axeZz[i][1] = zmax;
        i = 2;
        this.axeZx[i][0] = xmin;
        this.axeZy[i][0] = ymax;
        this.axeZz[i][0] = zmin;
        this.axeZx[i][1] = xmin;
        this.axeZy[i][1] = ymax;
        this.axeZz[i][1] = zmax;
        i = 3;
        this.axeZx[i][0] = xmin;
        this.axeZy[i][0] = ymin;
        this.axeZz[i][0] = zmin;
        this.axeZx[i][1] = xmin;
        this.axeZy[i][1] = ymin;
        this.axeZz[i][1] = zmax;
        this.layout.getXTicks(xmin, xmax);
        this.layout.getYTicks(ymin, ymax);
        this.layout.getZTicks(zmin, zmax);
    }

    protected void init() {
        this.setScale(new Coord3d(1.0f, 1.0f, 1.0f));
    }

    @Override
    public void dispose() {
    }

    public ITextRenderer getTextRenderer() {
        return this.txt;
    }

    public void setTextRenderer(ITextRenderer renderer) {
        this.txt = renderer;
    }

    public View getView() {
        return this.view;
    }

    @Override
    public BoundingBox3d getBoxBounds() {
        return this.boxBounds;
    }

    @Override
    public IAxeLayout getLayout() {
        return this.layout;
    }

    @Override
    public SpaceTransformer getSpaceTransformer() {
        return this.spaceTransformer;
    }

    @Override
    public void setSpaceTransformer(SpaceTransformer spaceTransformer) {
        this.spaceTransformer = spaceTransformer;
    }

    public void setView(View view) {
        this.view = view;
    }

    @Override
    public void setAxe(BoundingBox3d bbox) {
        this.boxBounds = bbox;
        this.setAxeBox(bbox.getXmin(), bbox.getXmax(), bbox.getYmin(), bbox.getYmax(), bbox.getZmin(), bbox.getZmax());
    }

    public BoundingBox3d getWholeBounds() {
        return this.wholeBounds;
    }

    @Override
    public Coord3d getCenter() {
        return this.center;
    }

    @Override
    public void setScale(Coord3d scale) {
        this.scale = scale;
    }

    @Override
    public Coord3d getScale() {
        return this.scale;
    }
}

