/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.LightPoint;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class ScatterPoint
extends AbstractDrawable
implements ISingleColorable {
    public List<LightPoint> points;
    public float width;

    public ScatterPoint() {
        this.bbox = new BoundingBox3d();
        this.setWidth(1.0f);
        this.setPoints(new ArrayList<LightPoint>());
    }

    public ScatterPoint(List<LightPoint> points, float width) {
        this.bbox = new BoundingBox3d();
        this.setPoints(points);
        this.setWidth(width);
    }

    public void clear() {
        this.points.clear();
        this.bbox.reset();
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            this.drawGL2(gl);
        } else {
            this.drawGLES2();
        }
        this.doDrawBounds(gl, glu, cam);
    }

    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.points != null) {
            for (LightPoint p : this.points) {
                GLES2CompatUtils.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                GLES2CompatUtils.glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        }
        GLES2CompatUtils.glEnd();
    }

    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.points != null) {
            for (LightPoint p : this.points) {
                gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                gl.getGL2().glVertex3f(p.xyz.x, p.xyz.y, p.xyz.z);
            }
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        for (LightPoint p : this.points) {
            Coord3d c = p.xyz;
            c.set(transform.compute(c));
        }
        this.updateBounds();
    }

    public void add(LightPoint point) {
        this.points.add(point);
        this.updateBounds();
    }

    public void setPoints(List<LightPoint> points) {
        this.points = points;
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        for (LightPoint c : this.points) {
            this.bbox.add(c.xyz);
        }
    }

    public List<LightPoint> getData() {
        return this.points;
    }

    @Override
    public void setColor(Color color) {
    }

    @Override
    public Color getColor() {
        return null;
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

