/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.Quad;

public class Cylinder
extends AbstractComposite {
    protected float height;
    protected float radius;
    protected Polygon top;
    protected Polygon low;

    public void setData(Coord3d position, float height, float radius, int slices, int rings, Color color) {
        this.height = height;
        this.radius = radius;
        this.top = new Polygon();
        this.low = new Polygon();
        for (int i = 0; i < slices; ++i) {
            float angleBorder1 = (float)i * 2.0f * (float)Math.PI / (float)slices;
            float angleBorder2 = (float)(i + 1) * 2.0f * (float)Math.PI / (float)slices;
            Coord2d border1 = new Coord2d(angleBorder1, radius).cartesian();
            Coord2d border2 = new Coord2d(angleBorder2, radius).cartesian();
            Quad face = new Quad();
            face.add(new Point(new Coord3d(position.x + border1.x, position.y + border1.y, position.z)));
            face.add(new Point(new Coord3d(position.x + border1.x, position.y + border1.y, position.z + height)));
            face.add(new Point(new Coord3d(position.x + border2.x, position.y + border2.y, position.z + height)));
            face.add(new Point(new Coord3d(position.x + border2.x, position.y + border2.y, position.z)));
            face.setColor(color);
            face.setWireframeDisplayed(false);
            this.add(face);
            this.low.add(new Point(new Coord3d(position.x + border1.x, position.y + border1.y, position.z)));
            this.top.add(new Point(new Coord3d(position.x + border1.x, position.y + border1.y, position.z + height)));
        }
        this.low.setColor(color);
        this.top.setColor(color);
        this.add(this.top);
        this.add(this.low);
    }
}

