/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.concrete;

import java.awt.image.BufferedImage;
import org.jzy3d.maths.Rectangle;
import org.jzy3d.plot3d.builder.Mapper;

public class BufferedImageMapper
extends Mapper {
    private final BufferedImage image;
    private final int maxRow;
    private final Rectangle maxViewPort;

    public BufferedImageMapper(BufferedImage bi) {
        this.image = bi;
        this.maxRow = this.image.getHeight() - 1;
        this.maxViewPort = new Rectangle(0, 0, bi.getWidth(), bi.getHeight());
    }

    public Rectangle getClippedViewport(Rectangle roi) {
        return this.maxViewPort.intersection(roi);
    }

    @Override
    public double f(double x, double y) {
        if (x == Double.NaN || y == Double.NaN) {
            return Double.NaN;
        }
        int rbg = this.image.getRGB((int)x, this.maxRow - (int)y);
        float red = (float)(rbg >> 16 & 0xFF) / 255.0f;
        float green = (float)(rbg >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rbg & 0xFF) / 255.0f;
        return red * 0.3f + green * 0.59f + blue * 0.11f;
    }
}

