/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot2d.primitives;

import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.ColorMapRedAndGreen;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot2d.primitives.Serie2d;
import org.jzy3d.plot3d.pipelines.NotImplementedException;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.ConcurrentScatterMultiColorList;
import org.jzy3d.plot3d.primitives.ScatterMultiColorList;

public class ScatterSerie2d
implements Serie2d {
    protected ScatterMultiColorList scatter;
    protected String name;

    public ScatterSerie2d(String name) {
        this.name = name;
        this.scatter = this.makeDrawable();
    }

    protected ScatterMultiColorList makeDrawable() {
        ColorMapRedAndGreen g = this.colormap();
        ColorMapper m = this.colormapper(g);
        ConcurrentScatterMultiColorList s = new ConcurrentScatterMultiColorList(m);
        s.setWidth(3.0f);
        return s;
    }

    public ColorMapper colormapper(ColorMapRedAndGreen g) {
        ColorMapper m = new ColorMapper(g, 0.0, 1.0){

            @Override
            public Color getColor(Coord3d coord) {
                Color out = this.colormap.getColor(this, coord.x, coord.z, coord.y);
                if (this.factor != null) {
                    out.mul(this.factor);
                }
                return out;
            }
        };
        return m;
    }

    public ColorMapRedAndGreen colormap() {
        ColorMapRedAndGreen g = new ColorMapRedAndGreen(){

            @Override
            public Color getColor(double x, double y, double z, double zMin, double zMax) {
                double rel_value = this.processRelativeZValue(z, zMin, zMax);
                float bCenter = 0.2f;
                float rCenter = 0.8f;
                float topWidth = 0.4f;
                float botWidth = 0.8f;
                float b = 0.0f;
                float v = (float)this.colorComponentRelative(rel_value, bCenter, topWidth, botWidth);
                float r = (float)this.colorComponentRelative(rel_value, rCenter, topWidth, botWidth);
                return new Color(r, v, b);
            }
        };
        g.setDirection(false);
        return g;
    }

    @Override
    public void add(float x, float y) {
        this.scatter.add(new Coord3d(x, y, 0.0f));
    }

    @Override
    public void add(double x, double y) {
        this.scatter.add(new Coord3d(x, y, 0.0));
    }

    @Override
    public void add(Coord2d c) {
        this.scatter.add(new Coord3d(c.x, c.y, 0.0f));
    }

    @Override
    public void add(Coord2d c, Color color) {
        this.scatter.add(new Coord3d(c.x, c.y, 0.0f));
    }

    @Override
    public void add(float x, float y, Color color) {
        throw new NotImplementedException();
    }

    @Override
    public void add(double x, double y, Color color) {
        throw new NotImplementedException();
    }

    @Override
    public void add(List<Coord2d> c) {
        for (Coord2d c2 : c) {
            this.scatter.add(new Coord3d(c2.x, c2.y, 0.0f));
        }
    }

    @Override
    public void setColor(Color color) {
    }

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractDrawable getDrawable() {
        return this.scatter;
    }

    @Override
    public void clear() {
        this.scatter.clear();
    }

    @Override
    public void setWidth(int width) {
        this.scatter.setWidth(width);
    }
}

