/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import java.util.Arrays;
import java.util.List;

public class Statistics {
    public static double mean(double[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            sum += values[i];
            ++count;
        }
        return sum / (double)count;
    }

    public static float mean(float[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        float sum = 0.0f;
        int count = 0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            sum += values[i];
            ++count;
        }
        return sum / (float)count;
    }

    public static float min(List<Float> values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException("Input list must have a length greater than 0");
        }
        float minv = Float.POSITIVE_INFINITY;
        for (int i = 0; i < values.size(); ++i) {
            float f = values.get(i).floatValue();
            if (Float.isNaN(f) || !(f < minv)) continue;
            minv = f;
        }
        return minv;
    }

    public static double min(double[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        double minv = Double.POSITIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i]) || !(values[i] < minv)) continue;
            minv = values[i];
        }
        return minv;
    }

    public static float min(float[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        float minv = Float.POSITIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i]) || !(values[i] < minv)) continue;
            minv = values[i];
        }
        return minv;
    }

    public static float min(float[][] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        float minv = Float.POSITIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                if (Float.isNaN(values[i][j]) || !(values[i][j] < minv)) continue;
                minv = values[i][j];
            }
        }
        return minv;
    }

    public static int min(int[][] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        int minv = Integer.MAX_VALUE;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                if (values[i][j] >= minv) continue;
                minv = values[i][j];
            }
        }
        return minv;
    }

    public static int minId(double[] values) {
        double minv = Double.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < minv)) continue;
            minv = values[i];
            index = i;
        }
        return index;
    }

    public static int minId(float[] values) {
        float minv = Float.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < minv)) continue;
            minv = values[i];
            index = i;
        }
        return index;
    }

    public static int minId(int[] values) {
        int minv = Integer.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] >= minv) continue;
            minv = values[i];
            index = i;
        }
        return index;
    }

    public static float max(List<Float> values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        float maxv = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < values.size(); ++i) {
            float f = values.get(i).floatValue();
            if (Float.isNaN(f) || !(f > maxv)) continue;
            maxv = f;
        }
        return maxv;
    }

    public static double max(double[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        double maxv = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i]) || !(values[i] > maxv)) continue;
            maxv = values[i];
        }
        return maxv;
    }

    public static float max(float[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        float maxv = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i]) || !(values[i] > maxv)) continue;
            maxv = values[i];
        }
        return maxv;
    }

    public static float max(float[][] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        float maxv = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                if (Float.isNaN(values[i][j]) || !(values[i][j] > maxv)) continue;
                maxv = values[i][j];
            }
        }
        return maxv;
    }

    public static int max(int[][] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        int maxv = Integer.MIN_VALUE;
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                if (values[i][j] <= maxv) continue;
                maxv = values[i][j];
            }
        }
        return maxv;
    }

    public static int maxId(int[] values) {
        int maxv = Integer.MIN_VALUE;
        int index = -1;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= maxv) continue;
            maxv = values[i];
            index = i;
        }
        return index;
    }

    public static double mad(double[] values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        double[] dists = new double[values.length];
        double median = Statistics.median(values, true);
        for (int i = 0; i < values.length; ++i) {
            dists[i] = Math.abs(values[i] - median);
        }
        return Statistics.median(dists, true);
    }

    public static double std(double[] values) {
        if (values.length == 0) {
            return Double.NaN;
        }
        return Math.sqrt(Statistics.variance(values));
    }

    public static double variance(double[] values) {
        double mean = Statistics.mean(values);
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            sum += Math.pow(values[i] - mean, 2.0);
            ++count;
        }
        if (count == 0) {
            return Double.NaN;
        }
        if (count == 1) {
            return 0.0;
        }
        return sum / (double)(count - 1);
    }

    public static double[] quantile(double[] values, double[] levels, boolean interpolated) {
        if (values.length == 0) {
            return new double[0];
        }
        double[] quantiles = new double[levels.length];
        double[] sorted = new double[values.length];
        System.arraycopy(values, 0, sorted, 0, values.length);
        Arrays.sort(sorted);
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i] > 100.0 || levels[i] < 0.0) {
                throw new IllegalArgumentException("input level " + levels[i] + " is out of bounds [0;100].");
            }
            double quantileIdx = (double)(sorted.length - 1) * levels[i] / 100.0;
            if (quantileIdx == (double)((int)quantileIdx)) {
                quantiles[i] = sorted[(int)quantileIdx];
                continue;
            }
            double quantileIdxCeil = Math.ceil(quantileIdx);
            double quantileIdxFloor = Math.floor(quantileIdx);
            quantiles[i] = interpolated ? sorted[(int)quantileIdxFloor] * (quantileIdxCeil - quantileIdx) + sorted[(int)quantileIdxCeil] * (quantileIdx - quantileIdxFloor) : (quantileIdx - quantileIdxFloor < quantileIdxCeil - quantileIdx ? sorted[(int)quantileIdxFloor] : sorted[(int)quantileIdxCeil]);
        }
        return quantiles;
    }

    public static double[] quantile(double[] values, double[] levels) {
        return Statistics.quantile(values, levels, true);
    }

    public static double median(double[] values, boolean interpolated) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Input array must have a length greater than 0");
        }
        double[] med = new double[]{50.0};
        double[] out = Statistics.quantile(values, med, interpolated);
        return out[0];
    }
}

