/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jzy3d.maths.Range;

public class Histogram {
    protected Range[] ranges;
    protected Map<Range, Integer> data;

    public Histogram(float min, float max, int bins) {
        this.initBins(min, max, bins);
    }

    public Histogram(List<Float> values, int bins) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (float v : values) {
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        this.initBins(min, max, bins);
        this.add(values);
    }

    private void initBins(float min, float max, int bins) {
        this.data = new HashMap<Range, Integer>(bins);
        this.ranges = new Range[bins];
        float step = (max - min) / (float)bins;
        float rmin = min;
        for (int i = 0; i < bins - 1; ++i) {
            this.ranges[i] = new Range(rmin, rmin + step);
            this.data.put(this.ranges[i], 0);
            rmin += step;
        }
        this.ranges[bins - 1] = new Range(rmin, max);
        this.data.put(this.ranges[bins - 1], 0);
    }

    public void add(List<Float> values) {
        for (float v : values) {
            this.add(v);
        }
    }

    public void add(float value) {
        for (Map.Entry<Range, Integer> e : this.data.entrySet()) {
            Range r = e.getKey();
            if (!r.isIn(value, true, true)) continue;
            e.setValue(e.getValue() + 1);
            return;
        }
        this.illegalValueException(value);
    }

    private void illegalValueException(float value) {
        StringBuilder sb = new StringBuilder();
        String m = "value could not be added to any pre-configured bin. Are you adding a value out of the min-max range you used to build " + Histogram.class.getSimpleName() + "?";
        sb.append(m + "\n");
        sb.append("min:" + this.ranges[0].getMin() + "\n");
        sb.append("max:" + this.ranges[this.ranges.length - 1].getMax() + "\n");
        sb.append("value:" + value + "\n");
        throw new IllegalArgumentException(sb.toString());
    }

    public Range[] ranges() {
        return this.ranges;
    }

    public int getCount(int bin) {
        return this.data.get(this.ranges[bin]);
    }

    public void setCount(int bin, int value) {
        this.data.put(this.ranges[bin], value);
    }

    public void console() {
        for (int i = 0; i < this.ranges.length; ++i) {
            System.out.println(this.ranges[i] + " : " + this.data.get(this.ranges[0]));
        }
    }

    public int computeMaxCount() {
        int max = Integer.MIN_VALUE;
        for (Map.Entry<Range, Integer> e : this.data.entrySet()) {
            int v = e.getValue();
            if (v <= max) continue;
            max = v;
        }
        return max;
    }
}

