/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Statistics;

public class Grid {
    protected float[] x;
    protected float[] y;
    protected float[][] z;
    protected BoundingBox3d bounds;

    public Grid() {
    }

    public Grid(float[] x, float[] y, float[][] z) {
        this.setData(x, y, z);
    }

    public Grid(int[] x, int[] y, int[][] z) {
        this.setData(x, y, z);
    }

    public void setData(float[] x, float[] y, float[][] z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setData(int[] x, int[] y, int[][] z) {
        this.x = this.toFloatArray(x);
        this.y = this.toFloatArray(y);
        this.z = this.toFloatArray(z);
    }

    public float[] getX() {
        return this.x;
    }

    public float[] getY() {
        return this.y;
    }

    public float[][] getZ() {
        return this.z;
    }

    public BoundingBox3d getBounds() {
        if (this.bounds == null) {
            this.bounds = new BoundingBox3d(Statistics.min(this.x), Statistics.max(this.x), Statistics.min(this.y), Statistics.max(this.y), Statistics.min(this.z), Statistics.max(this.z));
        }
        return this.bounds;
    }

    protected float[] toFloatArray(int[] input) {
        float[] out = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            out[i] = input[i];
        }
        return out;
    }

    protected float[][] toFloatArray(int[][] input) {
        float[][] out = new float[input.length][input[0].length];
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < input[i].length; ++j) {
                out[i][j] = input[i][j];
            }
        }
        return out;
    }
}

